/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic;

import com.liferay.faces.bridge.application.ResourceInfo;
import com.liferay.faces.bridge.renderkit.html_basic.HeadManagedBean;
import com.liferay.faces.bridge.renderkit.html_basic.HeadResponseWriter;
import com.liferay.faces.bridge.renderkit.html_basic.ResponseWriterResourceImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.RendererWrapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class ResourceRendererBridgeImpl
extends RendererWrapper
implements ComponentSystemEventListener,
StateHolder {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRendererBridgeImpl.class);
    private boolean transientFlag;
    private Renderer wrappedRenderer;

    public ResourceRendererBridgeImpl() {
    }

    public ResourceRendererBridgeImpl(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResourceInfo resourceInfo = new ResourceInfo(uiComponent);
        String resourceId = resourceInfo.getId();
        HeadManagedBean headManagedBean = HeadManagedBean.getInstance(facesContext);
        Set<String> headResourceIdsFromManagedBean = null;
        headResourceIdsFromManagedBean = headManagedBean == null ? new HashSet<String>() : headManagedBean.getHeadResourceIds();
        boolean alreadyPresentInPortalPageHead = headResourceIdsFromManagedBean.contains(resourceId);
        if (!alreadyPresentInPortalPageHead) {
            boolean ajaxRequest = facesContext.getPartialViewContext().isAjaxRequest();
            if (ajaxRequest) {
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                facesContext.setResponseWriter((ResponseWriter)new ResponseWriterResourceImpl(responseWriter));
                super.encodeEnd(facesContext, uiComponent);
                facesContext.setResponseWriter(responseWriter);
            } else {
                super.encodeEnd(facesContext, uiComponent);
                if (facesContext.getResponseWriter() instanceof HeadResponseWriter) {
                    headResourceIdsFromManagedBean.add(resourceId);
                    logger.debug("Marking resource resourceId=[{0}] as being present in the head", new Object[]{resourceId});
                }
            }
        }
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (this.wrappedRenderer instanceof ComponentSystemEventListener) {
            ComponentSystemEventListener wrappedListener = (ComponentSystemEventListener)this.wrappedRenderer;
            wrappedListener.processEvent(event);
        } else {
            logger.debug("Wrapped renderer=[{0}] does not implement ComponentSystemEventListener", new Object[]{this.wrappedRenderer});
        }
    }

    public void restoreState(FacesContext facesContext, Object state) {
        if (this.wrappedRenderer == null) {
            try {
                String wrappedRendererClassName = (String)state;
                Class<?> wrappedRendererClass = Class.forName(wrappedRendererClassName);
                this.wrappedRenderer = (Renderer)wrappedRendererClass.newInstance();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public Object saveState(FacesContext facesContext) {
        return this.wrappedRenderer.getClass().getName();
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }

    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }
}

