/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.html_basic;

import com.liferay.faces.bridge.util.NameValuePair;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class HeadResource {
    private static final String HREF = "href";
    private static final String LINK = "link";
    private static final String SCRIPT = "script";
    private List<Attribute> attributeList;
    private boolean duplicate;
    private String facesResource;
    private String facesLibrary;
    private String text;
    private String type;
    private String url;

    public HeadResource(String type, String url) {
        if (type != null) {
            type = type.toLowerCase();
        }
        this.type = type;
        this.url = url;
        this.initialize();
    }

    public HeadResource(String type, Attributes attributes) {
        if (type != null) {
            type = type.toLowerCase();
        }
        this.type = type;
        if (attributes != null) {
            this.attributeList = new ArrayList<Attribute>();
            int totalAttributes = attributes.getLength();
            for (int i = 0; i < totalAttributes; ++i) {
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                Attribute attribute = new Attribute(name, value);
                this.attributeList.add(attribute);
            }
        }
        if (LINK.equals(type)) {
            this.url = attributes.getValue(HREF);
        } else if (SCRIPT.equals(type)) {
            this.url = attributes.getValue("src");
        }
        this.initialize();
    }

    public boolean equals(Object headResource) {
        boolean equal = false;
        HeadResource otherHeadResource = (HeadResource)headResource;
        if (this.url != null && this.url.equals(otherHeadResource.getURL())) {
            equal = true;
        } else if ((LINK.equals(this.type) || SCRIPT.equals(this.type)) && this.type.equals(otherHeadResource.getType())) {
            String facesResource2 = otherHeadResource.getFacesResource();
            String facesLibrary2 = otherHeadResource.getFacesLibrary();
            if (this.facesResource != null && this.facesResource.equals(facesResource2) && this.facesLibrary != null && this.facesLibrary.equals(facesLibrary2)) {
                equal = true;
            }
        }
        return equal;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        stringBuilder.append(this.type);
        if (this.attributeList != null) {
            for (Attribute attribute : this.attributeList) {
                stringBuilder.append(" ");
                stringBuilder.append((String)attribute.getName());
                stringBuilder.append("=");
                stringBuilder.append("\"");
                stringBuilder.append((String)attribute.getValue());
                stringBuilder.append("\"");
            }
        }
        stringBuilder.append(">");
        if (this.text != null) {
            stringBuilder.append(this.text);
        }
        stringBuilder.append("<");
        stringBuilder.append("/");
        stringBuilder.append(this.type);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    protected void initialize() {
        int queryPos;
        if (this.url != null && (queryPos = this.url.indexOf("?")) > 0) {
            String[] nameValuePairs;
            String parameters = this.url.substring(queryPos + 1);
            for (String nameValuePair : nameValuePairs = parameters.split("[&]")) {
                int equalsPos = nameValuePair.indexOf("=");
                if (equalsPos > 0) {
                    String name = nameValuePair.substring(0, equalsPos);
                    if (name.endsWith("javax.faces.resource")) {
                        this.facesResource = nameValuePair.substring(equalsPos + 1);
                    } else if (name.endsWith("ln")) {
                        this.facesLibrary = nameValuePair.substring(equalsPos + 1);
                    }
                }
                if (this.facesResource != null && this.facesLibrary != null) break;
            }
        }
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public String getFacesLibrary() {
        return this.facesLibrary;
    }

    public String getFacesResource() {
        return this.facesResource;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public String getURL() {
        return this.url;
    }

    protected class Attribute
    extends NameValuePair<String, String> {
        public Attribute(String name, String value) {
            super(name, value);
        }
    }
}

