/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.bridge;

import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public abstract class ResponseWriterBridgeCompat_2_0_Impl
extends ResponseWriterWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ResponseWriterBridgeCompat_2_0_Impl.class);
    protected static final String ATTRIBUTE_AUTOCOMPLETE = "autocomplete";
    protected static final String ATTRIBUTE_ID = "id";
    protected static final String ATTRIBUTE_NAME = "name";
    protected static final String ATTRIBUTE_TYPE = "type";
    protected static final String ATTRIBUTE_VALUE = "value";
    protected static final String DOCTYPE_MARKER = "<!DOCTYPE";
    protected static final String ELEMENT_INPUT = "input";
    protected static final String TYPE_HIDDEN = "hidden";
    protected static final String VALUE_OFF = "off";
    protected static final String VIEW_STATE_MARKER = "javax.faces.ViewState";
    protected static final String XML_MARKER = "<?xml";
    private static final boolean JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE;
    protected boolean namespacedParameters;

    public ResponseWriterBridgeCompat_2_0_Impl(ResponseWriter wrappedResponseWriter) {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        PortletContainer portletContainer = bridgeContext.getPortletContainer();
        boolean portletContainerNamespacesParameters = portletContainer.isNamespacedParameters();
        this.namespacedParameters = portletContainerNamespacesParameters && JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            String data = new String(cbuf, off, len);
            if (data.startsWith(XML_MARKER) || data.startsWith(DOCTYPE_MARKER)) {
                logger.trace("filtering marker");
                int greaterThanPos = data.indexOf(">");
                if (greaterThanPos > 0) {
                    len -= greaterThanPos + 1;
                    off += greaterThanPos + 1;
                }
            }
            if (len > 0) {
                if (logger.isTraceEnabled()) {
                    String value = new String(cbuf, off, len);
                    logger.trace("writing value=[{0}]", new Object[]{value});
                }
                this.getWrapped().write(cbuf, off, len);
            }
        }
    }

    protected void writeViewStateHiddenField() throws IOException {
        FacesContext facesContext;
        this.startElement(ELEMENT_INPUT, null);
        this.writeAttribute(ATTRIBUTE_TYPE, TYPE_HIDDEN, null);
        String viewStateName = VIEW_STATE_MARKER;
        if (this.namespacedParameters) {
            facesContext = FacesContext.getCurrentInstance();
            String namingContainerId = facesContext.getViewRoot().getContainerClientId(facesContext);
            viewStateName = namingContainerId + viewStateName;
        }
        this.writeAttribute(ATTRIBUTE_NAME, viewStateName, null);
        this.writeAttribute(ATTRIBUTE_ID, viewStateName, null);
        facesContext = FacesContext.getCurrentInstance();
        String viewState = facesContext.getApplication().getStateManager().getViewState(facesContext);
        this.writeAttribute(ATTRIBUTE_VALUE, viewState, null);
        this.writeAttribute(ATTRIBUTE_AUTOCOMPLETE, VALUE_OFF, null);
        this.endElement(ELEMENT_INPUT);
    }

    static {
        boolean jsfRuntimeNamespacesViewState = true;
        Product jsf = (Product)ProductMap.getInstance().get((Object)"JSF");
        if (jsf.getTitle().equals("Mojarra") && jsf.getMajorVersion() == 2) {
            if (jsf.getMinorVersion() == 1) {
                jsfRuntimeNamespacesViewState = jsf.getRevisionVersion() >= 27;
            } else if (jsf.getMinorVersion() == 2) {
                jsfRuntimeNamespacesViewState = jsf.getRevisionVersion() >= 4;
            }
        }
        JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE = jsfRuntimeNamespacesViewState;
        logger.debug("JSF runtime [{0}] version [{1}].[{2}].[{3}] supports namespacing [{4}]: [{5}]", new Object[]{jsf.getTitle(), jsf.getMajorVersion(), jsf.getMinorVersion(), jsf.getRevisionVersion(), VIEW_STATE_MARKER, JSF_RUNTIME_SUPPORTS_NAMESPACING_VIEWSTATE});
    }
}

