/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.renderkit.bridge;

import com.liferay.faces.bridge.component.HtmlInputFile;
import com.liferay.faces.bridge.event.FileUploadEvent;
import com.liferay.faces.bridge.model.UploadedFile;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.event.FacesEvent;
import javax.faces.render.Renderer;

public class InputFileRenderer
extends Renderer {
    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        List uploadedFiles;
        super.decode(facesContext, uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        Map requestAttributeMap = externalContext.getRequestMap();
        Map uploadedFilesMap = (Map)requestAttributeMap.get("com.liferay.faces.bridge.UPLOADED_FILES");
        if (uploadedFilesMap != null && (uploadedFiles = (List)uploadedFilesMap.get(clientId)) != null && uploadedFiles.size() > 0) {
            HtmlInputFile htmlInputFile = (HtmlInputFile)uiComponent;
            htmlInputFile.setUploadedFile((UploadedFile)uploadedFiles.get(0));
            htmlInputFile.setSubmittedValue(uploadedFiles);
            for (UploadedFile uploadedFile : uploadedFiles) {
                FileUploadEvent fileUploadEvent = new FileUploadEvent(uiComponent, uploadedFile);
                uiComponent.queueEvent((FacesEvent)fileUploadEvent);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        Map attributeMap = uiComponent.getAttributes();
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("input", uiComponent);
        responseWriter.writeAttribute("id", (Object)clientId, null);
        responseWriter.writeAttribute("name", (Object)clientId, null);
        responseWriter.writeAttribute("type", (Object)"file", null);
        this.writePropertyAttribute(responseWriter, "accept", attributeMap);
        this.writePropertyAttribute(responseWriter, "size", attributeMap);
        this.writePropertyAttribute(responseWriter, "styleClass", "class", attributeMap);
        this.writePropertyAttribute(responseWriter, "accesskey", attributeMap);
        this.writePropertyAttribute(responseWriter, "dir", attributeMap);
        this.writePropertyAttribute(responseWriter, "disabled", attributeMap);
        this.writePropertyAttribute(responseWriter, "lang", attributeMap);
        this.writePropertyAttribute(responseWriter, "style", attributeMap);
        this.writePropertyAttribute(responseWriter, "tabIndex", attributeMap);
        this.writePropertyAttribute(responseWriter, "title", attributeMap);
        this.writePropertyAttribute(responseWriter, "xml:lang", attributeMap);
        this.writePropertyAttribute(responseWriter, "multiple", attributeMap);
        this.writePropertyAttribute(responseWriter, "onblur", attributeMap);
        this.writePropertyAttribute(responseWriter, "onchange", attributeMap);
        this.writePropertyAttribute(responseWriter, "onclick", attributeMap);
        this.writePropertyAttribute(responseWriter, "ondblclick", attributeMap);
        this.writePropertyAttribute(responseWriter, "onfocus", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmousedown", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmousemove", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmouseout", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmouseover", attributeMap);
        this.writePropertyAttribute(responseWriter, "onmouseup", attributeMap);
        this.writePropertyAttribute(responseWriter, "onkeydown", attributeMap);
        this.writePropertyAttribute(responseWriter, "onkeypress", attributeMap);
        this.writePropertyAttribute(responseWriter, "onkeyup", attributeMap);
        this.writePropertyAttribute(responseWriter, "onselect", attributeMap);
        responseWriter.endElement("input");
    }

    protected void writePropertyAttribute(ResponseWriter responseWriter, String name, Map<String, Object> attributeMap) throws IOException {
        String value = (String)attributeMap.get(name);
        if (value != null) {
            responseWriter.writeAttribute(name, (Object)value, name);
        }
    }

    protected void writePropertyAttribute(ResponseWriter responseWriter, String name, String property, Map<String, Object> attributeMap) throws IOException {
        String value = (String)attributeMap.get(name);
        if (value != null) {
            responseWriter.writeAttribute(name, (Object)value, property);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return submittedValue;
    }
}

