/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.event;

import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.event.PublicRenderParameterImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.StateAwareResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgePublicRenderParameterHandler;
import javax.portlet.faces.BridgeUtil;

public class IPCPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 454155161145961729L;
    private static final Logger logger = LoggerFactory.getLogger(IPCPhaseListener.class);

    public void afterPhase(PhaseEvent phaseEvent) {
        Bridge.PortletPhase portletPhase;
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        FacesContext facesContext = phaseEvent.getFacesContext();
        PhaseId phaseId = phaseEvent.getPhaseId();
        if (phaseId == PhaseId.RESTORE_VIEW) {
            this.processIncomingPublicRenderParameters(bridgeContext, facesContext);
            Bridge.PortletPhase portletPhase2 = BridgeUtil.getPortletRequestPhase();
            if (portletPhase2 == Bridge.PortletPhase.EVENT_PHASE) {
                facesContext.renderResponse();
            }
        } else if (phaseId == PhaseId.INVOKE_APPLICATION && ((portletPhase = BridgeUtil.getPortletRequestPhase()) == Bridge.PortletPhase.ACTION_PHASE || portletPhase == Bridge.PortletPhase.EVENT_PHASE)) {
            this.processOutgoingPublicRenderParameters(bridgeContext, facesContext);
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
    }

    public void processIncomingPublicRenderParameters(BridgeContext bridgeContext, FacesContext facesContext) {
        block12: {
            try {
                Map<String, String[]> publicParameterMappings = bridgeContext.getBridgeConfig().getPublicParameterMappings();
                if (publicParameterMappings == null) break block12;
                boolean invokeHandler = false;
                String portletName = bridgeContext.getPortletConfig().getPortletName();
                Map publicParameterMap = bridgeContext.getPortletRequest().getPublicParameterMap();
                Set<String> publicRenderParameterNames = publicParameterMappings.keySet();
                for (String prefixedParameterName : publicRenderParameterNames) {
                    String nonPrefixedParameterName;
                    String parameterPrefix;
                    String[] modelExpressions = publicParameterMappings.get(prefixedParameterName);
                    if (modelExpressions == null) continue;
                    int colonPos = prefixedParameterName.indexOf(":");
                    if (colonPos > 0) {
                        parameterPrefix = prefixedParameterName.substring(0, colonPos);
                        nonPrefixedParameterName = prefixedParameterName.substring(colonPos + 1);
                    } else {
                        parameterPrefix = null;
                        nonPrefixedParameterName = prefixedParameterName;
                    }
                    if (publicParameterMap.containsKey(nonPrefixedParameterName)) {
                        for (String originalModelEL : modelExpressions) {
                            String[] parameterValues = (String[])publicParameterMap.get(nonPrefixedParameterName);
                            String parameterValue = null;
                            if (parameterValues != null && parameterValues.length > 0) {
                                parameterValue = parameterValues[0];
                            }
                            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(parameterPrefix, parameterValue, originalModelEL, portletName);
                            if (logger.isTraceEnabled()) {
                                logger.trace("portletName=[{0}] public render parameter=[{1}] originalModelEL=[{2}] modifiedModelEL=[{3}] isForThisPortlet=[{4}]", new Object[]{portletName, nonPrefixedParameterName, originalModelEL, publicRenderParameter.getModifiedModelEL(), publicRenderParameter.isForThisPortlet()});
                            }
                            if (publicRenderParameter.isForThisPortlet()) {
                                logger.debug("Injecting render parameter=[{0}] value=[{1}] into expression=[{2}]", new Object[]{nonPrefixedParameterName, parameterValue, publicRenderParameter.getModifiedModelEL()});
                                invokeHandler = publicRenderParameter.injectIntoModel(facesContext);
                                continue;
                            }
                            logger.debug("NOT injecting render parameter=[{0}] value=[{1}] into expression=[{2}] because it is NOT for this portletName=[{3}]", new Object[]{nonPrefixedParameterName, parameterValue, publicRenderParameter.getModifiedModelEL(), portletName});
                        }
                        continue;
                    }
                    logger.debug("NOT injecting render parameter=[{0}] because it is not found in the public parameter map", new Object[]{nonPrefixedParameterName});
                }
                if (invokeHandler) {
                    String bridgePublicRenderParameterHandlerAttributeName = "javax.portlet.faces." + portletName + "." + "bridgePublicRenderParameterHandler";
                    logger.trace("bridgePublicRenderParameterHandlerAttributeName=[{0}]", new Object[]{bridgePublicRenderParameterHandlerAttributeName});
                    BridgePublicRenderParameterHandler bridgePublicRenderParameterHandler = (BridgePublicRenderParameterHandler)bridgeContext.getPortletContext().getAttribute(bridgePublicRenderParameterHandlerAttributeName);
                    if (bridgePublicRenderParameterHandler != null) {
                        logger.debug("Invoking {0} for class=[{1}]", new Object[]{bridgePublicRenderParameterHandler, bridgePublicRenderParameterHandler.getClass()});
                        bridgePublicRenderParameterHandler.processUpdates(facesContext);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public void processOutgoingPublicRenderParameters(BridgeContext bridgeContext, FacesContext facesContext) {
        try {
            StateAwareResponse stateAwareResponse = (StateAwareResponse)bridgeContext.getPortletResponse();
            Map<String, String[]> publicParameterMappings = bridgeContext.getBridgeConfig().getPublicParameterMappings();
            if (publicParameterMappings != null) {
                String portletName = bridgeContext.getPortletConfig().getPortletName();
                Map publicParameterMap = bridgeContext.getPortletRequest().getPublicParameterMap();
                Set<String> publicRenderParameterNames = publicParameterMappings.keySet();
                for (String prefixedParameterName : publicRenderParameterNames) {
                    String nonPrefixedParameterName;
                    String parameterPrefix;
                    String[] modelExpressions = publicParameterMappings.get(prefixedParameterName);
                    if (modelExpressions == null) continue;
                    int colonPos = prefixedParameterName.indexOf(":");
                    if (colonPos > 0) {
                        parameterPrefix = prefixedParameterName.substring(0, colonPos);
                        nonPrefixedParameterName = prefixedParameterName.substring(colonPos + 1);
                    } else {
                        parameterPrefix = null;
                        nonPrefixedParameterName = prefixedParameterName;
                    }
                    for (String originalModelEL : modelExpressions) {
                        PublicRenderParameterImpl publicRenderParameter;
                        String[] parameterValues = (String[])publicParameterMap.get(nonPrefixedParameterName);
                        String parameterValue = null;
                        if (parameterValues != null && parameterValues.length > 0) {
                            parameterValue = parameterValues[0];
                        }
                        if ((publicRenderParameter = new PublicRenderParameterImpl(parameterPrefix, parameterValue, originalModelEL, portletName)).isForThisPortlet()) {
                            String modelValue = publicRenderParameter.getModelValue(facesContext);
                            boolean modelValueHasChanged = publicRenderParameter.isModelValueChanged(facesContext);
                            if (logger.isTraceEnabled()) {
                                logger.trace("portletName=[{0}] public render parameter=[{1}] parameterValue=[{2}] modelValue=[{3}] modelValueHasChanged=[{4}]", new Object[]{portletName, nonPrefixedParameterName, parameterValue, modelValue, modelValueHasChanged});
                            }
                            if (modelValueHasChanged) {
                                logger.debug("Setting render parameter=[{0}] in response because modelValue=[{1}] has changed", new Object[]{nonPrefixedParameterName, modelValue});
                                stateAwareResponse.setRenderParameter(nonPrefixedParameterName, modelValue);
                                continue;
                            }
                            logger.debug("NOT setting render parameter=[{0}] in response because modelValue=[{1}] has NOT changed", new Object[]{nonPrefixedParameterName, modelValue});
                            continue;
                        }
                        logger.debug("NOT setting render parameter=[{0}] in response because it is NOT for this portletName=[{1}]", new Object[]{nonPrefixedParameterName, portletName});
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

