/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BridgeURL;
import com.liferay.faces.bridge.helper.WindowStateHelper;
import com.liferay.faces.bridge.util.URLUtil;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.portlet.faces.Bridge;

public abstract class BridgeURLBaseImpl
implements BridgeURL {
    private static final Logger logger = LoggerFactory.getLogger(BridgeURLBaseImpl.class);
    protected static final String PORTLET_ACTION = "portlet:action";
    protected static final String PORTLET_RENDER = "portlet:render";
    protected static final String PORTLET_RESOURCE = "portlet:resource";
    protected static final String RELATIVE_PATH_PREFIX = "../";
    private String contextPath;
    private String currentFacesViewId;
    private String contextRelativePath;
    private Boolean escaped;
    private Boolean external;
    private Boolean facesViewTarget;
    private Boolean hierarchical;
    private boolean selfReferencing;
    private Map<String, String[]> parameters;
    private Boolean pathRelative;
    private Boolean portletScheme;
    private Bridge.PortletPhase portletPhase;
    private Map<String, String[]> preservedActionParams;
    private boolean secure;
    private URI uri;
    protected BridgeConfig bridgeConfig;
    protected String url;
    protected BridgeContext bridgeContext;

    public BridgeURLBaseImpl(String url, String currentFacesViewId, BridgeContext bridgeContext) {
        this.url = url;
        this.bridgeContext = bridgeContext;
        this.contextPath = bridgeContext.getPortletRequest().getContextPath();
        this.bridgeConfig = bridgeContext.getBridgeConfig();
        this.currentFacesViewId = currentFacesViewId;
        this.preservedActionParams = bridgeContext.getPreservedActionParams();
    }

    @Override
    public String removeParameter(String name) {
        String[] values = this.getParameterMap().remove(name);
        String value = null;
        if (values != null && values.length > 0) {
            value = values[0];
        }
        return value;
    }

    @Override
    public String toString() {
        String stringValue;
        block5: {
            stringValue = null;
            try {
                BaseURL baseURL = this.toBaseURL();
                if (this.isEscaped()) {
                    StringWriter urlWriter = new StringWriter();
                    try {
                        baseURL.write((Writer)urlWriter, true);
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                        stringValue = baseURL.toString();
                    }
                    stringValue = urlWriter.toString();
                    break block5;
                }
                stringValue = baseURL.toString();
            }
            catch (MalformedURLException e) {
                logger.error((Throwable)e);
            }
        }
        return stringValue;
    }

    protected abstract BaseURL toBaseURL() throws MalformedURLException;

    protected String _toString(boolean modeChanged) {
        return this._toString(modeChanged, null);
    }

    protected String _toString(boolean modeChanged, Set<String> excludedParameterNames) {
        StringBuilder buf = new StringBuilder();
        int endPos = this.url.indexOf("?");
        if (endPos < 0) {
            endPos = this.url.length();
        }
        if (this.isPortletScheme()) {
            Bridge.PortletPhase urlPortletPhase = this.getPortletPhase();
            if (urlPortletPhase == Bridge.PortletPhase.ACTION_PHASE) {
                buf.append(this.url.substring(PORTLET_ACTION.length(), endPos));
            } else if (urlPortletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                buf.append(this.url.substring(PORTLET_RENDER.length(), endPos));
            } else {
                buf.append(this.url.substring(PORTLET_RESOURCE.length(), endPos));
            }
        } else {
            buf.append(this.url.subSequence(0, endPos));
        }
        boolean firstParam = true;
        buf.append("?");
        Set<String> parameterNames = this.getParameterNames();
        boolean foundFacesViewIdParam = false;
        boolean foundFacesViewPathParam = false;
        for (String parameterName : parameterNames) {
            boolean addParameter = false;
            String parameterValue = this.getParameter(parameterName);
            if ("javax.portlet.faces.PortletMode".equals(parameterName)) {
                if (parameterValue != null) {
                    addParameter = this.bridgeContext.getPortletRequest().isPortletModeAllowed(new PortletMode(parameterValue));
                }
            } else if ("javax.portlet.faces.Secure".equals(parameterName)) {
                addParameter = BooleanHelper.isBooleanToken((String)parameterValue);
            } else if ("javax.portlet.faces.WindowState".equals(parameterName)) {
                addParameter = WindowStateHelper.isValid(parameterValue);
            } else {
                if (!foundFacesViewIdParam) {
                    foundFacesViewIdParam = "_jsfBridgeViewId".equals(parameterName);
                }
                if (!foundFacesViewPathParam) {
                    foundFacesViewPathParam = "_jsfBridgeViewPath".equals(parameterName);
                }
                addParameter = true;
            }
            if (!addParameter || excludedParameterNames != null && excludedParameterNames.contains(parameterName)) continue;
            if (firstParam) {
                firstParam = false;
            } else {
                buf.append("&");
            }
            buf.append(parameterName);
            buf.append("=");
            buf.append(parameterValue);
        }
        if (!(foundFacesViewIdParam || foundFacesViewPathParam || !this.isFacesViewTarget() || this.isPortletScheme() || modeChanged)) {
            if (!firstParam) {
                buf.append("&");
            }
            buf.append(this.getViewIdParameterName());
            buf.append("=");
            buf.append(this.getContextRelativePath());
        }
        return buf.toString();
    }

    protected boolean matchPathAndExtension(String file1, String file2) {
        boolean match = false;
        String path1 = null;
        int lastSlashPos = file1.lastIndexOf("/");
        if (lastSlashPos > 0) {
            path1 = file1.substring(0, lastSlashPos);
        }
        String path2 = null;
        lastSlashPos = file2.lastIndexOf("/");
        if (lastSlashPos > 0) {
            path2 = file2.substring(0, lastSlashPos);
        }
        if (path1 == null && path2 == null || path1 != null && path2 != null && path1.equals(path2)) {
            String ext1 = null;
            int lastDotPos = file1.indexOf(".");
            if (lastDotPos > 0) {
                ext1 = file1.substring(lastDotPos);
            }
            String ext2 = null;
            lastDotPos = file2.indexOf(".");
            if (lastDotPos > 0) {
                ext2 = file2.substring(lastDotPos);
            }
            if (ext1 == null && ext2 == null || ext1 != null && ext2 != null && ext1.equals(ext2)) {
                match = true;
            }
        }
        return match;
    }

    @Override
    public String getContextRelativePath() {
        if (this.contextRelativePath == null) {
            int contextPathPos;
            String path;
            this.contextRelativePath = this.isExternal() ? "" : ((path = this.getURI().getPath()) != null && path.length() > 0 ? ((contextPathPos = path.indexOf(this.contextPath)) >= 0 ? path.substring(contextPathPos + this.contextPath.length()) : path) : this.currentFacesViewId);
        }
        return this.contextRelativePath;
    }

    @Override
    public boolean isEscaped() {
        if (this.escaped == null) {
            this.escaped = Boolean.FALSE;
            int questionMarkPos = this.url.indexOf("?");
            if (questionMarkPos > 0) {
                int ampersandPos = this.url.indexOf("&", questionMarkPos);
                while (ampersandPos > questionMarkPos) {
                    String subURL = this.url.substring(ampersandPos);
                    if (subURL.startsWith("&amp;")) {
                        this.escaped = Boolean.TRUE;
                        ampersandPos = this.url.indexOf("&", ampersandPos + 1);
                        continue;
                    }
                    this.escaped = Boolean.FALSE;
                    break;
                }
            }
        }
        return this.escaped;
    }

    @Override
    public boolean isAbsolute() {
        return this.getURI().isAbsolute();
    }

    @Override
    public boolean isOpaque() {
        return this.getURI().isOpaque();
    }

    @Override
    public boolean isPathRelative() {
        if (this.pathRelative == null) {
            this.pathRelative = Boolean.FALSE;
            String path = this.getURI().getPath();
            if (path != null && path.length() > 0 && (!path.startsWith("/") || path.startsWith(RELATIVE_PATH_PREFIX))) {
                this.pathRelative = Boolean.TRUE;
            }
        }
        return this.pathRelative;
    }

    @Override
    public boolean isPortletScheme() {
        if (this.portletScheme == null) {
            this.portletScheme = "portlet".equals(this.getURI().getScheme());
        }
        return this.portletScheme;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    protected boolean isRelative() {
        return !this.isAbsolute();
    }

    @Override
    public boolean isSelfReferencing() {
        return this.selfReferencing;
    }

    @Override
    public boolean isExternal() {
        if (this.external == null) {
            this.external = Boolean.FALSE;
            if (!this.isPortletScheme()) {
                if (this.isAbsolute()) {
                    this.external = Boolean.TRUE;
                } else if (!this.url.startsWith("/") && !this.url.startsWith(RELATIVE_PATH_PREFIX)) {
                    this.external = Boolean.TRUE;
                }
            }
        }
        return this.external;
    }

    @Override
    public boolean isHierarchical() {
        if (this.hierarchical == null) {
            this.hierarchical = Boolean.FALSE;
            if (this.isAbsolute() && this.getSchemeSpecificPart().startsWith("/") || this.isRelative()) {
                this.hierarchical = Boolean.TRUE;
            }
        }
        return this.hierarchical;
    }

    @Override
    public String getParameter(String name) {
        String value = null;
        Map<String, String[]> parameterMap = this.getParameterMap();
        String[] values = parameterMap.get(name);
        if (values == null) {
            PortletResponse portletResponse = this.bridgeContext.getPortletResponse();
            String responseNamespace = portletResponse.getNamespace();
            values = parameterMap.get(responseNamespace + name);
        }
        if (values != null && values.length > 0) {
            value = values[0];
        }
        return value;
    }

    @Override
    public void setParameter(String name, String[] value) {
        this.getParameterMap().put(name, value);
    }

    @Override
    public void setParameter(String name, String value) {
        this.getParameterMap().put(name, new String[]{value});
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        if (this.parameters == null) {
            this.parameters = URLUtil.parseParameterMapValuesArray(this.url);
        }
        return this.parameters;
    }

    @Override
    public Set<String> getParameterNames() {
        Map<String, String[]> parameterMap = this.getParameterMap();
        return parameterMap.keySet();
    }

    protected void setPortletModeParameter(String portletMode, PortletURL portletURL) {
        if (portletMode != null) {
            try {
                PortletMode candidatePortletMode = new PortletMode(portletMode);
                if (this.bridgeContext.getPortletRequest().isPortletModeAllowed(candidatePortletMode)) {
                    portletURL.setPortletMode(candidatePortletMode);
                }
            }
            catch (PortletModeException e) {
                logger.error((Throwable)e);
            }
        }
    }

    @Override
    public Bridge.PortletPhase getPortletPhase() {
        if (this.portletPhase == null) {
            if (this.url != null) {
                if (this.isPortletScheme()) {
                    if (this.url.startsWith(PORTLET_ACTION)) {
                        this.portletPhase = Bridge.PortletPhase.ACTION_PHASE;
                    } else if (this.url.startsWith(PORTLET_RENDER)) {
                        this.portletPhase = Bridge.PortletPhase.RENDER_PHASE;
                    } else if (this.url.startsWith(PORTLET_RESOURCE)) {
                        this.portletPhase = Bridge.PortletPhase.RESOURCE_PHASE;
                    } else {
                        this.portletPhase = Bridge.PortletPhase.RESOURCE_PHASE;
                        logger.warn("Invalid keyword after 'portlet:' in URL=[{0}]", new Object[]{this.url});
                    }
                }
            } else {
                this.portletPhase = Bridge.PortletPhase.RESOURCE_PHASE;
                logger.warn("Unable to determine portlet phase in null URL");
            }
        }
        return this.portletPhase;
    }

    protected void setRenderParameters(BaseURL baseURL) {
        Map privateParameterMap;
        Map<String, String[]> urlParameterMap = this.getParameterMap();
        PortletRequest portletRequest = this.bridgeContext.getPortletRequest();
        Map publicParameterMap = portletRequest.getPublicParameterMap();
        if (publicParameterMap != null) {
            Set publicParamterMapEntrySet = publicParameterMap.entrySet();
            for (Map.Entry mapEntry : publicParamterMapEntrySet) {
                String publicParameterName = (String)mapEntry.getKey();
                if ("javax.faces.ViewState".equals(publicParameterName) || this.preservedActionParams.containsKey(publicParameterName) || urlParameterMap.containsKey(publicParameterName)) continue;
                baseURL.setParameter(publicParameterName, (String[])mapEntry.getValue());
            }
        }
        if ((privateParameterMap = portletRequest.getPrivateParameterMap()) != null) {
            Set privateParameterMapEntrySet = privateParameterMap.entrySet();
            for (Map.Entry mapEntry : privateParameterMapEntrySet) {
                String privateParameterName = (String)mapEntry.getKey();
                if ("javax.faces.ViewState".equals(privateParameterName) || this.preservedActionParams.containsKey(privateParameterName) || urlParameterMap.containsKey(privateParameterName)) continue;
                baseURL.setParameter(privateParameterName, (String[])mapEntry.getValue());
            }
        }
    }

    protected String getSchemeSpecificPart() {
        return this.getURI().getSchemeSpecificPart();
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    protected void setSecureParameter(String secure, BaseURL baseURL) {
        if (secure != null) {
            try {
                baseURL.setSecure(BooleanHelper.toBoolean((String)secure));
            }
            catch (PortletSecurityException e) {
                logger.error((Throwable)e);
            }
        }
    }

    @Override
    public void setSelfReferencing(boolean selfReferencing) {
        this.selfReferencing = selfReferencing;
    }

    @Override
    public boolean isFacesViewTarget() {
        if (this.facesViewTarget == null) {
            String potentialFacesViewId = this.getContextRelativePath();
            if (this.currentFacesViewId != null && this.currentFacesViewId.equals(potentialFacesViewId)) {
                this.facesViewTarget = Boolean.TRUE;
            } else if ((potentialFacesViewId = this.bridgeContext.getFacesViewIdFromPath(potentialFacesViewId, false)) != null) {
                this.facesViewTarget = Boolean.TRUE;
            } else {
                potentialFacesViewId = this.getContextRelativePath();
                if (this.currentFacesViewId != null && this.matchPathAndExtension(this.currentFacesViewId, potentialFacesViewId)) {
                    logger.debug("Regarding path=[{0}] as a Faces view since it has the same path and extension as the current viewId=[{1}]", new Object[]{potentialFacesViewId, this.currentFacesViewId});
                    this.facesViewTarget = Boolean.TRUE;
                } else {
                    this.facesViewTarget = Boolean.FALSE;
                }
            }
        }
        return this.facesViewTarget;
    }

    protected URI getURI() {
        if (this.uri == null) {
            try {
                this.uri = new URI(this.url);
            }
            catch (URISyntaxException e1) {
                logger.error(e1.getMessage());
                try {
                    this.uri = new URI("");
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return this.uri;
    }

    protected String getViewIdParameterName() {
        if (this.isPortletScheme() && this.getPortletPhase() == Bridge.PortletPhase.RESOURCE_PHASE) {
            return this.bridgeConfig.getViewIdResourceParameterName();
        }
        return this.bridgeConfig.getViewIdRenderParameterName();
    }

    protected void setWindowStateParameter(String windowState, PortletURL portletURL) {
        if (windowState != null) {
            try {
                WindowState candidateWindowState = new WindowState(windowState);
                if (this.bridgeContext.getPortletRequest().isWindowStateAllowed(candidateWindowState)) {
                    portletURL.setWindowState(candidateWindowState);
                }
            }
            catch (WindowStateException e) {
                logger.error((Throwable)e);
            }
        }
    }
}

