/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url;

import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BridgeResponseURL;
import com.liferay.faces.bridge.context.url.BridgeURLBaseImpl;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public abstract class BridgeResponseURLImpl
extends BridgeURLBaseImpl
implements BridgeResponseURL {
    public BridgeResponseURLImpl(String url, String currentFacesViewId, BridgeContext bridgeContext) {
        super(url, currentFacesViewId, bridgeContext);
    }

    @Override
    public void applyToResponse(StateAwareResponse stateAwareResponse) throws PortletModeException, WindowStateException {
        Set<String> urlParameterNames = this.getParameterNames();
        for (String urlParameterName : urlParameterNames) {
            String parameterValue = this.getParameter(urlParameterName);
            if ("javax.portlet.faces.PortletMode".equals(urlParameterName)) {
                PortletRequest portletRequest;
                PortletMode portletMode = new PortletMode(parameterValue);
                BridgeRequestScope bridgeRequestScope = this.bridgeContext.getBridgeRequestScope();
                if (bridgeRequestScope == null || (portletRequest = this.bridgeContext.getPortletRequest()).getPortletMode().equals((Object)portletMode) || !portletRequest.isPortletModeAllowed(portletMode)) continue;
                stateAwareResponse.setPortletMode(portletMode);
                bridgeRequestScope.setPortletModeChanged(true);
                continue;
            }
            if ("javax.portlet.faces.WindowState".equals(urlParameterName)) {
                WindowState windowState = new WindowState(parameterValue);
                PortletRequest portletRequest = this.bridgeContext.getPortletRequest();
                if (!portletRequest.isWindowStateAllowed(windowState)) continue;
                stateAwareResponse.setWindowState(windowState);
                continue;
            }
            if ("_jsfBridgeNonFacesView".equals(urlParameterName)) {
                stateAwareResponse.setRenderParameter("_jsfBridgeNonFacesView", parameterValue);
                continue;
            }
            stateAwareResponse.setRenderParameter(urlParameterName, parameterValue);
        }
    }
}

