/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url;

import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BaseURLEncodedExternalStringImpl;
import com.liferay.faces.bridge.context.url.BaseURLNonEncodedStringImpl;
import com.liferay.faces.bridge.context.url.BaseURLRelativeStringImpl;
import com.liferay.faces.bridge.context.url.BridgeResourceURLCompatImpl;
import com.liferay.faces.bridge.context.url.PortletURLFacesTargetActionImpl;
import com.liferay.faces.bridge.context.url.PortletURLNonFacesTargetRenderImpl;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.portlet.BaseURL;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.faces.Bridge;

public class BridgeResourceURLImpl
extends BridgeResourceURLCompatImpl {
    private static final Logger logger = LoggerFactory.getLogger(BridgeResourceURLImpl.class);
    private static Set<String> EXCLUDED_PARAMETER_NAMES = new HashSet<String>();
    private boolean inProtocol;
    private PortletContainer portletContainer;
    private boolean viewLink;

    public BridgeResourceURLImpl(String url, String currentFacesViewId, BridgeContext bridgeContext) {
        super(url, currentFacesViewId, bridgeContext);
        this.portletContainer = bridgeContext.getPortletContainer();
    }

    @Override
    public void replaceBackLinkParameter(FacesContext facesContext) {
        String backLinkViewId = facesContext.getViewRoot().getViewId();
        String backLinkURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, backLinkViewId);
        String backLinkEncodedActionURL = "";
        try {
            backLinkEncodedActionURL = URLEncoder.encode(facesContext.getExternalContext().encodeActionURL(backLinkURL), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage());
        }
        String newParamName = this.removeParameter("javax.portlet.faces.BackLink");
        this.setParameter(newParamName, backLinkEncodedActionURL);
    }

    @Override
    protected BaseURL toBaseURL() throws MalformedURLException {
        Object baseURL = null;
        if (this.isOpaque()) {
            if (this.isPortletScheme()) {
                String portletMode = this.getParameter("javax.portlet.faces.PortletMode");
                boolean modeChanged = portletMode != null && portletMode.length() > 0;
                String security = this.getParameter("javax.portlet.faces.Secure");
                String windowState = this.getParameter("javax.portlet.faces.WindowState");
                String urlWithModifiedParameters = this._toString(modeChanged);
                Bridge.PortletPhase urlPortletPhase = this.getPortletPhase();
                baseURL = urlPortletPhase == Bridge.PortletPhase.ACTION_PHASE ? this.portletContainer.createActionURL(urlWithModifiedParameters) : (urlPortletPhase == Bridge.PortletPhase.RENDER_PHASE ? this.portletContainer.createRenderURL(urlWithModifiedParameters) : this.portletContainer.createResourceURL(urlWithModifiedParameters));
                if (this.isSelfReferencing()) {
                    this.setRenderParameters((BaseURL)baseURL);
                }
                if (baseURL instanceof PortletURL) {
                    PortletURL portletURL = (PortletURL)baseURL;
                    this.setPortletModeParameter(portletMode, portletURL);
                    this.setWindowStateParameter(windowState, portletURL);
                }
                this.setSecureParameter(security, (BaseURL)baseURL);
            } else {
                baseURL = new BaseURLNonEncodedStringImpl(this.url, this.getParameterMap());
            }
        } else if (this.isFaces2ResourceURL()) {
            baseURL = this.isEncodedFaces2ResourceURL() ? new BaseURLNonEncodedStringImpl(this.url, this.getParameterMap()) : this.portletContainer.createResourceURL(this.url);
        } else if (this.isExternal()) {
            baseURL = new BaseURLEncodedExternalStringImpl(this.url, this.getParameterMap(), this.bridgeContext);
        } else if (this.isPathRelative()) {
            baseURL = new BaseURLRelativeStringImpl(this.url, this.getParameterMap(), this.bridgeContext);
        } else if (this.viewLink) {
            String urlWithModifiedParameters = this._toString(false, EXCLUDED_PARAMETER_NAMES);
            String portletMode = this.getParameter("javax.portlet.faces.PortletMode");
            String windowState = this.getParameter("javax.portlet.faces.WindowState");
            boolean secure = BooleanHelper.toBoolean((String)this.getParameter("javax.portlet.faces.Secure"));
            baseURL = this.isFacesViewTarget() ? new PortletURLFacesTargetActionImpl(this.bridgeContext, urlWithModifiedParameters, portletMode, windowState, secure) : new PortletURLNonFacesTargetRenderImpl(this.bridgeContext, urlWithModifiedParameters, portletMode, windowState, secure, this.getURI().getPath());
        } else if (this.isFacesViewTarget()) {
            String urlWithModifiedParameters = this._toString(false, EXCLUDED_PARAMETER_NAMES);
            baseURL = this.portletContainer.createResourceURL(urlWithModifiedParameters);
        } else if (this.inProtocol) {
            String urlWithModifiedParameters = this._toString(false);
            ResourceURL resourceURL = this.portletContainer.createResourceURL(urlWithModifiedParameters);
            resourceURL.setResourceID(this.getContextRelativePath());
            baseURL = resourceURL;
        } else {
            baseURL = new BaseURLEncodedExternalStringImpl(this.url, this.getParameterMap(), this.bridgeContext);
        }
        return baseURL;
    }

    @Override
    public void setInProtocol(boolean inProtocol) {
        this.inProtocol = inProtocol;
    }

    @Override
    public void setViewLink(boolean viewLink) {
        this.viewLink = viewLink;
    }

    static {
        EXCLUDED_PARAMETER_NAMES.add("javax.portlet.faces.PortletMode");
        EXCLUDED_PARAMETER_NAMES.add("javax.portlet.faces.Secure");
        EXCLUDED_PARAMETER_NAMES.add("javax.portlet.faces.WindowState");
    }
}

