/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url;

import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.url.BaseURLDirectStringImpl;
import com.liferay.faces.bridge.context.url.BaseURLNonEncodedStringImpl;
import com.liferay.faces.bridge.context.url.BridgeActionURL;
import com.liferay.faces.bridge.context.url.BridgeResponseURLImpl;
import com.liferay.faces.util.helper.BooleanHelper;
import java.net.MalformedURLException;
import javax.portlet.BaseURL;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;

public class BridgeActionURLImpl
extends BridgeResponseURLImpl
implements BridgeActionURL {
    private PortletContainer portletContainer;
    private PortletRequest portletRequest;

    public BridgeActionURLImpl(String url, String currentFacesViewId, BridgeContext bridgeContext) {
        super(url, currentFacesViewId, bridgeContext);
        this.portletRequest = bridgeContext.getPortletRequest();
        this.portletContainer = bridgeContext.getPortletContainer();
    }

    @Override
    protected BaseURL toBaseURL() throws MalformedURLException {
        Object baseURL = null;
        Bridge.PortletPhase portletRequestPhase = BridgeUtil.getPortletRequestPhase();
        if (portletRequestPhase == Bridge.PortletPhase.ACTION_PHASE) {
            baseURL = new BaseURLNonEncodedStringImpl(this.url, this.getParameterMap());
        } else if (this.url.startsWith("http")) {
            baseURL = new BaseURLNonEncodedStringImpl(this.url, this.getParameterMap());
        } else if (this.url.startsWith("#") || this.isAbsolute() && this.isExternal()) {
            baseURL = new BaseURLNonEncodedStringImpl(this.url, this.getParameterMap());
        } else if (this.isExternal() || BooleanHelper.isTrueToken((String)this.getParameter("javax.portlet.faces.DirectLink"))) {
            baseURL = new BaseURLDirectStringImpl(this.url, this.getParameterMap(), this.getURI().getPath(), this.portletRequest);
        } else {
            String urlWithModifiedParameters;
            String portletMode = this.removeParameter("javax.portlet.faces.PortletMode");
            boolean modeChanged = portletMode != null && portletMode.length() > 0;
            String secure = this.removeParameter("javax.portlet.faces.Secure");
            String windowState = this.removeParameter("javax.portlet.faces.WindowState");
            if (this.isPortletScheme()) {
                urlWithModifiedParameters = this._toString(modeChanged);
                Bridge.PortletPhase urlPortletPhase = this.getPortletPhase();
                baseURL = urlPortletPhase == Bridge.PortletPhase.ACTION_PHASE ? this.portletContainer.createActionURL(urlWithModifiedParameters) : (urlPortletPhase == Bridge.PortletPhase.RENDER_PHASE ? this.portletContainer.createRenderURL(urlWithModifiedParameters) : this.portletContainer.createResourceURL(urlWithModifiedParameters));
            } else {
                urlWithModifiedParameters = this._toString(modeChanged);
                baseURL = portletRequestPhase == Bridge.PortletPhase.EVENT_PHASE ? new BaseURLNonEncodedStringImpl(urlWithModifiedParameters) : this.portletContainer.createActionURL(urlWithModifiedParameters);
            }
            if (this.isSelfReferencing()) {
                this.setRenderParameters((BaseURL)baseURL);
            }
            if (baseURL instanceof PortletURL) {
                PortletURL portletURL = (PortletURL)baseURL;
                this.setPortletModeParameter(portletMode, portletURL);
                this.setWindowStateParameter(windowState, portletURL);
            }
            this.setSecureParameter(secure, (BaseURL)baseURL);
        }
        return baseURL;
    }
}

