/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.url;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.BaseURL;
import javax.portlet.PortletSecurityException;

public class BaseURLNonEncodedStringImpl
implements BaseURL {
    private static final Logger logger = LoggerFactory.getLogger(BaseURLNonEncodedStringImpl.class);
    private String url;
    private Map<String, String[]> parameterMap;
    private String query;
    private String main;
    private String toStringValue;

    public BaseURLNonEncodedStringImpl(String urlWithParameters) {
        this.url = urlWithParameters;
        this.parameterMap = new HashMap<String, String[]>();
    }

    public BaseURLNonEncodedStringImpl(String url, Map<String, String[]> parameterMap) {
        this.url = url;
        this.parameterMap = parameterMap;
    }

    public void addProperty(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.toStringValue == null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.getMain());
            String queryString = this.getQuery();
            if (queryString.length() > 0) {
                buf.append("?");
                buf.append(queryString);
            }
            this.toStringValue = buf.toString();
        }
        return this.toStringValue;
    }

    public void write(Writer out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(Writer out, boolean escapeXML) throws IOException {
        out.write(this.url);
    }

    protected String getMain() {
        if (this.main == null) {
            int queryPos = this.url.indexOf("?");
            this.main = queryPos >= 0 ? this.url.substring(0, queryPos) : this.url;
        }
        return this.main;
    }

    public void setParameter(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void setParameter(String name, String[] values) {
        throw new UnsupportedOperationException();
    }

    public Map<String, String[]> getParameterMap() {
        throw new UnsupportedOperationException();
    }

    public void setParameters(Map<String, String[]> parameters) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String key, String value) {
        throw new UnsupportedOperationException();
    }

    protected String getQuery() {
        if (this.query == null) {
            String[] queryParameters;
            StringBuilder buf = new StringBuilder();
            String originalQuery = "";
            boolean firstParam = true;
            int pos = this.url.indexOf("?");
            if (pos >= 0) {
                originalQuery = this.url.substring(pos + 1);
            }
            pos = originalQuery.indexOf("#");
            String fragmentId = null;
            if (pos > 0) {
                fragmentId = originalQuery.substring(pos);
                originalQuery = originalQuery.substring(0, pos);
            }
            HashMap<String, Integer> parameterOccurrenceMap = new HashMap<String, Integer>(this.parameterMap.size());
            for (String queryParameter : queryParameters = originalQuery.split("[&]")) {
                if (queryParameter == null || queryParameter.length() <= 0) continue;
                String[] nameValueArray = queryParameter.split("[=]");
                String name = null;
                String[] values = null;
                if (nameValueArray.length == 1) {
                    name = nameValueArray[0];
                    values = new String[]{""};
                } else if (nameValueArray.length == 2) {
                    name = nameValueArray[0];
                    values = this.parameterMap.get(name);
                }
                if (name != null && values != null && values.length > 0) {
                    if (firstParam) {
                        firstParam = false;
                    } else {
                        buf.append("&");
                    }
                    buf.append(name);
                    buf.append("=");
                    Integer parameterOccurrences = (Integer)parameterOccurrenceMap.get(name);
                    if (parameterOccurrences == null) {
                        parameterOccurrences = new Integer(0);
                    }
                    String value = values[parameterOccurrences];
                    buf.append(value);
                    parameterOccurrences = new Integer(parameterOccurrences + 1);
                    parameterOccurrenceMap.put(name, parameterOccurrences);
                    continue;
                }
                if ("javax.portlet.faces.BackLink".equals(name)) continue;
                logger.error("Invalid name=value pair=[{0}] in URL=[{1}]", new Object[]{queryParameter, this.url});
            }
            Set<Map.Entry<String, String[]>> mapEntries = this.parameterMap.entrySet();
            for (Map.Entry<String, String[]> mapEntry : mapEntries) {
                String[] values;
                String name = mapEntry.getKey();
                if (parameterOccurrenceMap.get(name) != null || (values = mapEntry.getValue()) == null || values.length <= 0) continue;
                if (firstParam) {
                    firstParam = false;
                } else {
                    buf.append("&");
                }
                buf.append(name);
                buf.append("=");
                buf.append(values[0]);
            }
            if (fragmentId != null) {
                buf.append(fragmentId);
            }
            this.query = buf.toString();
        }
        return this.query;
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        throw new UnsupportedOperationException();
    }
}

