/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map;

import com.liferay.faces.bridge.bean.BeanManager;
import com.liferay.faces.bridge.context.map.SessionMapEntry;
import com.liferay.faces.util.map.AbstractPropertyMap;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletSession;

public class SessionMap
extends AbstractPropertyMap<Object> {
    private BeanManager beanManager;
    private PortletSession portletSession;
    private boolean preferPreDestroy;
    private int scope;

    public SessionMap(PortletSession portletSession, BeanManager beanManager, int scope, boolean preferPreDestroy) {
        this.portletSession = portletSession;
        this.scope = scope;
        this.preferPreDestroy = preferPreDestroy;
        this.beanManager = beanManager;
    }

    public void clear() {
        Set mapEntries = this.entrySet();
        if (mapEntries != null) {
            for (Map.Entry mapEntry : mapEntries) {
                Object potentialManagedBeanValue;
                String potentialManagedBeanName = (String)mapEntry.getKey();
                if (!this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue = mapEntry.getValue())) continue;
                this.beanManager.invokePreDestroyMethods(potentialManagedBeanValue, this.preferPreDestroy);
            }
        }
        super.clear();
    }

    public Object remove(Object key) {
        String potentialManagedBeanName = (String)key;
        Object potentialManagedBeanValue = super.remove(key);
        if (this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue)) {
            this.beanManager.invokePreDestroyMethods(potentialManagedBeanValue, this.preferPreDestroy);
        }
        return potentialManagedBeanValue;
    }

    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new SessionMapEntry(this.portletSession, name, this.scope);
    }

    protected void removeProperty(String name) {
        this.portletSession.removeAttribute(name, this.scope);
    }

    protected Object getProperty(String name) {
        return this.portletSession.getAttribute(name, this.scope);
    }

    protected void setProperty(String name, Object value) {
        this.portletSession.setAttribute(name, value, this.scope);
    }

    protected Enumeration<String> getPropertyNames() {
        return this.portletSession.getAttributeNames(this.scope);
    }
}

