/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.map.NamespacedParameterMap;
import com.liferay.faces.bridge.context.map.RequestParameterMap;
import com.liferay.faces.bridge.context.map.RequestParameterMapEntryMultiPart;
import com.liferay.faces.bridge.model.UploadedFile;
import com.liferay.faces.bridge.model.UploadedFileFactory;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.ResourceRequest;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.InvalidFileNameException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;

public class RequestParameterMapMultiPartImpl
extends RequestParameterMap {
    private static final Logger logger = LoggerFactory.getLogger(RequestParameterMapMultiPartImpl.class);
    private static final String CONTEXT_PARAM_UPLOADED_FILES_DIR = "javax.faces.UPLOADED_FILES_DIR";
    private static final String CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE = "javax.faces.UPLOADED_FILE_MAX_SIZE";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final int DEFAULT_FILE_MAX_SIZE = 0x6400000;
    private NamespacedParameterMap namespacedParameterMap;
    private Map<String, List<UploadedFile>> requestParameterFileMap;

    public RequestParameterMapMultiPartImpl(BridgeContext bridgeContext, ClientDataRequest clientDataRequest) {
        super(bridgeContext);
        try {
            block33: {
                PortletSession portletSession = clientDataRequest.getPortletSession();
                String uploadedFilesDir = bridgeContext.getInitParameter(CONTEXT_PARAM_UPLOADED_FILES_DIR);
                if (uploadedFilesDir == null) {
                    uploadedFilesDir = System.getProperty(JAVA_IO_TMPDIR);
                    if (logger.isDebugEnabled()) {
                        logger.debug("The web.xml context-param name=[{0}] not found, using default system property=[{1}] value=[{2}]", new Object[]{CONTEXT_PARAM_UPLOADED_FILES_DIR, JAVA_IO_TMPDIR, uploadedFilesDir});
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Using web.xml context-param name=[{0}] value=[{1}]", new Object[]{CONTEXT_PARAM_UPLOADED_FILES_DIR, uploadedFilesDir});
                }
                String sessionId = portletSession.getId();
                File uploadedFilesPath = new File(uploadedFilesDir, sessionId = sessionId.replaceAll("[^A-Za-z0-9]", ""));
                if (!uploadedFilesPath.exists()) {
                    try {
                        uploadedFilesPath.mkdirs();
                    }
                    catch (SecurityException e) {
                        uploadedFilesDir = System.getProperty(JAVA_IO_TMPDIR);
                        logger.error("Security exception message=[{0}] when trying to create unique path=[{1}] so using default system property=[{2}] value=[{3}]", new Object[]{e.getMessage(), uploadedFilesPath.toString(), JAVA_IO_TMPDIR, uploadedFilesDir});
                        uploadedFilesPath = new File(uploadedFilesDir, sessionId);
                        uploadedFilesPath.mkdirs();
                    }
                }
                DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
                diskFileItemFactory.setRepository(uploadedFilesPath);
                diskFileItemFactory.setFileCleaningTracker(null);
                diskFileItemFactory.setSizeThreshold(0);
                String uploadedFilesMaxSize = bridgeContext.getInitParameter(CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE);
                int fileMaxSize = 0x6400000;
                if (uploadedFilesMaxSize == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("The web.xml context-param name=[{0}] not found, using default=[{1}] bytes", new Object[]{CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE, 0x6400000});
                    }
                } else {
                    try {
                        fileMaxSize = Integer.parseInt(uploadedFilesMaxSize);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Using web.xml context-param name=[{0}] value=[{1}] bytes", new Object[]{CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE, fileMaxSize});
                        }
                    }
                    catch (NumberFormatException e) {
                        logger.error("Invalid value=[{0}] for web.xml context-param name=[{1}] using default=[{2}] bytes.", new Object[]{uploadedFilesMaxSize, CONTEXT_PARAM_UPLOADED_FILE_MAX_SIZE, 0x6400000});
                    }
                }
                String namespace = bridgeContext.getPortletContainer().getResponseNamespace();
                PortletFileUpload portletFileUpload = new PortletFileUpload((FileItemFactory)diskFileItemFactory);
                portletFileUpload.setFileSizeMax((long)fileMaxSize);
                this.namespacedParameterMap = new NamespacedParameterMap(namespace);
                this.requestParameterFileMap = new HashMap<String, List<UploadedFile>>();
                PortletContainer portletContainer = bridgeContext.getPortletContainer();
                Set actionRequestParameterSet = clientDataRequest.getParameterMap().entrySet();
                for (Map.Entry mapEntry : actionRequestParameterSet) {
                    String parameterName = (String)mapEntry.getKey();
                    String[] parameterValues = (String[])mapEntry.getValue();
                    if (parameterValues.length <= 0) continue;
                    String fixedRequestParameterValue = portletContainer.fixRequestParameterValue(parameterValues[0]);
                    this.namespacedParameterMap.append(parameterName, fixedRequestParameterValue);
                    logger.debug("Found in ActionRequest: {0}=[{1}]", new Object[]{parameterName, fixedRequestParameterValue});
                }
                UploadedFileFactory uploadedFileFactory = (UploadedFileFactory)BridgeFactoryFinder.getFactory(UploadedFileFactory.class);
                try {
                    FileItemIterator fileItemIterator = null;
                    if (clientDataRequest instanceof ResourceRequest) {
                        ResourceRequest resourceRequest = (ResourceRequest)clientDataRequest;
                        fileItemIterator = portletFileUpload.getItemIterator((ActionRequest)new ActionRequestAdapter(resourceRequest));
                    } else {
                        ActionRequest actionRequest = (ActionRequest)clientDataRequest;
                        fileItemIterator = portletFileUpload.getItemIterator(actionRequest);
                    }
                    boolean optimizeNamespace = BooleanHelper.toBoolean((String)bridgeContext.getInitParameter("com.liferay.faces.bridge.optimizePortletNamespace"), (boolean)false);
                    if (fileItemIterator == null) break block33;
                    int totalFiles = 0;
                    while (fileItemIterator.hasNext()) {
                        try {
                            int pos;
                            ++totalFiles;
                            FileItemStream fieldStream = fileItemIterator.next();
                            String fieldName = fieldStream.getFieldName();
                            if (optimizeNamespace && (pos = fieldName.indexOf(namespace)) >= 0) {
                                fieldName = fieldName.substring(pos + namespace.length());
                            }
                            String contentType = fieldStream.getContentType();
                            boolean formField = fieldStream.isFormField();
                            String fileName = null;
                            try {
                                fileName = fieldStream.getName();
                            }
                            catch (InvalidFileNameException e) {
                                fileName = e.getName();
                            }
                            DiskFileItem diskFileItem = (DiskFileItem)diskFileItemFactory.createItem(fieldName, contentType, formField, fileName);
                            Streams.copy((InputStream)fieldStream.openStream(), (OutputStream)diskFileItem.getOutputStream(), (boolean)true);
                            if (diskFileItem.isFormField()) {
                                String characterEncoding = clientDataRequest.getCharacterEncoding();
                                String requestParameterValue = null;
                                requestParameterValue = characterEncoding == null ? diskFileItem.getString() : diskFileItem.getString(characterEncoding);
                                String fixedRequestParameterValue = portletContainer.fixRequestParameterValue(requestParameterValue);
                                this.namespacedParameterMap.append(fieldName, fixedRequestParameterValue);
                                logger.debug("{0}=[{1}]", new Object[]{fieldName, fixedRequestParameterValue});
                                continue;
                            }
                            File tempFile = diskFileItem.getStoreLocation();
                            if (tempFile.exists()) {
                                Iterator headerNameItr;
                                String tempFileName = tempFile.getName();
                                String tempFileAbsolutePath = tempFile.getAbsolutePath();
                                String copiedFileName = this.stripIllegalCharacters(fileName);
                                String copiedFileAbsolutePath = tempFileAbsolutePath.replace(tempFileName, copiedFileName);
                                File copiedFile = new File(copiedFileAbsolutePath);
                                FileUtils.copyFile((File)tempFile, (File)copiedFile);
                                HashMap<String, List<String>> headersMap = new HashMap<String, List<String>>();
                                FileItemHeaders fileItemHeaders = fieldStream.getHeaders();
                                if (fileItemHeaders != null && (headerNameItr = fileItemHeaders.getHeaderNames()) != null) {
                                    while (headerNameItr.hasNext()) {
                                        String headerName = (String)headerNameItr.next();
                                        Iterator headerValuesItr = fileItemHeaders.getHeaders(headerName);
                                        ArrayList<String> headerValues = new ArrayList<String>();
                                        if (headerValuesItr != null) {
                                            while (headerValuesItr.hasNext()) {
                                                String headerValue = (String)headerValuesItr.next();
                                                headerValues.add(headerValue);
                                            }
                                        }
                                        headersMap.put(headerName, headerValues);
                                    }
                                }
                                HashMap<String, Object> attributeMap = new HashMap<String, Object>();
                                String id = Long.toString((long)((Object)((Object)this)).hashCode() + System.currentTimeMillis());
                                String message = null;
                                UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(copiedFileAbsolutePath, attributeMap, diskFileItem.getCharSet(), diskFileItem.getContentType(), headersMap, id, message, fileName, diskFileItem.getSize(), UploadedFile.Status.FILE_SAVED);
                                this.namespacedParameterMap.append(fieldName, copiedFileAbsolutePath);
                                this.addUploadedFile(fieldName, uploadedFile);
                                logger.debug("Received uploaded file fieldName=[{0}] fileName=[{1}]", new Object[]{fieldName, fileName});
                                continue;
                            }
                            if (fileName == null || fileName.trim().length() <= 0) continue;
                            IOException e = new IOException("Failed to copy the stream of uploaded file=[" + fileName + "] to a temporary file (possibly a zero-length uploaded file)");
                            UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                            this.addUploadedFile(fieldName, uploadedFile);
                        }
                        catch (Exception e) {
                            logger.error((Throwable)e);
                            UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                            String fieldName = Integer.toString(totalFiles);
                            this.addUploadedFile(fieldName, uploadedFile);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    UploadedFile uploadedFile = uploadedFileFactory.getUploadedFile(e);
                    this.addUploadedFile("unknown", uploadedFile);
                }
            }
            clientDataRequest.setAttribute("com.liferay.faces.bridge.UPLOADED_FILES", this.requestParameterFileMap);
            String renderKitIdParam = this.namespacedParameterMap.getFirst("javax.faces.RenderKitId");
            if (renderKitIdParam == null && (renderKitIdParam = bridgeContext.getDefaultRenderKitId()) != null) {
                this.namespacedParameterMap.append("javax.faces.RenderKitId", renderKitIdParam);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
    }

    protected void addUploadedFile(String fieldName, UploadedFile uploadedFile) {
        List<UploadedFile> uploadedFiles = this.requestParameterFileMap.get(fieldName);
        if (uploadedFiles == null) {
            uploadedFiles = new ArrayList<UploadedFile>();
            this.requestParameterFileMap.put(fieldName, uploadedFiles);
        }
        uploadedFiles.add(uploadedFile);
    }

    protected AbstractPropertyMapEntry<String> createPropertyMapEntry(String name) {
        return new RequestParameterMapEntryMultiPart(name, this.namespacedParameterMap);
    }

    protected void removeProperty(String name) {
        throw new UnsupportedOperationException();
    }

    protected String stripIllegalCharacters(String fileName) {
        String strippedFileName = fileName;
        if (fileName != null) {
            strippedFileName = fileName.replaceAll("[\\\\/\\[\\]:|<>+;=.?\"]", "-");
        }
        return strippedFileName;
    }

    protected String getProperty(String name) {
        return this.namespacedParameterMap.getFirst(name);
    }

    protected void setProperty(String name, String value) {
        throw new UnsupportedOperationException();
    }

    protected Enumeration<String> getPropertyNames() {
        return Collections.enumeration(this.namespacedParameterMap.keySet());
    }

    @Override
    protected String getRequestParameter(String name) {
        return this.namespacedParameterMap.getFirst(name);
    }

    @Override
    protected Map<String, String[]> getRequestParameterMap() {
        return this.namespacedParameterMap;
    }

    protected class ActionRequestAdapter
    implements ActionRequest {
        private ResourceRequest resourceRequest;

        public ActionRequestAdapter(ResourceRequest resourceRequest) {
            this.resourceRequest = resourceRequest;
        }

        public void removeAttribute(String name) {
            this.resourceRequest.removeAttribute(name);
        }

        public Object getAttribute(String name) {
            return this.resourceRequest.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.resourceRequest.setAttribute(name, value);
        }

        public Enumeration<String> getAttributeNames() {
            return this.resourceRequest.getAttributeNames();
        }

        public String getAuthType() {
            return this.resourceRequest.getAuthType();
        }

        public String getCharacterEncoding() {
            return this.resourceRequest.getCharacterEncoding();
        }

        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            this.resourceRequest.setCharacterEncoding(enc);
        }

        public int getContentLength() {
            return this.resourceRequest.getContentLength();
        }

        public String getContentType() {
            return this.resourceRequest.getContentType();
        }

        public String getContextPath() {
            return this.resourceRequest.getContextPath();
        }

        public Cookie[] getCookies() {
            return this.resourceRequest.getCookies();
        }

        public boolean isPortletModeAllowed(PortletMode mode) {
            return this.resourceRequest.isPortletModeAllowed(mode);
        }

        public boolean isRequestedSessionIdValid() {
            return this.resourceRequest.isRequestedSessionIdValid();
        }

        public boolean isWindowStateAllowed(WindowState state) {
            return this.resourceRequest.isWindowStateAllowed(state);
        }

        public boolean isSecure() {
            return this.resourceRequest.isSecure();
        }

        public boolean isUserInRole(String role) {
            return this.resourceRequest.isUserInRole(role);
        }

        public Locale getLocale() {
            return this.resourceRequest.getLocale();
        }

        public Enumeration<Locale> getLocales() {
            return this.resourceRequest.getLocales();
        }

        public String getMethod() {
            return this.resourceRequest.getMethod();
        }

        public String getParameter(String name) {
            return this.resourceRequest.getParameter(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.resourceRequest.getParameterMap();
        }

        public Enumeration<String> getParameterNames() {
            return this.resourceRequest.getParameterNames();
        }

        public String[] getParameterValues(String name) {
            return this.resourceRequest.getParameterValues(name);
        }

        public PortalContext getPortalContext() {
            return this.resourceRequest.getPortalContext();
        }

        public InputStream getPortletInputStream() throws IOException {
            return this.resourceRequest.getPortletInputStream();
        }

        public PortletMode getPortletMode() {
            return this.resourceRequest.getPortletMode();
        }

        public PortletSession getPortletSession() {
            return this.resourceRequest.getPortletSession();
        }

        public PortletSession getPortletSession(boolean create) {
            return this.resourceRequest.getPortletSession();
        }

        public PortletPreferences getPreferences() {
            return this.resourceRequest.getPreferences();
        }

        public Map<String, String[]> getPrivateParameterMap() {
            return this.resourceRequest.getPrivateParameterMap();
        }

        public Enumeration<String> getProperties(String name) {
            return this.resourceRequest.getProperties(name);
        }

        public String getProperty(String name) {
            return this.resourceRequest.getProperty(name);
        }

        public Enumeration<String> getPropertyNames() {
            return this.resourceRequest.getPropertyNames();
        }

        public Map<String, String[]> getPublicParameterMap() {
            return this.resourceRequest.getPublicParameterMap();
        }

        public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
            return this.resourceRequest.getReader();
        }

        public String getRemoteUser() {
            return this.resourceRequest.getRemoteUser();
        }

        public String getRequestedSessionId() {
            return this.resourceRequest.getRequestedSessionId();
        }

        public String getResponseContentType() {
            return this.resourceRequest.getResponseContentType();
        }

        public Enumeration<String> getResponseContentTypes() {
            return this.resourceRequest.getResponseContentTypes();
        }

        public String getScheme() {
            return this.resourceRequest.getScheme();
        }

        public String getServerName() {
            return this.resourceRequest.getServerName();
        }

        public int getServerPort() {
            return this.resourceRequest.getServerPort();
        }

        public Principal getUserPrincipal() {
            return this.resourceRequest.getUserPrincipal();
        }

        public String getWindowID() {
            return this.resourceRequest.getWindowID();
        }

        public WindowState getWindowState() {
            return this.resourceRequest.getWindowState();
        }
    }
}

