/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map;

import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.map.FacesViewParameterMap;
import com.liferay.faces.bridge.context.map.RequestParameterMap;
import com.liferay.faces.bridge.context.map.RequestParameterMapEntry;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;

public class RequestParameterMapImpl
extends RequestParameterMap {
    private static final Logger logger = LoggerFactory.getLogger(RequestParameterMapImpl.class);
    private static final String COM_LIFERAY_FACES_BRIDGE = "com.liferay.faces.bridge";
    private static final String PRIMEFACES_DYNAMIC_CONTENT_PARAM = "pfdrid";
    private FacesViewParameterMap facesViewParameterMap;
    private PortletContainer portletContainer;
    private PortletRequest portletRequest;
    private Map<String, String> preservedActionParameterMap;

    public RequestParameterMapImpl(BridgeContext bridgeContext) {
        super(bridgeContext);
        this.portletContainer = bridgeContext.getPortletContainer();
        this.portletRequest = bridgeContext.getPortletRequest();
    }

    protected AbstractPropertyMapEntry<String> createPropertyMapEntry(String name) {
        return new RequestParameterMapEntry(this.portletContainer, name);
    }

    protected void removeProperty(String name) {
        throw new UnsupportedOperationException();
    }

    protected FacesViewParameterMap getFacesViewParameterMap() {
        if (this.facesViewParameterMap == null) {
            this.facesViewParameterMap = new FacesViewParameterMap(this.bridgeContext);
        }
        return this.facesViewParameterMap;
    }

    protected Map<String, String> getPreservedActionParameterMap() {
        BridgeRequestScope bridgeRequestScope;
        if (this.preservedActionParameterMap == null && (bridgeRequestScope = this.bridgeContext.getBridgeRequestScope()) != null) {
            this.preservedActionParameterMap = this.bridgeContext.getBridgeRequestScope().getPreservedActionParameterMap();
        }
        return this.preservedActionParameterMap;
    }

    protected String getProperty(String name) {
        String value = null;
        if (name != null && (value = this.portletContainer.getRequestParameter(name)) == null) {
            if ("javax.faces.RenderKitId".equals(name)) {
                value = this.bridgeContext.getDefaultRenderKitId();
            } else if ("javax.faces.ViewState".equals(name)) {
                BridgeRequestScope bridgeRequestScope = this.bridgeContext.getBridgeRequestScope();
                if (bridgeRequestScope != null) {
                    value = bridgeRequestScope.getPreservedViewStateParam();
                }
            } else if (name.startsWith(COM_LIFERAY_FACES_BRIDGE)) {
                value = null;
            } else if (name.equals("_jsfBridgeAjax")) {
                value = null;
            } else if (PRIMEFACES_DYNAMIC_CONTENT_PARAM.equals(name)) {
                value = null;
            } else {
                Map<String, String> preservedActionParamMap = this.getPreservedActionParameterMap();
                if (preservedActionParamMap != null) {
                    value = preservedActionParamMap.get(name);
                }
                if (value == null) {
                    value = (String)this.getFacesViewParameterMap().get(name);
                }
            }
        }
        logger.trace("{0}=[{1}]", new Object[]{name, value});
        return value;
    }

    protected void setProperty(String name, String value) {
        throw new UnsupportedOperationException();
    }

    protected Enumeration<String> getPropertyNames() {
        Set<String> keySet;
        Map<String, String> preservedActionParamMap;
        BridgeRequestScope bridgeRequestScope;
        String viewStateParam;
        String renderKitIdParam = this.portletRequest.getParameter("javax.faces.RenderKitId");
        if (renderKitIdParam == null) {
            renderKitIdParam = this.bridgeContext.getDefaultRenderKitId();
        }
        ArrayList requestParamerNameList = Collections.list(this.portletRequest.getParameterNames());
        if (renderKitIdParam != null) {
            requestParamerNameList.add("javax.faces.RenderKitId");
        }
        if ((viewStateParam = this.portletRequest.getParameter("javax.faces.ViewState")) == null && (bridgeRequestScope = this.bridgeContext.getBridgeRequestScope()) != null && (viewStateParam = bridgeRequestScope.getPreservedViewStateParam()) != null) {
            requestParamerNameList.add("javax.faces.ViewState");
        }
        if ((preservedActionParamMap = this.getPreservedActionParameterMap()) != null) {
            keySet = preservedActionParamMap.keySet();
            for (String key : keySet) {
                requestParamerNameList.add(key);
            }
        }
        keySet = this.getFacesViewParameterMap().keySet();
        for (String key : keySet) {
            requestParamerNameList.add(key);
        }
        Enumeration<String> parameterNames = Collections.enumeration(requestParamerNameList);
        return parameterNames;
    }

    @Override
    protected String getRequestParameter(String name) {
        return this.portletRequest.getParameter(name);
    }

    @Override
    protected Map<String, String[]> getRequestParameterMap() {
        return this.portletRequest.getParameterMap();
    }
}

