/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map;

import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.map.RequestParameterMap;
import com.liferay.faces.bridge.context.map.RequestParameterMapImpl;
import com.liferay.faces.bridge.context.map.RequestParameterMapMultiPartImpl;
import com.liferay.faces.bridge.context.map.RequestParameterValuesMap;
import com.liferay.faces.bridge.context.map.RequestParameterValuesMapImpl;
import com.liferay.faces.bridge.context.map.RequestParameterValuesMapMultiPartImpl;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletRequest;

public class RequestParameterMapFactory {
    private RequestParameterMap requestParameterMap;
    private RequestParameterValuesMap requestParameterValuesMap;

    public RequestParameterMapFactory(BridgeContext bridgeContext) {
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        if (portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)portletRequest;
            String contentType = clientDataRequest.getContentType();
            Product iceFaces = (Product)ProductMap.getInstance().get((Object)"ICEfaces");
            if (contentType != null && contentType.toLowerCase().startsWith("multipart/") && !iceFaces.isDetected()) {
                RequestParameterMapMultiPartImpl requestParameterMapMultiPartImpl = new RequestParameterMapMultiPartImpl(bridgeContext, clientDataRequest);
                this.requestParameterMap = requestParameterMapMultiPartImpl;
                this.requestParameterValuesMap = new RequestParameterValuesMapMultiPartImpl(requestParameterMapMultiPartImpl);
            } else {
                this.requestParameterMap = new RequestParameterMapImpl(bridgeContext);
                this.requestParameterValuesMap = new RequestParameterValuesMapImpl(bridgeContext);
            }
        } else {
            this.requestParameterMap = new RequestParameterMapImpl(bridgeContext);
            this.requestParameterValuesMap = new RequestParameterValuesMapImpl(bridgeContext);
        }
    }

    public RequestParameterMap getRequestParameterMap() {
        return this.requestParameterMap;
    }

    public RequestParameterValuesMap getRequestParameterValuesMap() {
        return this.requestParameterValuesMap;
    }
}

