/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map;

import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class FacesViewParameterMap
extends HashMap<String, String> {
    private static final long serialVersionUID = 3213871316191406286L;
    private static final Logger logger = LoggerFactory.getLogger(FacesViewParameterMap.class);
    private static Set<String> excludedParameterNames = new HashSet<String>(3);

    public FacesViewParameterMap(BridgeContext bridgeContext) {
        String facesViewQueryString = bridgeContext.getFacesViewQueryString();
        if (facesViewQueryString != null && facesViewQueryString.length() > 0) {
            String[] queryParameters;
            for (String queryParameter : queryParameters = facesViewQueryString.split("[&]")) {
                String[] nameValueArray = queryParameter.split("[=]");
                if (nameValueArray == null) continue;
                if (nameValueArray.length == 2) {
                    String parameterName = nameValueArray[0];
                    String parameterValue = nameValueArray[1];
                    if (excludedParameterNames.contains(parameterName)) {
                        logger.debug("Excluding parameterName=[{0}]", new Object[]{parameterName});
                        continue;
                    }
                    logger.debug("Adding parameterName=[{0}] parameterValue=[{1}]", new Object[]{parameterName, parameterValue});
                    this.put(parameterName, parameterValue);
                    continue;
                }
                logger.error("Invalid name=value pair=[{0}] in facesViewQueryString=[{1}]", new Object[]{nameValueArray, facesViewQueryString});
            }
        }
    }

    static {
        excludedParameterNames.add("javax.portlet.faces.PortletMode");
        excludedParameterNames.add("javax.portlet.faces.Secure");
        excludedParameterNames.add("javax.portlet.faces.WindowState");
    }
}

