/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context.map;

import com.liferay.faces.bridge.bean.BeanManager;
import com.liferay.faces.bridge.context.map.ApplicationMapEntry;
import com.liferay.faces.util.map.AbstractPropertyMap;
import com.liferay.faces.util.map.AbstractPropertyMapEntry;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;

public class ApplicationMap
extends AbstractPropertyMap<Object> {
    private BeanManager beanManager;
    private PortletContext portletContext;
    private boolean preferPreDestroy;

    public ApplicationMap(PortletContext portletContext, BeanManager beanManager, boolean preferPreDestroy) {
        this.portletContext = portletContext;
        this.preferPreDestroy = preferPreDestroy;
        this.beanManager = beanManager;
    }

    public void clear() {
        Set mapEntries = this.entrySet();
        if (mapEntries != null) {
            for (Map.Entry mapEntry : mapEntries) {
                Object potentialManagedBeanValue;
                String potentialManagedBeanName = (String)mapEntry.getKey();
                if (!this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue = mapEntry.getValue())) continue;
                this.beanManager.invokePreDestroyMethods(potentialManagedBeanValue, this.preferPreDestroy);
            }
        }
        super.clear();
    }

    public Object remove(Object key) {
        String potentialManagedBeanName = (String)key;
        Object potentialManagedBeanValue = super.remove(key);
        if (this.beanManager.isManagedBean(potentialManagedBeanName, potentialManagedBeanValue)) {
            this.beanManager.invokePreDestroyMethods(potentialManagedBeanValue, this.preferPreDestroy);
        }
        return potentialManagedBeanValue;
    }

    protected AbstractPropertyMapEntry<Object> createPropertyMapEntry(String name) {
        return new ApplicationMapEntry(this.portletContext, name);
    }

    protected void removeProperty(String name) {
        this.portletContext.removeAttribute(name);
    }

    protected Object getProperty(String name) {
        return this.portletContext.getAttribute(name);
    }

    protected void setProperty(String name, Object value) {
        this.portletContext.setAttribute(name, value);
    }

    protected Enumeration<String> getPropertyNames() {
        return this.portletContext.getAttributeNames();
    }
}

