/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context;

import com.liferay.faces.bridge.context.RenderRedirectWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class RenderRedirectWriterImpl
extends RenderRedirectWriter {
    private Writer wrappedWriter;
    private List<OutputOperation> outputOperationList;

    public RenderRedirectWriterImpl(Writer writer) {
        this.wrappedWriter = writer;
        this.outputOperationList = new ArrayList<OutputOperation>();
    }

    @Override
    public void close() throws IOException {
        this.outputOperationList.add(new CloseOperation());
    }

    @Override
    public void discard() {
        this.outputOperationList = new ArrayList<OutputOperation>();
    }

    @Override
    public void flush() throws IOException {
        this.outputOperationList.add(new FlushOperation());
    }

    @Override
    public void render() throws IOException {
        for (OutputOperation outputOperation : this.outputOperationList) {
            outputOperation.invoke();
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (cbuf != null) {
            this.outputOperationList.add(new CbufWriteOperation(cbuf));
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.outputOperationList.add(new IntWriteOperation(c));
    }

    @Override
    public void write(String str) throws IOException {
        if (str != null) {
            this.outputOperationList.add(new StrWriteOperation(str));
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf != null) {
            this.outputOperationList.add(new CBufOffLenOutputOperation(cbuf, off, len));
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (str != null) {
            this.outputOperationList.add(new StrOffLenWriteOperation(str, off, len));
        }
    }

    public Writer getWrapped() {
        return this.wrappedWriter;
    }

    protected class StrWriteOperation
    implements OutputOperation {
        private String str;

        public StrWriteOperation(String str) {
            this.str = str;
        }

        @Override
        public void invoke() throws IOException {
            RenderRedirectWriterImpl.this.wrappedWriter.write(this.str);
        }
    }

    protected class StrOffLenWriteOperation
    implements OutputOperation {
        private String str;
        private int off;
        private int len;

        public StrOffLenWriteOperation(String str, int off, int len) {
            this.str = str;
            this.off = off;
            this.len = len;
        }

        @Override
        public void invoke() throws IOException {
            RenderRedirectWriterImpl.this.wrappedWriter.write(this.str, this.off, this.len);
        }
    }

    protected class IntWriteOperation
    implements OutputOperation {
        private int c;

        public IntWriteOperation(int c) {
            this.c = c;
        }

        @Override
        public void invoke() throws IOException {
            RenderRedirectWriterImpl.this.wrappedWriter.write(this.c);
        }
    }

    protected class FlushOperation
    implements OutputOperation {
        protected FlushOperation() {
        }

        @Override
        public void invoke() throws IOException {
            RenderRedirectWriterImpl.this.wrappedWriter.flush();
        }
    }

    protected class CloseOperation
    implements OutputOperation {
        protected CloseOperation() {
        }

        @Override
        public void invoke() throws IOException {
            RenderRedirectWriterImpl.this.wrappedWriter.close();
        }
    }

    protected class CbufWriteOperation
    implements OutputOperation {
        private char[] cbuf;

        public CbufWriteOperation(char[] cbuf) {
            this.cbuf = (char[])cbuf.clone();
        }

        @Override
        public void invoke() throws IOException {
            RenderRedirectWriterImpl.this.wrappedWriter.write(this.cbuf);
        }
    }

    protected class CBufOffLenOutputOperation
    implements OutputOperation {
        private char[] cbuf;
        private int off;
        private int len;

        public CBufOffLenOutputOperation(char[] cbuf, int off, int len) {
            this.cbuf = (char[])cbuf.clone();
            this.off = off;
            this.len = len;
        }

        @Override
        public void invoke() throws IOException {
            RenderRedirectWriterImpl.this.wrappedWriter.write(this.cbuf, this.off, this.len);
        }
    }

    protected static interface OutputOperation {
        public void invoke() throws IOException;
    }
}

