/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.config.BridgeConfigFactory;
import com.liferay.faces.bridge.config.ServletMapping;
import com.liferay.faces.bridge.context.FacesView;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.List;

public class FacesViewImpl
implements FacesView {
    private static final Logger logger = LoggerFactory.getLogger(FacesViewImpl.class);
    private static final String EXTENSION_JSP = ".jsp";
    private String viewId;
    private String extension;
    private boolean extensionMapped;
    private String navigationQueryString;
    private String servletPath;
    private boolean pathMapped;

    public FacesViewImpl(String viewId, List<String> configuredExtensions) {
        this(viewId, null, configuredExtensions);
    }

    public FacesViewImpl(String viewId, String navigationQueryString, List<String> configuredExtensions) {
        this.viewId = viewId;
        this.navigationQueryString = navigationQueryString;
        ServletMapping extensionMappedServletMapping = null;
        BridgeConfigFactory bridgeConfigFactory = (BridgeConfigFactory)BridgeFactoryFinder.getFactory(BridgeConfigFactory.class);
        BridgeConfig bridgeConfig = bridgeConfigFactory.getBridgeConfig();
        List<ServletMapping> facesServletMappings = bridgeConfig.getFacesServletMappings();
        for (ServletMapping facesServletMapping : facesServletMappings) {
            if (!facesServletMapping.isPathMapped()) continue;
            logger.debug("Attempting to determine if viewId=[{0}] is path-mapped to urlPatttern=[{1}]", new Object[]{viewId, facesServletMapping.getUrlPattern()});
            if (!facesServletMapping.isMatch(viewId)) continue;
            this.servletPath = facesServletMapping.getServletPath();
            this.pathMapped = true;
            break;
        }
        if (!this.pathMapped) {
            for (ServletMapping facesServletMapping : facesServletMappings) {
                int pos;
                if (!facesServletMapping.isExtensionMapped()) continue;
                if (extensionMappedServletMapping == null) {
                    extensionMappedServletMapping = facesServletMapping;
                }
                logger.debug("Attempting to determine if viewId=[{0}] is extension-mapped to urlPattern=[{1}]", new Object[]{viewId, facesServletMapping.getUrlPattern()});
                if (!facesServletMapping.isMatch(viewId)) continue;
                this.extension = facesServletMapping.getExtension();
                this.extensionMapped = true;
                if (!EXTENSION_JSP.equals(this.extension) || (pos = viewId.lastIndexOf(".")) <= 0) break;
                this.extension = facesServletMappings.get(0).getExtension();
                this.viewId = viewId.substring(0, pos) + this.extension;
                break;
            }
            if (!this.extensionMapped) {
                for (String extension : configuredExtensions) {
                    if (!viewId.contains(extension)) continue;
                    this.extension = extension;
                    this.extensionMapped = true;
                    logger.debug("Associated viewId=[{0}] as extension-mapped to urlPattern=[*.{1}]", new Object[]{viewId, extension});
                    break;
                }
            }
        }
    }

    @Override
    public boolean isExtensionMapped() {
        return this.extensionMapped;
    }

    @Override
    public boolean isPathMapped() {
        return this.pathMapped;
    }

    public boolean isServletMapped() {
        return this.extensionMapped || this.pathMapped;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getQueryString() {
        return this.navigationQueryString;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public String getViewId() {
        return this.viewId;
    }
}

