/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.application.view.BridgeAfterViewContentRequest;
import com.liferay.faces.bridge.application.view.BridgeAfterViewContentResponse;
import com.liferay.faces.bridge.application.view.BridgeWriteBehindSupportFactory;
import com.liferay.faces.bridge.bean.BeanManager;
import com.liferay.faces.bridge.bean.BeanManagerFactory;
import com.liferay.faces.bridge.config.BridgeConfigConstants;
import com.liferay.faces.bridge.context.ExternalContextCompat_2_2_Impl;
import com.liferay.faces.bridge.context.map.ApplicationMap;
import com.liferay.faces.bridge.context.map.InitParameterMap;
import com.liferay.faces.bridge.context.map.RequestAttributeMap;
import com.liferay.faces.bridge.context.map.RequestCookieMap;
import com.liferay.faces.bridge.context.map.SessionMap;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.bridge.util.LocaleIterator;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.portlet.ClientDataRequest;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.faces.BridgeWriteBehindResponse;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ExternalContextImpl
extends ExternalContextCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(ExternalContextImpl.class);
    private static final boolean LIFERAY_PORTAL_DETECTED = ((Product)ProductMap.getInstance().get((Object)"Liferay Portal")).isDetected();
    private static final boolean RICHFACES_DETECTED = ((Product)ProductMap.getInstance().get((Object)"RichFaces")).isDetected();
    private static final String ORG_RICHFACES_EXTENSION = "org.richfaces.extension";
    private ApplicationMap applicationMap;
    private BeanManager beanManager;
    private Map<String, Object> requestAttributeMap;
    private Iterator<Locale> requestLocales;
    private Map<String, Object> sessionMap;
    private String authType;
    private BridgeAfterViewContentRequest bridgeAfterViewContentRequest;
    private BridgeAfterViewContentResponse bridgeAfterViewContentResponse;
    private Map<String, String> initParameterMap;
    private String remoteUser;
    private Map<String, Object> requestCookieMap;
    private Locale requestLocale;
    private Principal userPrincipal;

    public ExternalContextImpl(PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse) {
        super(portletContext, portletRequest, portletResponse);
        BeanManagerFactory beanManagerFactory = (BeanManagerFactory)BridgeFactoryFinder.getFactory(BeanManagerFactory.class);
        this.beanManager = beanManagerFactory.getBeanManager();
        try {
            boolean requestChanged = false;
            boolean responseChanged = false;
            this.preInitializeObjects(requestChanged, responseChanged);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void dispatch(String path) throws IOException {
        this.bridgeContext.setProcessingAfterViewContent(false);
        logger.debug("De-activated JSP AFTER_VIEW_CONTENT");
        this.bridgeContext.dispatch(path);
    }

    public String encodeNamespace(String name) {
        if (name == null) {
            return this.bridgeContext.getResponseNamespace();
        }
        if (RICHFACES_DETECTED && name.equals(ORG_RICHFACES_EXTENSION)) {
            return name;
        }
        return this.bridgeContext.getResponseNamespace() + name;
    }

    public String encodeResourceURL(String url) {
        return this.bridgeContext.encodeResourceURL(url).toString();
    }

    public void log(String message) {
        this.portletContext.log(message);
    }

    public void log(String message, Throwable exception) {
        this.portletContext.log(message, exception);
    }

    public void redirect(String url) throws IOException {
        this.bridgeContext.redirect(url);
    }

    protected void preInitializeObjects(boolean requestChanged, boolean responseChanged) {
        if (requestChanged) {
            this.bridgeContext.setPortletRequest(this.portletRequest);
        }
        if (responseChanged) {
            this.bridgeContext.setPortletResponse(this.portletResponse);
        }
        this.portletPhase = this.bridgeContext.getPortletRequestPhase();
        String preferPreDestroyInitParam = this.getInitParameter("com.liferay.faces.bridge.preferPreDestroy");
        if (preferPreDestroyInitParam == null) {
            preferPreDestroyInitParam = this.getInitParameter("org.portletfaces.bridge.preferPreDestroy");
        }
        boolean preferPreDestroy = BooleanHelper.toBoolean((String)preferPreDestroyInitParam, (boolean)true);
        this.applicationMap = new ApplicationMap(this.portletContext, this.beanManager, preferPreDestroy);
        boolean distinctRequestScopedManagedBeans = false;
        if (LIFERAY_PORTAL_DETECTED) {
            distinctRequestScopedManagedBeans = BooleanHelper.toBoolean((String)this.getInitParameter(BridgeConfigConstants.PARAM_DISTINCT_REQUEST_SCOPED_MANAGED_BEANS), (boolean)false);
        }
        Set<String> removedAttributeNames = null;
        BridgeRequestScope bridgeRequestScope = this.bridgeContext.getBridgeRequestScope();
        removedAttributeNames = bridgeRequestScope != null ? bridgeRequestScope.getRemovedAttributeNames() : new HashSet<String>();
        this.requestAttributeMap = new RequestAttributeMap(this.portletRequest, this.beanManager, this.bridgeContext.getPortletContainer().getResponseNamespace(), preferPreDestroy, distinctRequestScopedManagedBeans, removedAttributeNames);
        this.sessionMap = new SessionMap(this.portletRequest.getPortletSession(), this.beanManager, 2, preferPreDestroy);
        this.initParameterMap = Collections.unmodifiableMap(new InitParameterMap(this.portletContext));
        this.requestContextPath = this.portletRequest.getContextPath();
        this.requestLocales = new LocaleIterator(this.portletRequest.getLocales());
    }

    public Map<String, Object> getApplicationMap() {
        return this.applicationMap;
    }

    public String getAuthType() {
        if (this.authType == null) {
            this.authType = this.portletRequest.getAuthType();
        }
        return this.authType;
    }

    public Object getContext() {
        return this.portletContext;
    }

    public boolean isUserInRole(String role) {
        return this.portletRequest.isUserInRole(role);
    }

    public String getInitParameter(String name) {
        return this.bridgeContext.getInitParameter(name);
    }

    public Map<String, String> getInitParameterMap() {
        return this.initParameterMap;
    }

    public String getRemoteUser() {
        if (this.remoteUser == null) {
            this.remoteUser = this.portletRequest.getRemoteUser();
        }
        return this.remoteUser;
    }

    public Object getRequest() {
        if (this.bridgeContext.isProcessingAfterViewContent()) {
            if (this.bridgeAfterViewContentRequest == null || this.bridgeAfterViewContentRequest.getWrapped() != this.portletRequest) {
                BridgeWriteBehindSupportFactory bridgeWriteBehindSupportFactory = (BridgeWriteBehindSupportFactory)BridgeFactoryFinder.getFactory(BridgeWriteBehindSupportFactory.class);
                this.bridgeAfterViewContentRequest = bridgeWriteBehindSupportFactory.getBridgeAfterViewContentRequest(this.portletRequest);
            }
            return this.bridgeAfterViewContentRequest;
        }
        return this.portletRequest;
    }

    public void setRequest(Object request) {
        this.portletRequest = (PortletRequest)request;
        try {
            boolean requestChanged = true;
            boolean responseChanged = false;
            this.preInitializeObjects(requestChanged, responseChanged);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public String getRequestCharacterEncoding() {
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            String requestCharacterEncoding = clientDataRequest.getCharacterEncoding();
            if (this.manageIncongruities) {
                try {
                    this.incongruityContext.setRequestCharacterEncoding(requestCharacterEncoding);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            return requestCharacterEncoding;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getRequestCharacterEncoding();
        }
        return null;
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException, IllegalStateException {
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            try {
                clientDataRequest.setCharacterEncoding(encoding);
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (this.manageIncongruities) {
            this.incongruityContext.setRequestCharacterEncoding(encoding);
        }
    }

    public String getRequestContentType() {
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            String requestContentType = null;
            requestContentType = this.isICEfacesLegacyMode(clientDataRequest) ? clientDataRequest.getResponseContentType() : clientDataRequest.getContentType();
            if (this.manageIncongruities) {
                this.incongruityContext.setRequestContentType(requestContentType);
            }
            return requestContentType;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getRequestContentType();
        }
        return null;
    }

    public String getRequestContextPath() {
        return this.requestContextPath;
    }

    public Map<String, Object> getRequestCookieMap() {
        if (this.requestCookieMap == null) {
            this.requestCookieMap = new RequestCookieMap(this.portletRequest.getCookies());
        }
        return this.requestCookieMap;
    }

    public Map<String, String> getRequestHeaderMap() {
        return this.bridgeContext.getRequestHeaderMap();
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        return this.bridgeContext.getRequestHeaderValuesMap();
    }

    public Locale getRequestLocale() {
        if (this.requestLocale == null) {
            this.requestLocale = this.portletRequest.getLocale();
        }
        return this.requestLocale;
    }

    public Iterator<Locale> getRequestLocales() {
        return this.requestLocales;
    }

    public Map<String, Object> getRequestMap() {
        return this.requestAttributeMap;
    }

    public Map<String, String> getRequestParameterMap() {
        return this.bridgeContext.getRequestParameterMap();
    }

    public Iterator<String> getRequestParameterNames() {
        return this.getRequestParameterMap().keySet().iterator();
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        return this.bridgeContext.getRequestParameterValuesMap();
    }

    public String getRequestPathInfo() {
        return this.bridgeContext.getRequestPathInfo();
    }

    public String getRequestServletPath() {
        return this.bridgeContext.getRequestServletPath();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.portletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.portletContext.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.portletContext.getResourcePaths(path);
    }

    public Object getResponse() {
        if (this.bridgeContext.isProcessingAfterViewContent()) {
            if (this.facesImplementationServletResponse == null) {
                if (this.bridgeAfterViewContentResponse == null || this.bridgeAfterViewContentResponse.getWrapped() != this.portletResponse) {
                    BridgeWriteBehindSupportFactory bridgeWriteBehindSupportFactory = (BridgeWriteBehindSupportFactory)BridgeFactoryFinder.getFactory(BridgeWriteBehindSupportFactory.class);
                    this.bridgeAfterViewContentResponse = bridgeWriteBehindSupportFactory.getBridgeAfterViewContentResponse(this.portletResponse, this.getRequestLocale());
                }
                return this.bridgeAfterViewContentResponse;
            }
            return this.facesImplementationServletResponse;
        }
        if (this.isBridgeFlashServletResponseRequired()) {
            return this.createFlashHttpServletResponse();
        }
        return this.portletResponse;
    }

    public void setResponse(Object response) {
        this.facesImplementationServletResponse = null;
        if (this.bridgeContext.isProcessingAfterViewContent()) {
            if (response instanceof HttpServletResponseWrapper) {
                this.facesImplementationServletResponse = (ServletResponse)response;
                HttpServletResponseWrapper httpServletResponseWrapper = (HttpServletResponseWrapper)response;
                ServletResponse wrappedServletResponse = httpServletResponseWrapper.getResponse();
                if (wrappedServletResponse instanceof BridgeAfterViewContentResponse) {
                    BridgeAfterViewContentResponse bridgeAfterViewContentPreResponse = (BridgeAfterViewContentResponse)wrappedServletResponse;
                    PortletResponse wrappedPortletResponse = bridgeAfterViewContentPreResponse.getWrapped();
                    BridgeWriteBehindSupportFactory bridgeWriteBehindSupportFactory = (BridgeWriteBehindSupportFactory)BridgeFactoryFinder.getFactory(BridgeWriteBehindSupportFactory.class);
                    BridgeWriteBehindResponse bridgeWriteBehindResponse = bridgeWriteBehindSupportFactory.getBridgeWriteBehindResponse((MimeResponse)wrappedPortletResponse, this.facesImplementationServletResponse);
                    this.portletResponse = (PortletResponse)bridgeWriteBehindResponse;
                } else {
                    this.portletResponse = (PortletResponse)response;
                }
            } else if (response instanceof BridgeAfterViewContentResponse) {
                BridgeAfterViewContentResponse bridgeAfterViewContentResponse = (BridgeAfterViewContentResponse)response;
                this.portletResponse = bridgeAfterViewContentResponse.getWrapped();
            } else {
                this.portletResponse = (PortletResponse)response;
            }
        } else {
            this.portletResponse = (PortletResponse)response;
        }
        try {
            boolean requestChanged = false;
            boolean responseChanged = true;
            this.preInitializeObjects(requestChanged, responseChanged);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public String getResponseCharacterEncoding() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            String characterEncoding = mimeResponse.getCharacterEncoding();
            if (this.manageIncongruities) {
                this.incongruityContext.setResponseCharacterEncoding(characterEncoding);
            }
            return characterEncoding;
        }
        if (this.manageIncongruities) {
            return this.incongruityContext.getResponseCharacterEncoding();
        }
        if (this.portletResponse instanceof StateAwareResponse) {
            String characterEncoding = (String)this.bridgeContext.getAttributes().get("com.liferay.faces.bridge.responseCharacterEncoding");
            if (characterEncoding != null) {
                return characterEncoding;
            }
            throw new IllegalStateException();
        }
        return null;
    }

    public void setResponseCharacterEncoding(String encoding) {
        if (encoding != null) {
            if (this.portletResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)this.portletResponse;
                resourceResponse.setCharacterEncoding(encoding);
            } else if (this.manageIncongruities) {
                this.incongruityContext.setResponseCharacterEncoding(encoding);
            }
        }
    }

    public String getResponseContentType() {
        if (this.portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            String responseContentType = mimeResponse.getContentType();
            if (responseContentType == null) {
                responseContentType = this.portletRequest.getResponseContentType();
            }
            return responseContentType;
        }
        throw new IllegalStateException();
    }

    public Object getSession(boolean create) {
        return this.portletRequest.getPortletSession(create);
    }

    public Map<String, Object> getSessionMap() {
        return this.sessionMap;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal == null) {
            this.userPrincipal = this.portletRequest.getUserPrincipal();
        }
        return this.userPrincipal;
    }
}

