/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.context;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.config.ServletMapping;
import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.BridgeContextCompatImpl;
import com.liferay.faces.bridge.context.FacesView;
import com.liferay.faces.bridge.context.FacesViewImpl;
import com.liferay.faces.bridge.context.IncongruityContext;
import com.liferay.faces.bridge.context.RenderRedirectWriterImpl;
import com.liferay.faces.bridge.context.map.RequestHeaderMap;
import com.liferay.faces.bridge.context.map.RequestHeaderValuesMap;
import com.liferay.faces.bridge.context.map.RequestParameterMapFactory;
import com.liferay.faces.bridge.context.url.BridgeActionURL;
import com.liferay.faces.bridge.context.url.BridgePartialActionURL;
import com.liferay.faces.bridge.context.url.BridgePartialActionURLImpl;
import com.liferay.faces.bridge.context.url.BridgeRedirectURL;
import com.liferay.faces.bridge.context.url.BridgeResourceURL;
import com.liferay.faces.bridge.context.url.BridgeURLFactory;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowStateException;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeInvalidViewPathException;

public class BridgeContextImpl
extends BridgeContextCompatImpl {
    public static final String ATTR_RESPONSE_NAMESPACE = "com.liferay.faces.bridge.responseNamespace";
    private static final String NON_NUMERIC_NAMESPACE_PREFIX = "A";
    private static final Logger logger = LoggerFactory.getLogger(BridgeContextImpl.class);
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private BridgeConfig bridgeConfig;
    private Boolean bridgeRequestScopePreserved;
    private BridgeRequestScope bridgeRequestScope;
    private BridgeURLFactory bridgeURLFactory;
    private String defaultRenderKitId;
    private Map<String, String> defaultViewIdMap;
    private FacesView facesView;
    private IncongruityContext incongruityContext;
    private List<String> preFacesRequestAttrNames;
    private PortletConfig portletConfig;
    private PortletContainer portletContainer;
    private PortletContext portletContext;
    private PortletRequest portletRequest;
    private Bridge.PortletPhase portletPhase;
    private PortletResponse portletResponse;
    private Boolean preserveActionParams;
    private Map<String, String[]> preservedActionParams;
    private boolean processingAfterViewContent;
    private boolean renderRedirect;
    private boolean renderRedirectAfterDispatch;
    private BridgeRedirectURL renderRedirectURL;
    private Boolean renderRedirectEnabled;
    private Map<String, String> requestHeaderMap;
    private Map<String, String[]> requestHeaderValuesMap;
    private Map<String, String> requestParameterMap;
    private RequestParameterMapFactory requestParameterMapFactory;
    private Map<String, String[]> requestParameterValuesMap;
    private StringWrapper requestPathInfo;
    private String requestServletPath;
    private String responseNamespace;
    private Writer responseOutputWriter;
    private String savedViewState;
    private String viewIdAndQueryString;

    public BridgeContextImpl(BridgeConfig bridgeConfig, BridgeRequestScope bridgeRequestScope, PortletConfig portletConfig, PortletContext portletContext, PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase, PortletContainer portletContainer, IncongruityContext incongruityContext) {
        this.bridgeConfig = bridgeConfig;
        this.bridgeRequestScope = bridgeRequestScope;
        this.portletConfig = portletConfig;
        this.portletContext = portletContext;
        this.portletRequest = portletRequest;
        this.portletResponse = portletResponse;
        this.portletPhase = portletPhase;
        this.portletContainer = portletContainer;
        this.incongruityContext = incongruityContext;
        this.bridgeURLFactory = (BridgeURLFactory)BridgeFactoryFinder.getFactory(BridgeURLFactory.class);
        BridgeContextImpl.setCurrentInstance(this);
    }

    @Override
    public void dispatch(String path) throws IOException {
        block9: {
            logger.debug("Acquiring dispatcher for JSP path=[{0}]", new Object[]{path});
            PortletRequestDispatcher portletRequestDispacher = this.portletContext.getRequestDispatcher(path);
            try {
                if (portletRequestDispacher != null) {
                    if (this.portletContainer.isAbleToForwardOnDispatch()) {
                        if (this.renderRedirectAfterDispatch) {
                            portletRequestDispacher.include(this.portletRequest, this.portletResponse);
                        } else if (this.portletPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
                            portletRequestDispacher.include(this.portletRequest, this.portletResponse);
                        } else {
                            portletRequestDispacher.forward(this.portletRequest, this.portletResponse);
                        }
                    } else {
                        portletRequestDispacher.include(this.portletRequest, this.portletResponse);
                    }
                    break block9;
                }
                throw new IOException("Unable to acquire PortletRequestDispatcher for path=[" + path + "]");
            }
            catch (PortletException e) {
                logger.error((Throwable)e);
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public BridgeActionURL encodeActionURL(String url) {
        logger.debug("encodeActionURL fromURL=[{0}]", new Object[]{url});
        String currentFacesViewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        BridgeActionURL bridgeActionURL = this.bridgeURLFactory.getBridgeActionURL(url, currentFacesViewId, this);
        String contextRelativeViewPath = bridgeActionURL.getContextRelativePath();
        List<String> defaultSuffixes = this.bridgeConfig.getConfiguredExtensions();
        FacesViewImpl targetFacesView = new FacesViewImpl(contextRelativeViewPath, defaultSuffixes);
        if (bridgeActionURL.isPortletScheme()) {
            String facesViewPathParameter;
            String facesViewIdParameter = bridgeActionURL.getParameter("_jsfBridgeViewId");
            if ("_jsfBridgeCurrentView".equals(facesViewIdParameter)) {
                bridgeActionURL.setSelfReferencing(true);
                bridgeActionURL.removeParameter("_jsfBridgeViewId");
            }
            if ("_jsfBridgeCurrentView".equals(facesViewPathParameter = bridgeActionURL.getParameter("_jsfBridgeViewPath"))) {
                bridgeActionURL.setSelfReferencing(true);
                bridgeActionURL.removeParameter("_jsfBridgeViewPath");
            }
        } else {
            String directLinkParam = bridgeActionURL.getParameter("javax.portlet.faces.DirectLink");
            if (BooleanHelper.isFalseToken((String)directLinkParam)) {
                bridgeActionURL.removeParameter("javax.portlet.faces.DirectLink");
            }
            if (!(bridgeActionURL.isAbsolute() || targetFacesView.isExtensionMapped() || targetFacesView.isPathMapped() || url.startsWith("#"))) {
                bridgeActionURL.setParameter("_jsfBridgeNonFacesView", contextRelativeViewPath);
            }
        }
        return bridgeActionURL;
    }

    @Override
    public BridgePartialActionURL encodePartialActionURL(String url) {
        logger.debug("encodePartialActionURL fromURL=[{0}]", new Object[]{url});
        String currentFacesViewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        BridgePartialActionURLImpl bridgePartialActionURL = new BridgePartialActionURLImpl(url, currentFacesViewId, this);
        bridgePartialActionURL.setParameter("_jsfBridgeAjax", Boolean.TRUE.toString());
        return bridgePartialActionURL;
    }

    @Override
    public BridgeRedirectURL encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        logger.debug("encodeRedirectURL fromURL=[{0}]", new Object[]{baseUrl});
        String currentFacesViewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        return this.bridgeURLFactory.getBridgeRedirectURL(baseUrl, parameters, currentFacesViewId, this);
    }

    @Override
    public BridgeResourceURL encodeResourceURL(String url) {
        FacesContext facesContext;
        BridgeResourceURL bridgeResourceURL;
        String viewLinkParam;
        logger.debug("encodeResourceURL fromURL=[{0}]", new Object[]{url});
        String currentFacesViewId = null;
        UIViewRoot uiViewRoot = FacesContext.getCurrentInstance().getViewRoot();
        if (uiViewRoot != null) {
            currentFacesViewId = uiViewRoot.getViewId();
        }
        if (BooleanHelper.isTrueToken((String)(viewLinkParam = (bridgeResourceURL = this.bridgeURLFactory.getBridgeResourceURL(url, currentFacesViewId, this)).getParameter("javax.portlet.faces.ViewLink")))) {
            bridgeResourceURL.removeParameter("javax.portlet.faces.ViewLink");
            bridgeResourceURL.setViewLink(true);
            if (bridgeResourceURL.getParameter("javax.portlet.faces.BackLink") != null) {
                facesContext = FacesContext.getCurrentInstance();
                bridgeResourceURL.replaceBackLinkParameter(facesContext);
            }
        }
        if (bridgeResourceURL.isOpaque()) {
            if (bridgeResourceURL.isPortletScheme()) {
                String facesViewPathParameter;
                String facesViewIdParameter = bridgeResourceURL.getParameter("_jsfBridgeViewId");
                if ("_jsfBridgeCurrentView".equals(facesViewIdParameter)) {
                    bridgeResourceURL.setSelfReferencing(true);
                    bridgeResourceURL.removeParameter("_jsfBridgeViewId");
                }
                if ("_jsfBridgeCurrentView".equals(facesViewPathParameter = bridgeResourceURL.getParameter("_jsfBridgeViewPath"))) {
                    bridgeResourceURL.setSelfReferencing(true);
                    bridgeResourceURL.removeParameter("_jsfBridgeViewPath");
                }
            }
        } else if (bridgeResourceURL.isHierarchical() && bridgeResourceURL.isExternal()) {
            if (bridgeResourceURL.getParameter("javax.portlet.faces.BackLink") != null) {
                facesContext = FacesContext.getCurrentInstance();
                bridgeResourceURL.replaceBackLinkParameter(facesContext);
            }
        } else if (bridgeResourceURL.isHierarchical() && !bridgeResourceURL.isExternal()) {
            if (bridgeResourceURL.getParameter("javax.portlet.faces.BackLink") != null) {
                facesContext = FacesContext.getCurrentInstance();
                bridgeResourceURL.replaceBackLinkParameter(facesContext);
            }
            if (bridgeResourceURL.getParameter("javax.portlet.faces.InProtocolResourceLink") != null) {
                bridgeResourceURL.setInProtocol(true);
                bridgeResourceURL.removeParameter("javax.portlet.faces.PortletMode");
                bridgeResourceURL.removeParameter("javax.portlet.faces.WindowState");
                String secureParam = bridgeResourceURL.getParameter("javax.portlet.faces.Secure");
                bridgeResourceURL.setSecure(BooleanHelper.isTrueToken((String)secureParam));
                bridgeResourceURL.removeParameter("javax.portlet.faces.Secure");
            }
        }
        return bridgeResourceURL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void redirect(String url) throws IOException {
        if (url != null) {
            logger.debug("redirect url=[{0}]", new Object[]{url});
            String currentFacesViewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
            BridgeRedirectURL bridgeRedirectURL = this.bridgeURLFactory.getBridgeRedirectURL(url, null, currentFacesViewId, this);
            if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE || this.portletPhase == Bridge.PortletPhase.EVENT_PHASE || this.portletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE && (url.startsWith("#") || bridgeRedirectURL.isExternal() || BooleanHelper.isTrueToken((String)bridgeRedirectURL.getParameter("javax.portlet.faces.DirectLink")))) {
                    this.bridgeRequestScope.setRedirectOccurred(true);
                    this.portletContainer.redirect(bridgeRedirectURL.toString());
                    return;
                } else if (this.portletPhase == Bridge.PortletPhase.ACTION_PHASE || this.portletPhase == Bridge.PortletPhase.EVENT_PHASE) {
                    String newViewId;
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    String oldViewId = facesContext.getViewRoot().getViewId();
                    if (oldViewId.equals(newViewId = bridgeRedirectURL.getContextRelativePath())) return;
                    ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                    UIViewRoot newViewRoot = viewHandler.createView(facesContext, newViewId);
                    facesContext.setViewRoot(newViewRoot);
                    this.partialViewContextRenderAll(facesContext);
                    facesContext.responseComplete();
                    this.getBridgeRequestScope().setRedirectOccurred(true);
                    try {
                        StateAwareResponse stateAwareResponse = (StateAwareResponse)this.portletResponse;
                        bridgeRedirectURL.applyToResponse(stateAwareResponse);
                        return;
                    }
                    catch (PortletModeException e) {
                        logger.error(e.getMessage());
                        return;
                    }
                    catch (WindowStateException e) {
                        logger.error(e.getMessage());
                    }
                    return;
                } else {
                    if (this.portletPhase != Bridge.PortletPhase.RENDER_PHASE) return;
                    if (bridgeRedirectURL.isFacesViewTarget()) {
                        this.renderRedirect = true;
                        this.renderRedirectURL = bridgeRedirectURL;
                        return;
                    } else {
                        String viewIdRenderParameterName = this.bridgeConfig.getViewIdRenderParameterName();
                        String viewIdRenderParameterValue = bridgeRedirectURL.getParameter(viewIdRenderParameterName);
                        if (viewIdRenderParameterValue == null) throw new IllegalStateException("6.1.3.1: Unable to redirect to a non-Faces view during the RENDER_PHASE.");
                        this.renderRedirect = true;
                        viewIdRenderParameterValue = URLDecoder.decode(viewIdRenderParameterValue, "UTF-8");
                        this.renderRedirectURL = bridgeRedirectURL = this.bridgeURLFactory.getBridgeRedirectURL(viewIdRenderParameterValue, null, currentFacesViewId, this);
                    }
                }
                return;
            } else {
                this.portletContainer.redirect(bridgeRedirectURL.toString());
            }
            return;
        } else {
            logger.error("redirect url=null");
        }
    }

    @Override
    public void release() {
        this.attributeMap = null;
        this.bridgeConfig = null;
        this.bridgeRequestScopePreserved = null;
        this.bridgeRequestScope = null;
        this.bridgeURLFactory = null;
        this.defaultRenderKitId = null;
        this.defaultViewIdMap = null;
        this.facesView = null;
        this.preFacesRequestAttrNames = null;
        this.portletConfig = null;
        this.portletContainer = null;
        this.portletContext = null;
        this.portletRequest = null;
        this.portletPhase = null;
        this.portletResponse = null;
        this.preserveActionParams = null;
        this.preservedActionParams = null;
        this.renderRedirect = false;
        this.renderRedirectAfterDispatch = false;
        this.renderRedirectURL = null;
        this.renderRedirectEnabled = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
        this.requestParameterMap = null;
        this.requestParameterMapFactory = null;
        this.requestParameterValuesMap = null;
        this.requestPathInfo = null;
        this.requestServletPath = null;
        this.responseNamespace = null;
        this.responseOutputWriter = null;
        this.savedViewState = null;
        this.viewIdAndQueryString = null;
        BridgeContextImpl.setCurrentInstance(null);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributeMap;
    }

    @Override
    public BridgeConfig getBridgeConfig() {
        return this.bridgeConfig;
    }

    @Override
    public BridgeRequestScope getBridgeRequestScope() {
        return this.bridgeRequestScope;
    }

    public void setBridgeRequestScopePreserved(boolean bridgeRequestScopePreserved) {
        this.bridgeRequestScopePreserved = bridgeRequestScopePreserved;
    }

    @Override
    public boolean isBridgeRequestScopePreserved() {
        if (this.bridgeRequestScopePreserved == null) {
            boolean defaultValue = false;
            String initParam = this.getInitParameter("com.liferay.faces.bridge.bridgeRequestScopePreserved");
            if (initParam == null) {
                initParam = this.getInitParameter("org.portletfaces.bridgeRequestScopePreserved");
            }
            this.bridgeRequestScopePreserved = BooleanHelper.toBoolean((String)initParam, (boolean)defaultValue);
        }
        return this.bridgeRequestScopePreserved;
    }

    @Override
    public String getDefaultRenderKitId() {
        if (this.defaultRenderKitId == null) {
            String attributeName = "javax.portlet.faces." + this.portletConfig.getPortletName() + "." + "defaultRenderKitId";
            this.defaultRenderKitId = (String)this.portletContext.getAttribute(attributeName);
        }
        return this.defaultRenderKitId;
    }

    @Override
    public Map<String, String> getDefaultViewIdMap() {
        if (this.defaultViewIdMap == null) {
            String portletName = this.portletConfig.getPortletName();
            String attrNameDefaultViewIdMap = "javax.portlet.faces." + portletName + "." + "defaultViewIdMap";
            this.defaultViewIdMap = (Map)this.portletConfig.getPortletContext().getAttribute(attrNameDefaultViewIdMap);
        }
        return this.defaultViewIdMap;
    }

    protected FacesView getFacesView() throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        if (this.facesView == null) {
            String fullViewId = this.getFacesViewIdAndQueryString();
            String viewId = null;
            String navigationQueryString = null;
            if (fullViewId != null) {
                int pos = fullViewId.indexOf("?");
                if (pos > 0) {
                    navigationQueryString = fullViewId.substring(pos + 1);
                    viewId = fullViewId.substring(0, pos);
                } else {
                    viewId = fullViewId;
                }
            }
            this.facesView = new FacesViewImpl(viewId, navigationQueryString, this.bridgeConfig.getConfiguredExtensions());
        }
        return this.facesView;
    }

    @Override
    public String getFacesViewId() throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        return this.getFacesView().getViewId();
    }

    protected String getFacesViewIdAndQueryString() throws BridgeDefaultViewNotSpecifiedException, BridgeInvalidViewPathException {
        if (this.viewIdAndQueryString == null) {
            this.viewIdAndQueryString = (String)this.portletRequest.getAttribute("javax.portlet.faces.viewId");
            if (this.viewIdAndQueryString == null) {
                String viewPath = (String)this.portletRequest.getAttribute("javax.portlet.faces.viewPath");
                if (viewPath != null) {
                    String contextPath;
                    int pos = viewPath.indexOf("?");
                    if (pos > 0) {
                        viewPath = viewPath.substring(0, pos);
                    }
                    if ((pos = viewPath.indexOf(contextPath = this.portletRequest.getContextPath())) >= 0) {
                        viewPath = viewPath.substring(pos + contextPath.length());
                    }
                    this.viewIdAndQueryString = this.getFacesViewIdFromPath(viewPath);
                    if (this.viewIdAndQueryString == null) {
                        throw new BridgeInvalidViewPathException();
                    }
                }
                if (this.viewIdAndQueryString == null) {
                    if (this.renderRedirectURL != null) {
                        this.viewIdAndQueryString = this.renderRedirectURL.toString();
                    }
                    if (this.viewIdAndQueryString == null) {
                        String requestParameterName = null;
                        requestParameterName = this.portletPhase == Bridge.PortletPhase.RESOURCE_PHASE ? this.bridgeConfig.getViewIdResourceParameterName() : this.bridgeConfig.getViewIdRenderParameterName();
                        this.viewIdAndQueryString = this.portletRequest.getParameter(requestParameterName);
                        if (this.viewIdAndQueryString == null) {
                            PortletMode currentPortletMode = this.portletRequest.getPortletMode();
                            this.viewIdAndQueryString = this.getDefaultViewIdMap().get(currentPortletMode.toString());
                            logger.debug("portlet.xml viewId=[{0}] portletMode=[{1}]", new Object[]{this.viewIdAndQueryString, currentPortletMode});
                            if (this.viewIdAndQueryString == null) {
                                throw new BridgeDefaultViewNotSpecifiedException();
                            }
                        } else {
                            logger.debug("request parameter {0}=[{1}]", new Object[]{requestParameterName, this.viewIdAndQueryString});
                        }
                    } else {
                        logger.debug("redirect viewId=[{0}]", new Object[]{this.viewIdAndQueryString});
                    }
                }
            } else {
                logger.debug("javax.portlet.faces.viewId=[{0}]", new Object[]{this.viewIdAndQueryString});
            }
        }
        return this.viewIdAndQueryString;
    }

    @Override
    public String getFacesViewIdFromPath(String viewPath) {
        return this.getFacesViewIdFromPath(viewPath, true);
    }

    @Override
    public String getFacesViewIdFromPath(String viewPath, boolean mustExist) {
        String facesViewId = null;
        List<ServletMapping> servletMappings = this.bridgeConfig.getFacesServletMappings();
        for (ServletMapping servletMapping : servletMappings) {
            logger.debug("Attempting to determine the facesViewId from {0}=[{1}]", new Object[]{"javax.portlet.faces.viewPath", viewPath});
            if (!servletMapping.isMatch(viewPath)) continue;
            if (servletMapping.isExtensionMapped()) {
                List<String> defaultSuffixes = this.bridgeConfig.getConfiguredExtensions();
                for (String defaultSuffix : defaultSuffixes) {
                    int pos = viewPath.lastIndexOf(".");
                    if (pos <= 0) continue;
                    if (mustExist) {
                        String resourcePath = viewPath.substring(0, pos) + defaultSuffix;
                        try {
                            URL resourceURL = this.getPortletContext().getResource(resourcePath);
                            if (resourceURL == null) continue;
                            facesViewId = viewPath;
                            break;
                        }
                        catch (MalformedURLException e) {
                            logger.error((Throwable)e);
                            continue;
                        }
                    }
                    facesViewId = viewPath;
                    break;
                }
                if (facesViewId == null) {
                    logger.error("Matched EXTENSION MAPPING for for urlPattern=[{0}] and viewPath=[{1}] but unable to find a facesViewId with extensions[{3}]", new Object[]{servletMapping.getUrlPattern(), viewPath, defaultSuffixes});
                }
            } else if (servletMapping.isPathMapped()) {
                facesViewId = viewPath;
            }
            if (facesViewId == null) continue;
            break;
        }
        return facesViewId;
    }

    @Override
    public String getFacesViewQueryString() {
        return this.getFacesView().getQueryString();
    }

    @Override
    public boolean isRenderRedirectAfterDispatch() {
        return this.renderRedirectAfterDispatch;
    }

    @Override
    public IncongruityContext getIncongruityContext() {
        return this.incongruityContext;
    }

    @Override
    public String getInitParameter(String name) {
        String initParameter = this.portletConfig.getInitParameter(name);
        if (initParameter == null) {
            initParameter = this.portletContext.getInitParameter(name);
        }
        return initParameter;
    }

    @Override
    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    @Override
    public PortletContainer getPortletContainer() {
        return this.portletContainer;
    }

    @Override
    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    @Override
    public PortletRequest getPortletRequest() {
        return this.portletRequest;
    }

    @Override
    public void setPortletRequest(PortletRequest portletRequest) {
        this.portletRequest = portletRequest;
        this.requestParameterMap = null;
        this.requestParameterMapFactory = null;
        this.requestParameterValuesMap = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
    }

    @Override
    public Bridge.PortletPhase getPortletRequestPhase() {
        return this.portletPhase;
    }

    @Override
    public PortletResponse getPortletResponse() {
        return this.portletResponse;
    }

    @Override
    public void setPortletResponse(PortletResponse portletResponse) {
        this.portletResponse = portletResponse;
    }

    @Override
    public List<String> getPreFacesRequestAttrNames() {
        return this.preFacesRequestAttrNames;
    }

    public void setPreFacesRequestAttrNames(List<String> preFacesRequestAttrNames) {
        this.preFacesRequestAttrNames = preFacesRequestAttrNames;
    }

    @Override
    public Map<String, String[]> getPreservedActionParams() {
        if (this.preservedActionParams == null) {
            this.preservedActionParams = new HashMap<String, String[]>();
        }
        return this.preservedActionParams;
    }

    public void setPreservedActionParams(Map<String, String[]> preservedActionParams) {
        this.preservedActionParams = preservedActionParams;
    }

    @Override
    public void setProcessingAfterViewContent(boolean processingAfterViewContent) {
        this.processingAfterViewContent = processingAfterViewContent;
    }

    @Override
    public void setRenderRedirectAfterDispatch(boolean renderRedirectAfterDispatch) {
        this.renderRedirectAfterDispatch = renderRedirectAfterDispatch;
    }

    @Override
    public BridgeRedirectURL getRenderRedirectURL() {
        return this.renderRedirectURL;
    }

    @Override
    public void setRenderRedirectURL(BridgeRedirectURL renderRedirectURL) {
        this.renderRedirectURL = renderRedirectURL;
    }

    @Override
    public Map<String, String> getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.requestHeaderMap = Collections.unmodifiableMap(new RequestHeaderMap(this.getRequestHeaderValuesMap()));
        }
        return this.requestHeaderMap;
    }

    @Override
    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this.requestHeaderValuesMap == null) {
            this.requestHeaderValuesMap = Collections.unmodifiableMap(new RequestHeaderValuesMap(this, this.getRequestParameterMap()));
        }
        return this.requestHeaderValuesMap;
    }

    @Override
    public Map<String, String> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = this.getRequestParameterMapFactory().getRequestParameterMap();
        }
        return this.requestParameterMap;
    }

    protected RequestParameterMapFactory getRequestParameterMapFactory() {
        if (this.requestParameterMapFactory == null) {
            this.requestParameterMapFactory = new RequestParameterMapFactory(this);
        }
        return this.requestParameterMapFactory;
    }

    @Override
    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            this.requestParameterValuesMap = this.getRequestParameterMapFactory().getRequestParameterValuesMap();
        }
        return this.requestParameterValuesMap;
    }

    @Override
    public String getRequestPathInfo() {
        String returnValue;
        if (this.requestPathInfo == null) {
            FacesView facesView = this.getFacesView();
            String viewId = facesView.getViewId();
            if (facesView.isExtensionMapped()) {
                returnValue = null;
                logger.debug("requestPathInfo=[{0}] EXTENSION=[{1}] viewId=[{2}]", new Object[]{returnValue, facesView.getExtension(), viewId});
            } else if (facesView.isPathMapped()) {
                returnValue = viewId.substring(facesView.getServletPath().length());
                logger.debug("requestPathInfo=[{0}] PATH=[{1}] viewId=[{2}]", new Object[]{returnValue, facesView.getServletPath(), viewId});
            } else {
                returnValue = facesView.getViewId();
                logger.debug("requestPathInfo=[{0}] servletMapping=[NONE] viewId=[{1}]", new Object[]{returnValue, viewId});
            }
            this.requestPathInfo = new StringWrapper(returnValue);
        } else {
            returnValue = this.requestPathInfo.getValue();
        }
        return returnValue;
    }

    @Override
    public String getRequestServletPath() {
        if (this.requestServletPath == null) {
            FacesView facesView = this.getFacesView();
            String viewId = facesView.getViewId();
            if (facesView.isExtensionMapped()) {
                this.requestServletPath = facesView.getViewId();
                logger.debug("requestServletPath=[{0}] extensionMapped=[{1}] viewId=[{2}]", new Object[]{this.requestServletPath, facesView.getExtension(), viewId});
            } else if (facesView.isPathMapped()) {
                this.requestServletPath = facesView.getViewId();
                int pos = this.requestServletPath.lastIndexOf("/*");
                if (pos >= 0) {
                    this.requestServletPath = this.requestServletPath.substring(0, pos);
                }
                logger.debug("requestServletPath=[{0}] pathMapped=[{1}] viewId=[{2}]", new Object[]{this.requestServletPath, facesView.getServletPath(), viewId});
            } else {
                this.requestServletPath = "";
                logger.debug("requestServletPath=[{0}] servletMapping=[NONE] viewId=[{1}]", new Object[]{this.requestServletPath, viewId});
            }
        }
        return this.requestServletPath;
    }

    @Override
    public String getResponseNamespace() {
        if (this.responseNamespace == null) {
            String optimizePortletNamespaceInitParam = this.getInitParameter("com.liferay.faces.bridge.optimizePortletNamespace");
            if (optimizePortletNamespaceInitParam == null) {
                optimizePortletNamespaceInitParam = this.getInitParameter("org.portletfaces.bridge.optimizePortletNamespace");
            }
            this.responseNamespace = this.portletContainer.getResponseNamespace();
            boolean optimizePortletNamespace = BooleanHelper.toBoolean((String)optimizePortletNamespaceInitParam, (boolean)false);
            if (optimizePortletNamespace) {
                String namespaceHashCode;
                int namespaceHashCodeLength;
                int hashCode = this.responseNamespace.hashCode();
                if (hashCode < 0) {
                    hashCode *= -1;
                }
                if ((namespaceHashCodeLength = (namespaceHashCode = Integer.toString(hashCode)).length()) > 4) {
                    namespaceHashCode = namespaceHashCode.substring(namespaceHashCodeLength - 4);
                }
                if (namespaceHashCode.length() < this.responseNamespace.length()) {
                    this.responseNamespace = NON_NUMERIC_NAMESPACE_PREFIX + namespaceHashCode;
                }
            }
        }
        return this.responseNamespace;
    }

    @Override
    public Writer getResponseOutputWriter() throws IOException {
        if (this.responseOutputWriter == null) {
            MimeResponse mimeResponse = (MimeResponse)this.portletResponse;
            if (this.portletPhase == Bridge.PortletPhase.RENDER_PHASE) {
                if (this.renderRedirectEnabled == null) {
                    this.renderRedirectEnabled = BooleanHelper.isTrueToken((String)BridgeContext.getCurrentInstance().getInitParameter("com.liferay.faces.bridge.renderRedirectEnabled"));
                }
                this.responseOutputWriter = this.renderRedirectEnabled.booleanValue() ? new RenderRedirectWriterImpl(mimeResponse.getWriter()) : mimeResponse.getWriter();
            } else {
                this.responseOutputWriter = mimeResponse.getWriter();
            }
        }
        return this.responseOutputWriter;
    }

    @Override
    public boolean isPreserveActionParams() {
        if (this.preserveActionParams == null) {
            String initParamName = "javax.portlet.faces." + this.portletConfig.getPortletName() + "." + "preserveActionParams";
            Object initParamValue = this.portletContext.getAttribute(initParamName);
            this.preserveActionParams = initParamValue != null && initParamValue instanceof Boolean ? (Boolean)initParamValue : Boolean.FALSE;
        }
        return this.preserveActionParams;
    }

    @Override
    public String getSavedViewState() {
        return this.savedViewState;
    }

    @Override
    public void setSavedViewState(String savedViewState) {
        this.savedViewState = savedViewState;
    }

    @Override
    public boolean isProcessingAfterViewContent() {
        return this.processingAfterViewContent;
    }

    @Override
    public boolean isRenderRedirect() {
        return this.renderRedirect;
    }

    protected class StringWrapper {
        private String value;

        public StringWrapper(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

