/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.container.liferay;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.container.liferay.LiferayPortalUtil;
import com.liferay.faces.bridge.container.liferay.LiferayPortletRequest;
import com.liferay.faces.bridge.container.liferay.LiferayPortletResponse;
import com.liferay.faces.bridge.container.liferay.LiferayURLFactory;
import com.liferay.faces.bridge.container.liferay.PortletContainerLiferayCompatImpl;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionResponse;
import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;

public class PortletContainerLiferayImpl
extends PortletContainerLiferayCompatImpl {
    private static final long serialVersionUID = 4751433245905676075L;
    private static final Logger logger = LoggerFactory.getLogger(PortletContainerLiferayImpl.class);
    private static final String REQ_PARAM_LIFERAY_BROWSERID = "?browserId=";
    private String NAMESPACED_P_P_COL_ID;
    private String NAMESPACED_P_P_COL_POS;
    private String NAMESPACED_P_P_COL_COUNT;
    private String NAMESPACED_P_P_MODE;
    private String NAMESPACED_P_P_STATE;
    private boolean ableToAddScriptResourceToHead;
    private boolean ableToAddScriptTextToHead;
    private boolean ableToAddStyleSheetResourceToHead;
    private boolean ableToSetHttpStatusCode;
    private boolean friendlyURLMapperEnabled;
    private int liferayBuildNumber;
    private LiferayURLFactory liferayURLFactory;
    private LiferayPortletRequest liferayPortletRequest;
    private boolean namespacedParameters;
    private String portletResponseNamespace;
    private String requestURL;
    private String responseNamespace;

    public PortletContainerLiferayImpl(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext, BridgeConfig bridgeConfig) {
        super(portletRequest, bridgeConfig);
        try {
            Boolean renderPortletResource;
            boolean runtimePortlet;
            this.portletResponseNamespace = portletResponse.getNamespace();
            LiferayPortletRequest liferayPortletRequest = new LiferayPortletRequest(portletRequest);
            ThemeDisplay themeDisplay = liferayPortletRequest.getThemeDisplay();
            this.liferayPortletRequest = liferayPortletRequest;
            this.NAMESPACED_P_P_COL_ID = this.portletResponseNamespace + "p_p_col_id";
            this.NAMESPACED_P_P_COL_POS = this.portletResponseNamespace + "p_p_col_pos";
            this.NAMESPACED_P_P_COL_COUNT = this.portletResponseNamespace + "p_p_col_count";
            this.NAMESPACED_P_P_MODE = this.portletResponseNamespace + "p_p_mode";
            this.NAMESPACED_P_P_STATE = this.portletResponseNamespace + "p_p_state";
            if (portletRequest instanceof RenderRequest) {
                PortletMode portletMode = portletRequest.getPortletMode();
                WindowState windowState = portletRequest.getWindowState();
                this.saveRenderAttributes(portletMode, windowState, themeDisplay, this.responseNamespace, portletContext);
            }
            Product liferayPortal = (Product)ProductMap.getInstance().get((Object)"Liferay Portal");
            this.liferayBuildNumber = liferayPortal.getBuildId();
            if (logger.isDebugEnabled()) {
                logger.debug("Detected Liferay build number {0}", new Object[]{Long.toString(this.liferayBuildNumber)});
            }
            boolean defaultValue = false;
            if (this.liferayBuildNumber >= 6011 || this.liferayBuildNumber >= 6005 && this.liferayBuildNumber <= 6010) {
                defaultValue = true;
            }
            boolean bl = runtimePortlet = (renderPortletResource = (Boolean)portletRequest.getAttribute("RENDER_PORTLET_RESOURCE")) != null && renderPortletResource != false;
            if (runtimePortlet) {
                this.ableToAddScriptResourceToHead = false;
                this.ableToAddScriptTextToHead = false;
                this.ableToAddStyleSheetResourceToHead = false;
            } else if (BooleanHelper.isTrueToken((String)portletRequest.getParameter("wsrp"))) {
                this.ableToAddScriptResourceToHead = false;
                this.ableToAddScriptTextToHead = false;
                this.ableToAddStyleSheetResourceToHead = false;
            } else {
                this.ableToAddScriptResourceToHead = true;
                this.ableToAddScriptTextToHead = true;
                this.ableToAddStyleSheetResourceToHead = true;
            }
            this.ableToSetHttpStatusCode = this.getContextParamAbleToSetHttpStatusCode(defaultValue);
            this.friendlyURLMapperEnabled = liferayPortletRequest.getPortlet().getFriendlyURLMapperInstance() != null;
            this.liferayURLFactory = (LiferayURLFactory)BridgeFactoryFinder.getFactory(LiferayURLFactory.class);
            this.namespacedParameters = this.isPortletRequiresNamespacedParameters(portletRequest, themeDisplay);
            logger.debug("User-Agent requested URL=[{0}]", new Object[]{this.getRequestURL()});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
    }

    @Override
    public PortletURL createRedirectURL(String fromURL, Map<String, List<String>> parameters) throws MalformedURLException {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        LiferayPortletResponse liferayPortletResponse = new LiferayPortletResponse(bridgeContext.getPortletResponse());
        PortletURL redirectURL = liferayPortletResponse.createRenderURL();
        this.copyRequestParameters(fromURL, (BaseURL)redirectURL);
        if (parameters != null) {
            Set<String> parameterNames = parameters.keySet();
            for (String parameterName : parameterNames) {
                List<String> parameterValues = parameters.get(parameterName);
                String[] parameterValuesArray = parameterValues.toArray(new String[parameterValues.size()]);
                redirectURL.setParameter(parameterName, parameterValuesArray);
            }
        }
        return redirectURL;
    }

    @Override
    public String fixRequestParameterValue(String value) {
        int pos;
        if (value != null && (pos = value.indexOf(REQ_PARAM_LIFERAY_BROWSERID)) > 0) {
            value = value.substring(0, pos);
        }
        return value;
    }

    @Override
    public void redirect(String url) throws IOException {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        PortletResponse portletResponse = bridgeContext.getPortletResponse();
        if (portletResponse instanceof ActionResponse) {
            LiferayPortletResponse liferayActionResponse = new LiferayPortletResponse(portletResponse);
            liferayActionResponse.sendRedirect(url);
        } else {
            super.redirect(url);
        }
    }

    @Override
    protected PortletURL createActionURL(MimeResponse mimeResponse) {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        return this.liferayURLFactory.getLiferayActionURL(bridgeContext, mimeResponse, this.portletResponseNamespace, this.friendlyURLMapperEnabled);
    }

    @Override
    protected PortletURL createRenderURL(MimeResponse mimeResponse) {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        return this.liferayURLFactory.getLiferayRenderURL(bridgeContext, mimeResponse, this.portletResponseNamespace, this.friendlyURLMapperEnabled);
    }

    @Override
    protected ResourceURL createResourceURL(MimeResponse mimeResponse) {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        return this.liferayURLFactory.getLiferayResourceURL(bridgeContext, mimeResponse, this.portletResponseNamespace, this.friendlyURLMapperEnabled);
    }

    protected void saveRenderAttributes(PortletMode portletMode, WindowState windowState, ThemeDisplay themeDisplay, String responseNamespace, PortletContext portletContext) {
        try {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            portletContext.setAttribute(this.NAMESPACED_P_P_COL_ID, (Object)portletDisplay.getColumnId());
            portletContext.setAttribute(this.NAMESPACED_P_P_COL_POS, (Object)Integer.toString(portletDisplay.getColumnPos()));
            portletContext.setAttribute(this.NAMESPACED_P_P_COL_COUNT, (Object)Integer.toString(portletDisplay.getColumnCount()));
            if (portletMode != null) {
                portletContext.setAttribute(this.NAMESPACED_P_P_MODE, (Object)portletMode.toString());
            }
            if (windowState != null) {
                portletContext.setAttribute(this.NAMESPACED_P_P_STATE, (Object)windowState.toString());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
    }

    @Override
    public boolean isAbleToAddScriptResourceToHead() {
        return this.ableToAddScriptResourceToHead;
    }

    @Override
    public boolean isAbleToAddScriptTextToHead() {
        return this.ableToAddScriptTextToHead;
    }

    @Override
    public boolean isAbleToAddStyleSheetResourceToHead() {
        return this.ableToAddStyleSheetResourceToHead;
    }

    @Override
    public boolean isPostRedirectGetSupported() {
        return false;
    }

    @Override
    protected boolean isMarkupHeadElementSupported() {
        return false;
    }

    @Override
    public boolean isAbleToSetHttpStatusCode() {
        return this.ableToSetHttpStatusCode;
    }

    protected String getEncodedRequestParameterValue(PortletRequest portletRequest, String parameterName) {
        String encodedRequestParameterValue = portletRequest.getParameter(parameterName);
        if (encodedRequestParameterValue != null) {
            try {
                encodedRequestParameterValue = URLEncoder.encode(encodedRequestParameterValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return encodedRequestParameterValue;
    }

    @Override
    public boolean isAbleToForwardOnDispatch() {
        return false;
    }

    @Override
    public String[] getHeader(String name) {
        return this.liferayPortletRequest.getHeader(name);
    }

    @Override
    public long getHttpServletRequestDateHeader(String name) {
        return this.liferayPortletRequest.getDateHeader(name);
    }

    @Override
    public String getRequestURL() {
        if (this.requestURL == null) {
            StringBuilder buf = new StringBuilder();
            ThemeDisplay themeDisplay = this.liferayPortletRequest.getThemeDisplay();
            buf.append(themeDisplay.getURLPortal());
            buf.append(themeDisplay.getURLCurrent());
            this.requestURL = buf.toString();
        }
        return this.requestURL;
    }

    @Override
    public String getResponseNamespace() {
        if (this.responseNamespace == null) {
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            this.responseNamespace = bridgeContext.getPortletResponse().getNamespace();
            if (this.responseNamespace.startsWith("wsrp_rewrite")) {
                this.responseNamespace = LiferayPortalUtil.getPortletId(bridgeContext.getPortletRequest());
            }
        }
        return this.responseNamespace;
    }

    @Override
    public boolean isNamespacedParameters() {
        return this.namespacedParameters;
    }
}

