/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.container.liferay;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.container.PortletContainerImpl;
import com.liferay.faces.bridge.container.liferay.LiferaySharedPageTop;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.renderkit.html_basic.HeadResponseWriter;
import com.liferay.faces.bridge.renderkit.html_basic.HeadResponseWriterLiferayImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.taglib.util.OutputData;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class PortletContainerLiferayCompatImpl
extends PortletContainerImpl {
    private static final long serialVersionUID = 8713570232856573935L;
    private static final Logger logger = LoggerFactory.getLogger(PortletContainerLiferayCompatImpl.class);
    private int liferaySharedPageTopLength;

    public PortletContainerLiferayCompatImpl(PortletRequest portletRequest, BridgeConfig bridgeConfig) {
        super(portletRequest, bridgeConfig);
    }

    @Override
    public void afterPhase(PhaseEvent phaseEvent) {
        PortletRequest portletRequest;
        StringBundler pageTop;
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        if (this.liferaySharedPageTopLength > 0 && (pageTop = this.getPageTop(portletRequest = bridgeContext.getPortletRequest())) != null) {
            LiferaySharedPageTop liferaySharedPageTop = new LiferaySharedPageTop(pageTop);
            liferaySharedPageTop.removeDuplicates();
            pageTop = liferaySharedPageTop.toStringBundler();
            this.setPageTop(portletRequest, pageTop);
        }
    }

    @Override
    public void beforePhase(PhaseEvent phaseEvent) {
        this.liferaySharedPageTopLength = 0;
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        StringBundler pageTop = this.getPageTop(portletRequest);
        if (pageTop != null) {
            this.liferaySharedPageTopLength = pageTop.length();
        }
    }

    @Override
    public HeadResponseWriter getHeadResponseWriter(ResponseWriter wrappableResponseWriter) {
        HeadResponseWriterLiferayImpl headResponseWriter = new HeadResponseWriterLiferayImpl(wrappableResponseWriter);
        return headResponseWriter;
    }

    protected StringBundler getPageTop(PortletRequest portletRequest) {
        StringBundler pageTop = null;
        OutputData outputData = (OutputData)portletRequest.getAttribute("LIFERAY_SHARED_OUTPUT_DATA");
        if (outputData != null) {
            pageTop = outputData.getData(null, "PAGE_TOP");
        }
        return pageTop;
    }

    protected void setPageTop(PortletRequest portletRequest, StringBundler pageTop) {
        OutputData outputData = (OutputData)portletRequest.getAttribute("LIFERAY_SHARED_OUTPUT_DATA");
        if (outputData != null) {
            outputData.setData(null, "PAGE_TOP", pageTop);
            HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
            httpServletRequest.setAttribute("PAGE_TOP", (Object)pageTop);
        }
    }

    @Override
    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    protected boolean isPortletRequiresNamespacedParameters(PortletRequest portletRequest, ThemeDisplay themeDisplay) {
        boolean portletRequiresNamespacedParameters = false;
        String portletId = (String)portletRequest.getAttribute("PORTLET_ID");
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
            portletRequiresNamespacedParameters = portlet.isRequiresNamespacedParameters();
        }
        catch (SystemException e) {
            logger.error((Throwable)e);
        }
        return portletRequiresNamespacedParameters;
    }
}

