/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.container.liferay;

import com.liferay.faces.bridge.container.liferay.LiferayURLGenerator;
import com.liferay.faces.bridge.util.URLParameter;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.product.Product;
import com.liferay.faces.util.product.ProductMap;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;

public abstract class LiferayURLGeneratorBaseImpl
implements LiferayURLGenerator {
    private static final Logger logger = LoggerFactory.getLogger(LiferayURLGeneratorBaseImpl.class);
    private static final int LIFERAY_BUILD_NUMBER = ((Product)ProductMap.getInstance().get((Object)"Liferay Portal")).getBuildId();
    private String baseURL;
    private Map<String, String> parameterMap;
    private PortletMode initialPortletMode;
    private String prefix;
    private String responseNamespace;
    private WindowState initialWindowState;
    private List<URLParameter> wsrpParameters;
    private String portletURLAnchor;

    public LiferayURLGeneratorBaseImpl(String baseURL, String responseNamespace) {
        this(baseURL, null, responseNamespace, null);
    }

    public LiferayURLGeneratorBaseImpl(String baseURL, PortletMode portletMode, String responseNamespace, WindowState windowState) {
        this.baseURL = baseURL;
        this.initialPortletMode = portletMode;
        this.responseNamespace = responseNamespace;
        this.initialWindowState = windowState;
        this.parse();
    }

    @Override
    public String generateURL(Map<String, String[]> additionalParameterMap) {
        return this.generateURL(additionalParameterMap, null, null);
    }

    @Override
    public String generateURL(Map<String, String[]> additionalParameterMap, String resourceId) {
        return this.generateURL(additionalParameterMap, null, resourceId, null);
    }

    @Override
    public String generateURL(Map<String, String[]> additionalParameterMap, PortletMode portletMode, WindowState windowState) {
        return this.generateURL(additionalParameterMap, portletMode, null, windowState);
    }

    public String generateURL(Map<String, String[]> additionalParameterMap, PortletMode portletMode, String resourceId, WindowState windowState) {
        String toStringValue = null;
        if (this.baseURL.contains("/-/")) {
            toStringValue = this.baseURL;
        } else {
            String controlPanelCategory;
            String refererPlid;
            String refererGroupId;
            String doAsGroupId;
            String doAsUserLanguageId;
            String doAsUserId;
            String outerPortletId;
            String cacheability;
            String parameterValue;
            String portletAuthToken;
            String plid;
            StringBuilder url = new StringBuilder();
            url.append(this.prefix);
            boolean firstParameter = true;
            String portalAuthToken = this.parameterMap.get("p_auth");
            if (portalAuthToken != null) {
                this.appendParameterToURL(firstParameter, "p_auth", portalAuthToken, url);
                firstParameter = false;
            }
            if ((plid = this.parameterMap.get("p_l_id")) != null) {
                this.appendParameterToURL(firstParameter, "p_l_id", plid, url);
                firstParameter = false;
            }
            if ((portletAuthToken = this.parameterMap.get("p_p_auth")) != null) {
                boolean addPortletAuthToken = true;
                if (LIFERAY_BUILD_NUMBER < 6102 || LIFERAY_BUILD_NUMBER > 6102 && LIFERAY_BUILD_NUMBER < 6130) {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    PortletRequest portletRequest = (PortletRequest)facesContext.getExternalContext().getRequest();
                    String portletId = (String)portletRequest.getAttribute("PORTLET_ID");
                    ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    try {
                        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
                        addPortletAuthToken = portlet.isAddDefaultResource();
                    }
                    catch (SystemException e) {
                        logger.error((Throwable)e);
                    }
                }
                if (addPortletAuthToken) {
                    this.appendParameterToURL(firstParameter, "p_p_auth", portletAuthToken, url);
                    firstParameter = false;
                }
            }
            if ((parameterValue = this.responseNamespace).startsWith("_")) {
                parameterValue = parameterValue.substring(1);
            }
            if (parameterValue.endsWith("_")) {
                parameterValue = parameterValue.substring(0, parameterValue.length() - 1);
            }
            this.appendParameterToURL(firstParameter, "p_p_id", parameterValue, url);
            firstParameter = false;
            String portletLifecycleId = this.getPortletLifecycleId();
            this.appendParameterToURL("p_p_lifecycle", portletLifecycleId, url);
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Map applicationMap = facesContext.getExternalContext().getApplicationMap();
            WindowState urlWindowState = this.initialWindowState;
            if (windowState != null) {
                urlWindowState = windowState;
            }
            parameterValue = urlWindowState == null ? (String)applicationMap.get(this.responseNamespace + "p_p_state") : urlWindowState.toString();
            this.appendParameterToURL("p_p_state", parameterValue, url);
            String stateRestoreCurrentView = this.parameterMap.get("p_p_state_rcv");
            if (stateRestoreCurrentView != null) {
                this.appendParameterToURL("p_p_state_rcv", stateRestoreCurrentView, url);
            }
            PortletMode urlPortletMode = this.initialPortletMode;
            if (portletMode != null) {
                urlPortletMode = portletMode;
            }
            parameterValue = urlPortletMode == null ? (String)applicationMap.get(this.responseNamespace + "p_p_mode") : urlPortletMode.toString();
            this.appendParameterToURL("p_p_mode", parameterValue, url);
            if ("2".equals(portletLifecycleId) && (cacheability = this.parameterMap.get("p_p_cacheability")) != null) {
                this.appendParameterToURL("p_p_cacheability", cacheability, url);
            }
            parameterValue = (String)applicationMap.get(this.responseNamespace + "p_p_col_id");
            this.appendParameterToURL("p_p_col_id", parameterValue, url);
            parameterValue = (String)applicationMap.get(this.responseNamespace + "p_p_col_count");
            this.appendParameterToURL("p_p_col_count", parameterValue, url);
            parameterValue = (String)applicationMap.get(this.responseNamespace + "p_p_col_pos");
            if (parameterValue != null && parameterValue.length() > 0) {
                try {
                    int colPos = Integer.parseInt(parameterValue);
                    if (colPos > 0) {
                        this.appendParameterToURL("p_p_col_pos", parameterValue, url);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((outerPortletId = this.parameterMap.get("p_o_p_id")) != null) {
                this.appendParameterToURL("p_o_p_id", outerPortletId, url);
            }
            if ((doAsUserId = this.parameterMap.get("doAsUserId")) != null) {
                this.appendParameterToURL("doAsUserId", doAsUserId, url);
            }
            if ((doAsUserLanguageId = this.parameterMap.get("doAsUserLanguageId")) != null) {
                this.appendParameterToURL("doAsUserLanguageId", doAsUserLanguageId, url);
            }
            if ((doAsGroupId = this.parameterMap.get("doAsGroupId")) != null) {
                this.appendParameterToURL("doAsGroupId", doAsGroupId, url);
            }
            if ((refererGroupId = this.parameterMap.get("refererGroupId")) != null) {
                this.appendParameterToURL("refererGroupId", refererGroupId, url);
            }
            if ((refererPlid = this.parameterMap.get("refererPlid")) != null) {
                this.appendParameterToURL("refererPlid", refererPlid, url);
            }
            if ((controlPanelCategory = this.parameterMap.get("controlPanelCategory")) != null) {
                this.appendParameterToURL("controlPanelCategory", controlPanelCategory, url);
            }
            boolean namespaced = !this.responseNamespace.startsWith("wsrp");
            Set<Map.Entry<String, String[]>> mapEntries = additionalParameterMap.entrySet();
            if (mapEntries != null) {
                for (Map.Entry entry : mapEntries) {
                    String[] parameterValues = (String[])entry.getValue();
                    if (parameterValues == null) continue;
                    String parameterName = (String)entry.getKey();
                    for (String curParameterValue : parameterValues) {
                        if (curParameterValue == null) continue;
                        String encodedParameterValue = this.encode(curParameterValue);
                        this.appendParameterToURL(firstParameter, namespaced, parameterName, encodedParameterValue, url);
                    }
                }
            }
            for (URLParameter uRLParameter : this.wsrpParameters) {
                this.appendParameterToURL((String)uRLParameter.getName(), (String)uRLParameter.getValue(), url);
            }
            String urlResourceId = this.parameterMap.get("p_o_p_id");
            if (resourceId != null) {
                urlResourceId = resourceId;
            }
            if (urlResourceId == null) {
                if (this.prefix.startsWith("wsrp")) {
                    this.appendParameterToURL("p_p_resource_id", "wsrp", url);
                }
            } else {
                this.appendParameterToURL("p_p_resource_id", urlResourceId, url);
            }
            if (this.portletURLAnchor != null) {
                url.append(this.portletURLAnchor);
            }
            toStringValue = url.toString();
        }
        return toStringValue;
    }

    protected void appendParameterToURL(String parameterName, String parameterValue, StringBuilder url) {
        this.appendParameterToURL(false, false, parameterName, parameterValue, url);
    }

    protected void appendParameterToURL(boolean firstParameter, String parameterName, String parameterValue, StringBuilder url) {
        this.appendParameterToURL(firstParameter, false, parameterName, parameterValue, url);
    }

    protected void appendParameterToURL(boolean firstParameter, boolean namespaced, String parameterName, String parameterValue, StringBuilder url) {
        if (!firstParameter) {
            url.append("&");
        }
        if (namespaced) {
            url.append(this.responseNamespace);
        }
        url.append(parameterName);
        url.append("=");
        url.append(parameterValue);
        logger.debug("Appended param to URL name=[{0}] parameterValue=[{1}]", new Object[]{parameterName, parameterValue});
    }

    protected String encode(String value) {
        String encodedValue = "";
        if (value != null) {
            if (value.length() == 0) {
                encodedValue = " ";
            } else {
                try {
                    encodedValue = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Throwable)e);
                    encodedValue = " ";
                }
            }
        }
        return encodedValue;
    }

    protected void parse() {
        int pos;
        String[] nameValuePairs;
        this.parameterMap = new HashMap<String, String>();
        this.wsrpParameters = new ArrayList<URLParameter>();
        String queryString = this.baseURL;
        int queryPos = this.baseURL.indexOf("?");
        if (queryPos > 0) {
            this.prefix = this.baseURL.substring(0, queryPos + 1);
            queryString = this.baseURL.substring(queryPos + 1);
        }
        if ((nameValuePairs = queryString.split("[&]")) != null) {
            for (String nameValuePair : nameValuePairs) {
                int equalsPos = nameValuePair.indexOf("=");
                if (equalsPos <= 0) continue;
                String name = nameValuePair.substring(0, equalsPos);
                String value = nameValuePair.substring(equalsPos + 1);
                if (nameValuePair.startsWith("wsrp")) {
                    URLParameter urlParameter = new URLParameter(name, value);
                    this.wsrpParameters.add(urlParameter);
                    continue;
                }
                this.parameterMap.put(name, value);
            }
        }
        if ((pos = this.baseURL.indexOf("#")) > 0) {
            this.portletURLAnchor = this.baseURL.substring(pos);
        }
    }
}

