/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.container.liferay;

import com.liferay.faces.bridge.renderkit.html_basic.HeadResource;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.xml.SAXParserFactory;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LiferaySharedPageTop {
    private static final Logger logger = LoggerFactory.getLogger(LiferaySharedPageTop.class);
    private static final String XML_DOCUMENT_DECLARATION = "<?xml version=\"1.0\"?>";
    private static final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private List<HeadResource> headResources;

    public LiferaySharedPageTop(StringBundler stringBundler) {
        try {
            this.headResources = new ArrayList<HeadResource>();
            SharedPageTopHandler sharedPageTopHandler = new SharedPageTopHandler();
            StringBundler xmlDocument = new StringBundler();
            xmlDocument.append(XML_DOCUMENT_DECLARATION);
            xmlDocument.append("<");
            xmlDocument.append("PAGE_TOP");
            xmlDocument.append(">");
            xmlDocument.append(stringBundler);
            xmlDocument.append("<");
            xmlDocument.append("/");
            xmlDocument.append("PAGE_TOP");
            xmlDocument.append(">");
            String xmlDocumentAsString = xmlDocument.toString();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmlDocumentAsString.getBytes());
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)sharedPageTopHandler);
            byteArrayInputStream.close();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void removeDuplicates() {
        int totalHeadResources = this.headResources.size();
        block0: for (int i = 0; i < totalHeadResources; ++i) {
            HeadResource headResource1 = this.headResources.get(i);
            for (int j = i + 1; j < totalHeadResources; ++j) {
                HeadResource headResource2 = this.headResources.get(j);
                if (headResource2.isDuplicate() || !headResource1.equals(headResource2)) continue;
                headResource2.setDuplicate(true);
                continue block0;
            }
        }
        Iterator<HeadResource> itr = this.headResources.iterator();
        while (itr.hasNext()) {
            HeadResource headResource = itr.next();
            if (!headResource.isDuplicate()) continue;
            itr.remove();
        }
    }

    public StringBundler toStringBundler() {
        StringBundler stringBundler = new StringBundler();
        for (HeadResource headResource : this.headResources) {
            String headResourceMarkup = headResource.toString();
            headResourceMarkup = this.encodeAmpersands(headResourceMarkup);
            stringBundler.append(headResourceMarkup);
        }
        return stringBundler;
    }

    protected String encodeAmpersands(String value) {
        String encodedValue = value;
        int ampersandPos = value.indexOf("&");
        if (ampersandPos > 0) {
            int startPos = 0;
            StringBuilder buf = new StringBuilder();
            while (ampersandPos > 0) {
                buf.append(value.substring(startPos, ampersandPos));
                buf.append("&amp;");
                startPos = ampersandPos + 1;
                ampersandPos = value.indexOf("&", startPos);
            }
            if (startPos < value.length()) {
                buf.append(value.substring(startPos));
            }
            encodedValue = buf.toString();
        }
        return encodedValue;
    }

    protected class SharedPageTopHandler
    extends DefaultHandler {
        private HeadResource headResource;

        protected SharedPageTopHandler() {
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (this.headResource != null) {
                String text = this.headResource.getText();
                text = text == null ? new String(chars, start, length) : text + new String(chars, start, length);
                this.headResource.setText(text);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.headResource = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"PAGE_TOP".equals(qName)) {
                this.headResource = new HeadResource(qName, attributes);
                LiferaySharedPageTop.this.headResources.add(this.headResource);
            }
        }
    }
}

