/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.container.liferay;

import com.liferay.faces.bridge.container.liferay.OriginalHttpServletRequest;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.theme.ThemeDisplay;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.portlet.PortletRequest;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.http.HttpServletRequest;

public class LiferayPortletRequest {
    private static final String METHOD_NAME_GET_ORIGINAL_HTTP_SERVLET_REQUEST = "getOriginalHttpServletRequest";
    private static final String METHOD_NAME_GET_PORTLET = "getPortlet";
    private static final Logger logger = LoggerFactory.getLogger(LiferayPortletRequest.class);
    private OriginalHttpServletRequest originalHttpServletRequest;
    private Portlet portlet;
    private ThemeDisplay themeDisplay;
    private PortletRequest wrappedPortletRequest;

    public LiferayPortletRequest(PortletRequest portletRequest) {
        Method method;
        if (portletRequest != null) {
            while (portletRequest instanceof PortletRequestWrapper) {
                PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
                portletRequest = portletRequestWrapper.getRequest();
            }
        }
        this.wrappedPortletRequest = portletRequest;
        try {
            method = this.wrappedPortletRequest.getClass().getMethod(METHOD_NAME_GET_PORTLET, null);
            this.portlet = (Portlet)method.invoke((Object)this.wrappedPortletRequest, (Object[])null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
        try {
            method = this.wrappedPortletRequest.getClass().getMethod(METHOD_NAME_GET_ORIGINAL_HTTP_SERVLET_REQUEST, null);
            this.originalHttpServletRequest = new OriginalHttpServletRequest((HttpServletRequest)method.invoke((Object)this.wrappedPortletRequest, (Object[])null));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
    }

    public long getDateHeader(String name) {
        return this.originalHttpServletRequest.getDateHeader(name);
    }

    public String[] getHeader(String name) {
        String[] values = null;
        Enumeration headers = this.originalHttpServletRequest.getHeaders(name);
        if (headers != null) {
            ArrayList<String> valueList = new ArrayList<String>();
            while (headers.hasMoreElements()) {
                valueList.add((String)headers.nextElement());
            }
            values = valueList.toArray(new String[valueList.size()]);
        }
        return values;
    }

    public Portlet getPortlet() {
        return this.portlet;
    }

    public ThemeDisplay getThemeDisplay() {
        if (this.themeDisplay == null) {
            this.themeDisplay = (ThemeDisplay)this.wrappedPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        }
        return this.themeDisplay;
    }
}

