/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.container;

import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.config.BridgeConfigConstants;
import com.liferay.faces.bridge.container.PortletContainerCompatImpl;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.util.RequestParameter;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.portlet.ActionResponse;
import javax.portlet.BaseURL;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.portlet.faces.Bridge;

public class PortletContainerImpl
extends PortletContainerCompatImpl {
    private static final long serialVersionUID = 293072155166625509L;
    private static final Logger logger = LoggerFactory.getLogger(PortletContainerImpl.class);
    private static final String REQUEST_ATTR_PORTLET_REQUEST = "javax.portlet.request";
    private static final String REQUEST_ATTR_QUERY_STRING = "javax.servlet.forward.query_string";
    private Boolean ableToSetHttpStatusCode;
    private BridgeConfig bridgeConfig;
    private boolean markupHeadElementSupported;
    private String requestQueryString;
    private String requestURL;
    private String responseNamespace;

    public PortletContainerImpl(PortletRequest portletRequest, BridgeConfig bridgeConfig) {
        String portalVendorClaim = portletRequest.getPortalContext().getProperty("javax.portlet.markup.head.element.support");
        this.bridgeConfig = bridgeConfig;
        this.markupHeadElementSupported = portalVendorClaim != null;
    }

    public void afterPhase(PhaseEvent phaseEvent) {
    }

    public void beforePhase(PhaseEvent event) {
    }

    @Override
    public PortletURL createActionURL(String fromURL) throws MalformedURLException {
        try {
            logger.debug("createActionURL fromURL=[" + fromURL + "]");
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            MimeResponse mimeResponse = (MimeResponse)bridgeContext.getPortletResponse();
            PortletURL actionURL = this.createActionURL(mimeResponse);
            this.copyRequestParameters(fromURL, (BaseURL)actionURL);
            return actionURL;
        }
        catch (ClassCastException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    @Override
    public ResourceURL createPartialActionURL(String fromURL) throws MalformedURLException {
        logger.debug("createPartialActionURL fromURL=[" + fromURL + "]");
        return this.createResourceURL(fromURL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PortletURL createRedirectURL(String fromURL, Map<String, List<String>> parameters) throws MalformedURLException {
        PortletURL redirectURL = null;
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        Bridge.PortletPhase portletRequestPhase = bridgeContext.getPortletRequestPhase();
        if (portletRequestPhase != Bridge.PortletPhase.RENDER_PHASE && portletRequestPhase != Bridge.PortletPhase.RESOURCE_PHASE) throw new UnsupportedOperationException("Unable to create a redirectURL (renderURL) during " + portletRequestPhase + " from URL=[" + fromURL + "]");
        try {
            logger.debug("createRedirectURL fromURL=[" + fromURL + "]");
            MimeResponse mimeResponse = (MimeResponse)bridgeContext.getPortletResponse();
            redirectURL = mimeResponse.createRenderURL();
            this.copyRequestParameters(fromURL, (BaseURL)redirectURL);
            if (parameters == null) return redirectURL;
            Set<String> parameterNames = parameters.keySet();
            for (String parameterName : parameterNames) {
                List<String> parameterValues = parameters.get(parameterName);
                String[] parameterValuesArray = parameterValues.toArray(new String[parameterValues.size()]);
                redirectURL.setParameter(parameterName, parameterValuesArray);
            }
            return redirectURL;
        }
        catch (ClassCastException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    @Override
    public PortletURL createRenderURL(String fromURL) throws MalformedURLException {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        Bridge.PortletPhase portletRequestPhase = bridgeContext.getPortletRequestPhase();
        if (portletRequestPhase == Bridge.PortletPhase.RENDER_PHASE || portletRequestPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            try {
                logger.debug("createRenderURL fromURL=[" + fromURL + "]");
                MimeResponse mimeResponse = (MimeResponse)bridgeContext.getPortletResponse();
                PortletURL renderURL = this.createRenderURL(mimeResponse);
                this.copyRequestParameters(fromURL, (BaseURL)renderURL);
                return renderURL;
            }
            catch (ClassCastException e) {
                throw new MalformedURLException(e.getMessage());
            }
        }
        throw new MalformedURLException("Unable to create a RenderURL during " + portletRequestPhase.toString());
    }

    @Override
    public ResourceURL createResourceURL(String fromURL) throws MalformedURLException {
        try {
            logger.debug("createResourceURL fromURL=[" + fromURL + "]");
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            MimeResponse mimeResponse = (MimeResponse)bridgeContext.getPortletResponse();
            ResourceURL resourceURL = this.createResourceURL(mimeResponse);
            int tokenPos = fromURL.indexOf("javax.faces.resource");
            if (tokenPos >= 0) {
                int slashPos;
                String resourceId = fromURL.substring(tokenPos);
                int queryStringPos = resourceId.indexOf(63);
                String resourceName = resourceId;
                if (queryStringPos > 0) {
                    resourceName = resourceName.substring(0, queryStringPos);
                }
                if ((slashPos = resourceName.indexOf(47)) > 0) {
                    resourceName = resourceName.substring(slashPos + 1);
                } else {
                    logger.error("There is no slash after the [{0}] token in resourceURL=[{1}]", new Object[]{"javax.faces.resource", fromURL});
                }
                resourceURL.setParameter("javax.faces.resource", resourceName);
                logger.debug("Added parameter to portletURL name=[{0}] value=[{1}]", new Object[]{"javax.faces.resource", resourceName});
            }
            this.copyRequestParameters(fromURL, (BaseURL)resourceURL);
            return resourceURL;
        }
        catch (ClassCastException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    @Override
    public String fixRequestParameterValue(String value) {
        return value;
    }

    @Override
    public void maintainRenderParameters(EventRequest eventRequest, EventResponse eventResponse) {
        Map privateParameterMap;
        Map existingResponseRenderParameterMap = eventResponse.getRenderParameterMap();
        Map publicParameterMap = eventRequest.getPublicParameterMap();
        if (publicParameterMap != null) {
            Set entrySet = publicParameterMap.entrySet();
            for (Map.Entry mapEntry : entrySet) {
                String key = (String)mapEntry.getKey();
                boolean alreadyExists = false;
                if (existingResponseRenderParameterMap != null) {
                    alreadyExists = existingResponseRenderParameterMap.containsKey(key);
                }
                if (alreadyExists) {
                    if (!logger.isTraceEnabled()) continue;
                    String[] existingValues = (String[])existingResponseRenderParameterMap.get(key);
                    logger.trace("Not maintaining public render parameter name=[{0}] values=[{1}] because it already exists", new Object[]{key, existingValues});
                    continue;
                }
                String[] values = (String[])mapEntry.getValue();
                eventResponse.setRenderParameter(key, values);
                logger.trace("Maintaining public render parameter name=[{0}] values=[{1}]", new Object[]{key, values});
            }
        }
        if ((privateParameterMap = eventRequest.getPrivateParameterMap()) != null) {
            Set entrySet = privateParameterMap.entrySet();
            for (Map.Entry mapEntry : entrySet) {
                String key = (String)mapEntry.getKey();
                boolean alreadyExists = false;
                if (existingResponseRenderParameterMap != null) {
                    alreadyExists = existingResponseRenderParameterMap.containsKey(key);
                }
                if (alreadyExists) {
                    if (!logger.isTraceEnabled()) continue;
                    String[] existingValues = (String[])existingResponseRenderParameterMap.get(key);
                    logger.trace("Not maintaining private render parameter name=[{0}] values=[{1}] because it already exists", new Object[]{key, existingValues});
                    continue;
                }
                String[] values = (String[])mapEntry.getValue();
                eventResponse.setRenderParameter(key, values);
                logger.trace("Maintaining private render parameter name=[{0}] values=[{1}]", new Object[]{key, values});
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void redirect(String url) throws IOException {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        PortletResponse portletResponse = bridgeContext.getPortletResponse();
        if (portletResponse instanceof ActionResponse) {
            ActionResponse actionResponse = (ActionResponse)portletResponse;
            actionResponse.sendRedirect(url);
            return;
        } else {
            if (!(portletResponse instanceof ResourceResponse)) throw new UnsupportedEncodingException("Unable to redirect during " + bridgeContext.getPortletRequestPhase());
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (!this.isJSF2PartialRequest(facesContext)) throw new UnsupportedEncodingException("Can only redirect during RESOURCE_PHASE if a JSF partial/Ajax request has been triggered");
            this.redirectJSF2PartialResponse(facesContext, (ResourceResponse)portletResponse, url);
        }
    }

    protected void copyRequestParameters(String fromURL, BaseURL toURL) throws MalformedURLException {
        List<RequestParameter> requestParameters = this.parseRequestParameters(fromURL);
        if (requestParameters != null) {
            for (RequestParameter requestParameter : requestParameters) {
                String name = (String)requestParameter.getName();
                String value = (String)requestParameter.getValue();
                toURL.setParameter(name, value);
                logger.debug("Copied parameter to portletURL name=[{0}] value=[{1}]", new Object[]{name, value});
            }
        }
    }

    protected PortletURL createActionURL(MimeResponse mimeResponse) {
        return mimeResponse.createActionURL();
    }

    protected PortletURL createRenderURL(MimeResponse mimeResponse) {
        return mimeResponse.createRenderURL();
    }

    protected ResourceURL createResourceURL(MimeResponse mimeResponse) {
        return mimeResponse.createResourceURL();
    }

    protected List<RequestParameter> parseRequestParameters(String url) throws MalformedURLException {
        String queryString;
        int pos;
        ArrayList<RequestParameter> requestParameters = null;
        if (url != null && (pos = url.indexOf("?")) >= 0 && (queryString = url.substring(pos + 1)) != null && queryString.length() > 0) {
            String[] queryParameters;
            requestParameters = new ArrayList<RequestParameter>();
            for (String queryParameter : queryParameters = queryString.split("[&]")) {
                String[] nameValueArray = queryParameter.split("[=]");
                if (nameValueArray == null) continue;
                if (nameValueArray.length == 2) {
                    String name = nameValueArray[0];
                    String value = nameValueArray[1];
                    requestParameters.add(new RequestParameter(name, value));
                    continue;
                }
                throw new MalformedURLException("invalid name/value pair: " + queryParameter);
            }
        }
        return requestParameters;
    }

    protected boolean getContextParamAbleToSetHttpStatusCode(boolean defaultValue) {
        String contextParamValue = this.bridgeConfig.getContextParameter(BridgeConfigConstants.PARAM_CONTAINER_ABLE_TO_SET_HTTP_STATUS_CODE1);
        if (contextParamValue == null) {
            contextParamValue = this.bridgeConfig.getContextParameter(BridgeConfigConstants.PARAM_CONTAINER_ABLE_TO_SET_HTTP_STATUS_CODE2);
        }
        return BooleanHelper.toBoolean((String)contextParamValue, (boolean)defaultValue);
    }

    @Override
    public boolean isAbleToAddScriptResourceToHead() {
        return this.isMarkupHeadElementSupported();
    }

    @Override
    public boolean isAbleToAddScriptTextToHead() {
        return this.isMarkupHeadElementSupported();
    }

    @Override
    public boolean isAbleToAddStyleSheetResourceToHead() {
        return this.isMarkupHeadElementSupported();
    }

    @Override
    public boolean isPostRedirectGetSupported() {
        return true;
    }

    protected boolean isMarkupHeadElementSupported() {
        return this.markupHeadElementSupported;
    }

    @Override
    public boolean isAbleToSetHttpStatusCode() {
        if (this.ableToSetHttpStatusCode == null) {
            boolean defaultValue = false;
            this.ableToSetHttpStatusCode = this.getContextParamAbleToSetHttpStatusCode(defaultValue);
        }
        return this.ableToSetHttpStatusCode;
    }

    @Override
    public boolean isAbleToSetResourceResponseBufferSize() {
        return true;
    }

    @Override
    public boolean isAbleToForwardOnDispatch() {
        return true;
    }

    @Override
    public String[] getHeader(String name) {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        PortletRequest portletRequest = bridgeContext.getPortletRequest();
        Enumeration properties = portletRequest.getProperties(name);
        ArrayList propertyList = new ArrayList();
        while (properties.hasMoreElements()) {
            propertyList.add(properties.nextElement());
        }
        return propertyList.toArray(new String[propertyList.size()]);
    }

    @Override
    public long getHttpServletRequestDateHeader(String name) {
        return -1L;
    }

    @Override
    public void setMimeResponseContentType(MimeResponse mimeResponse, String contentType) {
        mimeResponse.setContentType(contentType);
    }

    public PhaseId getPhaseId() {
        return null;
    }

    @Override
    public String getRequestParameter(String name) {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        return this.fixRequestParameterValue(bridgeContext.getPortletRequest().getParameter(name));
    }

    @Override
    public String[] getRequestParameterValues(String name) {
        String[] values = null;
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        String[] originalValues = bridgeContext.getPortletRequest().getParameterValues(name);
        if (originalValues != null) {
            values = new String[originalValues.length];
            for (int i = 0; i < originalValues.length; ++i) {
                values[i] = this.fixRequestParameterValue(originalValues[i]);
            }
        }
        return values;
    }

    @Override
    public String getRequestQueryString() {
        if (this.requestQueryString == null) {
            Object portletRequestAsObject;
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            PortletRequest portletRequest = bridgeContext.getPortletRequest();
            this.requestQueryString = (String)portletRequest.getAttribute(REQUEST_ATTR_QUERY_STRING);
            if (this.requestQueryString == null && (portletRequestAsObject = portletRequest.getAttribute(REQUEST_ATTR_PORTLET_REQUEST)) != null && portletRequestAsObject instanceof PortletRequest) {
                portletRequest = (PortletRequest)portletRequestAsObject;
                this.requestQueryString = (String)portletRequest.getAttribute(REQUEST_ATTR_QUERY_STRING);
            }
        }
        return this.requestQueryString;
    }

    @Override
    public String getRequestURL() {
        if (this.requestURL == null) {
            StringBuilder buf = new StringBuilder();
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            PortletRequest portletRequest = bridgeContext.getPortletRequest();
            buf.append(portletRequest.getScheme());
            buf.append(":");
            buf.append("/");
            buf.append("/");
            buf.append(portletRequest.getServerName());
            buf.append(":");
            buf.append(portletRequest.getServerPort());
            buf.append(portletRequest.getContextPath());
            buf.append("?");
            buf.append(this.getRequestQueryString());
            this.requestURL = buf.toString();
        }
        return this.requestURL;
    }

    @Override
    public String getResponseNamespace() {
        if (this.responseNamespace == null) {
            BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
            this.responseNamespace = bridgeContext.getPortletResponse().getNamespace();
            if ("wsrp_rewrite".equals(this.responseNamespace)) {
                this.responseNamespace = bridgeContext.getPortletConfig().getPortletName() + bridgeContext.getPortletContext().getPortletContextName();
            }
        }
        return this.responseNamespace;
    }

    @Override
    public boolean isNamespacedParameters() {
        return false;
    }
}

