/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.config;

import com.liferay.faces.bridge.config.ServletMapping;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;

public class ServletMappingImpl
implements ServletMapping {
    private static final Logger logger = LoggerFactory.getLogger(ServletMappingImpl.class);
    private static final String EXTENSION_WILDCARD = "*.";
    private String extension;
    private boolean extensionMapped;
    private String path;
    private boolean pathMapped;
    private String urlPattern;

    public ServletMappingImpl(String urlPattern) {
        this.urlPattern = urlPattern;
        if (urlPattern != null) {
            if (urlPattern.startsWith("/") && urlPattern.endsWith("*")) {
                this.pathMapped = true;
                this.path = urlPattern.substring(0, urlPattern.length() - "/".length() - "*".length());
            } else if (urlPattern.startsWith(EXTENSION_WILDCARD)) {
                this.extensionMapped = true;
                this.extension = urlPattern.substring("*".length());
            }
        }
    }

    @Override
    public boolean isExtensionMapped() {
        return this.extensionMapped;
    }

    @Override
    public boolean isPathMapped() {
        return this.pathMapped;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public boolean isMatch(String uri) {
        boolean match = false;
        if (uri != null) {
            if (this.extensionMapped) {
                match = uri.endsWith(this.extension);
                logger.debug("Testing match for servlet-mapping url-pattern=[{0}] EXTENSION=[{1}] uri=[{2}] match=[{3}]", new Object[]{this.urlPattern, this.extension, uri, match});
            } else if (this.pathMapped) {
                int pos = uri.lastIndexOf("/");
                String uriPath = uri;
                if (pos > 0) {
                    uriPath = uri.substring(0, pos);
                }
                match = this.path.contains(uriPath) || uriPath.startsWith(this.path);
                logger.debug("Testing match for servlet-mapping url-pattern=[{0}] PATH=[{1}] uri=[{2}] match=[{3}]", new Object[]{this.urlPattern, this.path, uri, match});
            }
        }
        return match;
    }

    @Override
    public String getServletPath() {
        return this.path;
    }

    @Override
    public String getUrlPattern() {
        return this.urlPattern;
    }
}

