/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.config;

import com.liferay.faces.bridge.config.SAXHandlerBaseImpl;
import com.liferay.faces.bridge.config.ServletMapping;
import com.liferay.faces.bridge.config.ServletMappingImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.List;
import javax.faces.webapp.FacesServlet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXHandlerWebConfigImpl
extends SAXHandlerBaseImpl {
    private static final Logger logger = LoggerFactory.getLogger(SAXHandlerWebConfigImpl.class);
    private static final String FACES_SERVLET_FQCN = FacesServlet.class.getName();
    private static final String SERVLET = "servlet";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String URL_PATTERN = "url-pattern";
    private List<ServletMapping> facesServletMappings;
    private String facesServletName = "Faces Servlet";
    private boolean parsingServlet = false;
    private boolean parsingServletClass = false;
    private boolean parsingServletMapping = false;
    private boolean parsingServletName = false;
    private boolean parsingUrlPattern = false;
    private String servletName;

    public SAXHandlerWebConfigImpl(boolean resolveEntities, List<ServletMapping> facesServletMappings) {
        super(resolveEntities);
        this.facesServletMappings = facesServletMappings;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.parsingServlet) {
            if (this.parsingServletClass) {
                String servletClass = this.content.toString().trim();
                if (servletClass.length() > 0 && FACES_SERVLET_FQCN.equals(servletClass) && this.servletName.length() > 0) {
                    this.facesServletName = this.servletName;
                    logger.trace("servlet-class=[{0}] servlet-name=[{1}]", new Object[]{FACES_SERVLET_FQCN, this.facesServletName});
                }
                this.parsingServletClass = false;
            } else if (this.parsingServletName) {
                this.servletName = this.content.toString().trim();
                this.parsingServletName = false;
            }
            if (SERVLET.equals(qName)) {
                this.parsingServlet = false;
            }
        } else if (this.parsingServletMapping) {
            if (this.parsingServletName) {
                this.servletName = this.content.toString().trim();
                this.parsingServletName = false;
            } else if (this.parsingUrlPattern) {
                if (this.servletName != null && this.servletName.equals(this.facesServletName)) {
                    String urlPattern = this.content.toString().trim();
                    this.facesServletMappings.add(new ServletMappingImpl(urlPattern));
                    logger.trace("Added urlPattern=[{0}] to facesServletMappings", new Object[]{urlPattern});
                }
                this.parsingUrlPattern = false;
            }
            if (SERVLET_MAPPING.equals(qName)) {
                this.parsingServletMapping = false;
            }
        }
        this.content = null;
    }

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
        logger.trace("localName=[{0}]", new Object[]{localName});
        this.content = new StringBuilder();
        if (localName.equals(SERVLET)) {
            this.parsingServlet = true;
        } else if (localName.equals(SERVLET_CLASS)) {
            this.parsingServletClass = true;
        } else if (localName.equals(SERVLET_MAPPING)) {
            this.parsingServletMapping = true;
        } else if (localName.equals(SERVLET_NAME)) {
            this.parsingServletName = true;
        } else if (localName.equals(URL_PATTERN)) {
            this.parsingUrlPattern = true;
        }
    }
}

