/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.config;

import com.liferay.faces.bridge.config.ConfiguredSystemEventListener;
import com.liferay.faces.bridge.config.ConfiguredSystemEventListenerImpl;
import com.liferay.faces.bridge.config.SAXHandlerBaseImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXHandlerMojarraConfigImpl
extends SAXHandlerBaseImpl {
    private static final Logger logger = LoggerFactory.getLogger(SAXHandlerMojarraConfigImpl.class);
    private static final String SOURCE_CLASS = "source-class";
    private static final String SYSTEM_EVENT_CLASS = "system-event-class";
    private static final String SYSTEM_EVENT_LISTENER = "system-event-listener";
    private static final String SYSTEM_EVENT_LISTENER_CLASS = "system-event-listener-class";
    private List<ConfiguredSystemEventListener> configuredSystemEventListeners;
    private boolean parsingSourceClass;
    private boolean parsingSystemEventClass;
    private boolean parsingSystemEventListener;
    private boolean parsingSystemEventListenerClass;
    private String sourceClass;
    private String systemEventClass;
    private String systemEventListenerClass;

    public SAXHandlerMojarraConfigImpl(boolean resolveEntities, List<ConfiguredSystemEventListener> configuredSystemEventListeners) {
        super(resolveEntities);
        this.configuredSystemEventListeners = configuredSystemEventListeners;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.parsingSourceClass) {
            this.sourceClass = this.content.toString().trim();
            this.parsingSourceClass = false;
        } else if (this.parsingSystemEventClass) {
            this.systemEventClass = this.content.toString().trim();
            this.parsingSystemEventClass = false;
        } else if (this.parsingSystemEventListenerClass) {
            this.systemEventListenerClass = this.content.toString().trim();
            this.parsingSystemEventListenerClass = false;
        } else if (this.parsingSystemEventListener) {
            ConfiguredSystemEventListenerImpl configuredSystemEventListener = new ConfiguredSystemEventListenerImpl(this.sourceClass, this.systemEventClass, this.systemEventListenerClass);
            this.configuredSystemEventListeners.add(configuredSystemEventListener);
            this.parsingSystemEventListener = false;
        }
        this.content = null;
    }

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
        logger.trace("localName=[{0}]", new Object[]{localName});
        this.content = new StringBuilder();
        if (localName.equals(SOURCE_CLASS)) {
            this.parsingSourceClass = true;
        } else if (localName.equals(SYSTEM_EVENT_CLASS)) {
            this.parsingSystemEventClass = true;
        } else if (localName.equals(SYSTEM_EVENT_LISTENER)) {
            this.parsingSystemEventListener = true;
        } else if (localName.equals(SYSTEM_EVENT_LISTENER_CLASS)) {
            this.parsingSystemEventListenerClass = true;
        }
    }
}

