/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.config;

import com.liferay.faces.bridge.config.BridgeConfigAttributeMap;
import com.liferay.faces.bridge.config.SAXHandlerBaseImpl;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class SAXHandlerFacesConfigPost
extends SAXHandlerBaseImpl {
    private static final Logger logger = LoggerFactory.getLogger(SAXHandlerFacesConfigPost.class);
    protected static final String FACTORY_NOT_FOUND_MSG = "Factory not found in any faces-config.xml files: [{0}]";
    protected BridgeConfigAttributeMap bridgeConfigAttributeMap;

    public SAXHandlerFacesConfigPost(boolean resolveEntities, BridgeConfigAttributeMap bridgeConfigAttributeMap) {
        super(resolveEntities);
        this.bridgeConfigAttributeMap = bridgeConfigAttributeMap;
    }

    protected Object newFactoryInstance(String className, Class<?> factoryClassType, Object wrappedFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object classInstance = null;
        if (classLoader != null && className != null) {
            Constructor<?>[] constructors;
            Class<?> factoryClass = classLoader.loadClass(className);
            Constructor<?> wrapperConstructor = null;
            for (Constructor<?> constructor : constructors = factoryClass.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes == null || parameterTypes.length != 1 || parameterTypes[0] != factoryClassType) continue;
                wrapperConstructor = constructor;
            }
            if (wrapperConstructor == null) {
                logger.debug("Creating instance with zero-arg constructor since wrapperConstructor=null");
                classInstance = factoryClass.newInstance();
            } else {
                logger.debug("Creating instance with one-arg constructor since wrapperConstructor=[{0}]", new Object[]{wrapperConstructor});
                classInstance = wrapperConstructor.newInstance(wrappedFactory);
            }
        }
        return classInstance;
    }

    protected void setupFactory(Class<?> factoryType, String factoryImplementation) {
        if (factoryImplementation != null && factoryImplementation.length() > 0) {
            String factoryTypeFQCN = factoryType.getName();
            try {
                Object wrappedFactory = this.bridgeConfigAttributeMap.get(factoryType.getName());
                Object factory = this.newFactoryInstance(factoryImplementation, factoryType, wrappedFactory);
                this.bridgeConfigAttributeMap.put(factoryTypeFQCN, factory);
            }
            catch (ClassNotFoundException e) {
                logger.error("{0} : factoryTypeFQCN=[{1}]", new Object[]{e.getClass().getName(), factoryTypeFQCN});
            }
            catch (Exception e) {
                logger.error(e.getMessage(), new Object[]{e});
            }
        }
    }

    public abstract String getWriteBehindRenderResponseWrapper();

    public abstract String getWriteBehindResourceResponseWrapper();
}

