/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.config;

import com.liferay.faces.bridge.config.SAXHandler;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SAXHandlerBaseImpl
extends SAXHandler {
    private static final Logger logger = LoggerFactory.getLogger(SAXHandlerBaseImpl.class);
    protected StringBuilder content;
    private boolean resolveEntities = false;
    private URL url;

    public SAXHandlerBaseImpl(boolean resolveEntities) {
        this.resolveEntities = resolveEntities;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.content != null && ch != null && length > 0) {
            this.content.append(ch, start, length);
        }
    }

    @Override
    public void logMissingElementErrors() {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        InputSource inputSource = new InputSource(new StringReader(""));
        if (this.resolveEntities && (inputSource = super.resolveEntity(publicId, systemId)) == null) {
            try {
                inputSource = new InputSource(new URL(systemId).openStream());
            }
            catch (IOException ioException) {
                logger.trace("Unable to download publicId=[{0}], systemId=[{1}], referenced-in=[{2}]", new Object[]{publicId, systemId, this.url});
            }
        }
        return inputSource;
    }

    @Override
    public void setURL(URL url) {
        this.url = url;
    }
}

