/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.config;

import com.liferay.faces.bridge.bean.BeanManagerFactory;
import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.config.BridgeConfigAttributeMap;
import com.liferay.faces.bridge.config.BridgeConfigAttributeMapImpl;
import com.liferay.faces.bridge.config.BridgeConfigConstants;
import com.liferay.faces.bridge.config.ConfiguredBean;
import com.liferay.faces.bridge.config.ConfiguredSystemEventListener;
import com.liferay.faces.bridge.config.FacesConfig;
import com.liferay.faces.bridge.config.FacesConfigImpl;
import com.liferay.faces.bridge.config.SAXHandler;
import com.liferay.faces.bridge.config.SAXHandlerBaseImpl;
import com.liferay.faces.bridge.config.SAXHandlerFacesConfigPost;
import com.liferay.faces.bridge.config.SAXHandlerFacesConfigPostImpl;
import com.liferay.faces.bridge.config.SAXHandlerFacesConfigPre;
import com.liferay.faces.bridge.config.SAXHandlerFacesConfigPreImpl;
import com.liferay.faces.bridge.config.SAXHandlerMojarraConfigImpl;
import com.liferay.faces.bridge.config.SAXHandlerWebConfigImpl;
import com.liferay.faces.bridge.config.SAXParseCompleteException;
import com.liferay.faces.bridge.config.ServletMapping;
import com.liferay.faces.bridge.config.ServletMappingImpl;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class BridgeConfigImpl
implements BridgeConfig {
    private static final String FACES_VIEW_ID_RENDER = "_facesViewIdRender";
    private static final String FACES_VIEW_ID_RESOURCE = "_facesViewIdResource";
    private static final String FACES_CONFIG_META_INF_PATH = "META-INF/faces-config.xml";
    private static final String FACES_CONFIG_WEB_INF_PATH = "/WEB-INF/faces-config.xml";
    private static final String LIFERAY_FACES_BRIDGE = "LiferayFacesBridge";
    private static final String MOJARRA_CONFIG_PATH = "com/sun/faces/jsf-ri-runtime.xml";
    private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
    private static final String WEB_XML_LIFERAY_PATH = "/WEB-INF/liferay-web.xml";
    private static final String WEB_FRAGMENT_META_INF_PATH = "META-INF/web-fragment.xml";
    private static final Logger logger = LoggerFactory.getLogger(BridgeConfigImpl.class);
    private BridgeConfigAttributeMap bridgeConfigAttributeMap = new BridgeConfigAttributeMapImpl();
    private List<ConfiguredBean> configuredBeans = new ArrayList<ConfiguredBean>();
    private List<ConfiguredSystemEventListener> configuredSystemEventListeners = new ArrayList<ConfiguredSystemEventListener>();
    private List<String> defaultSuffixes;
    private Set<String> excludedBridgeRequestAttributes = new HashSet<String>();
    private List<ServletMapping> facesServletMappings;
    private PortletContext portletContext;
    private Map<String, String[]> publicParameterMappings = new HashMap<String, String[]>();
    private String viewIdRenderParameterName;
    private String viewIdResourceParameterName;
    private String writeBehindRenderResponseWrapper;
    private String writeBehindResourceResponseWrapper;

    public BridgeConfigImpl(PortletConfig portletConfig) {
        this.portletContext = portletConfig.getPortletContext();
        try {
            String defaultSuffixParam;
            SAXHandlerWebConfigImpl webConfigHandler;
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            boolean validating = false;
            saxParserFactory.setValidating(validating);
            saxParserFactory.setNamespaceAware(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            boolean defaultValue = false;
            String initParam = this.portletContext.getInitParameter(BridgeConfigConstants.PARAM_REQUIRED_TO_RESOLVE_XML_ENTITIES1);
            if (initParam == null) {
                initParam = this.portletContext.getInitParameter(BridgeConfigConstants.PARAM_REQUIRED_TO_RESOLVE_XML_ENTITIES2);
            }
            boolean resolveEntities = BooleanHelper.toBoolean((String)initParam, (boolean)defaultValue);
            SAXHandlerMojarraConfigImpl mojarraConfigHandler = new SAXHandlerMojarraConfigImpl(resolveEntities, this.configuredSystemEventListeners);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> mojarraConfigURLs = classLoader.getResources(MOJARRA_CONFIG_PATH);
            if (mojarraConfigURLs != null) {
                boolean processedMojarraConfig = false;
                while (mojarraConfigURLs.hasMoreElements()) {
                    URL mojarraConfigURL = mojarraConfigURLs.nextElement();
                    if (processedMojarraConfig) {
                        logger.debug("Skipping Mojarra config: [{0}]", new Object[]{mojarraConfigURL});
                        continue;
                    }
                    logger.debug("Processing Mojarra config: [{0}]", new Object[]{mojarraConfigURL});
                    ((SAXHandler)mojarraConfigHandler).setURL(mojarraConfigURL);
                    InputStream inputStream = mojarraConfigURL.openStream();
                    try {
                        saxParser.parse(inputStream, (DefaultHandler)mojarraConfigHandler);
                    }
                    catch (SAXParseCompleteException e) {
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                    }
                    processedMojarraConfig = true;
                }
            }
            ((SAXHandler)mojarraConfigHandler).logMissingElementErrors();
            SAXHandlerFacesConfigPreImpl facesConfigPreHandler = new SAXHandlerFacesConfigPreImpl(resolveEntities);
            SAXHandlerFacesConfigPostImpl facesConfigPostHandler = new SAXHandlerFacesConfigPostImpl(resolveEntities, this.bridgeConfigAttributeMap, this.configuredBeans, this.excludedBridgeRequestAttributes, this.publicParameterMappings);
            Enumeration<URL> facesConfigURLs = classLoader.getResources(FACES_CONFIG_META_INF_PATH);
            ArrayList<FacesConfigImpl> facesConfigList = new ArrayList<FacesConfigImpl>();
            if (facesConfigURLs != null) {
                while (facesConfigURLs.hasMoreElements()) {
                    URL facesConfigURL = facesConfigURLs.nextElement();
                    logger.debug("Pre-processing faces-config: [{0}]", new Object[]{facesConfigURL});
                    facesConfigPreHandler.setURL(facesConfigURL);
                    InputStream inputStream = facesConfigURL.openStream();
                    try {
                        saxParser.parse(inputStream, (DefaultHandler)facesConfigPreHandler);
                    }
                    catch (SAXParseCompleteException e) {
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                    String facesConfigName = ((SAXHandlerFacesConfigPre)facesConfigPreHandler).getFacesConfigName();
                    if (facesConfigName == null) {
                        facesConfigName = facesConfigURL.toString();
                    }
                    FacesConfigImpl curFacesConfig = new FacesConfigImpl(facesConfigName, facesConfigURL);
                    if (LIFERAY_FACES_BRIDGE.equals(facesConfigName) || facesConfigName.indexOf("liferay-faces") >= 0 && facesConfigName.indexOf("bridge-impl") > 0) {
                        facesConfigList.add(0, curFacesConfig);
                    } else {
                        facesConfigList.add(curFacesConfig);
                    }
                    facesConfigName = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                    }
                }
                for (FacesConfig facesConfig : facesConfigList) {
                    URL facesConfigURL = facesConfig.getURL();
                    logger.debug("Post-processing faces-config: [{0}]", new Object[]{facesConfigURL});
                    facesConfigPostHandler.setURL(facesConfigURL);
                    InputStream inputStream = facesConfigURL.openStream();
                    try {
                        saxParser.parse(inputStream, (DefaultHandler)facesConfigPostHandler);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                    try {
                        saxParser.reset();
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
            }
            facesConfigPreHandler.logMissingElementErrors();
            ((SAXHandlerBaseImpl)facesConfigPostHandler).logMissingElementErrors();
            this.writeBehindRenderResponseWrapper = ((SAXHandlerFacesConfigPost)facesConfigPostHandler).getWriteBehindRenderResponseWrapper();
            this.writeBehindResourceResponseWrapper = ((SAXHandlerFacesConfigPost)facesConfigPostHandler).getWriteBehindResourceResponseWrapper();
            InputStream inputStream = this.portletContext.getResourceAsStream(FACES_CONFIG_WEB_INF_PATH);
            if (inputStream != null) {
                logger.debug("Processing faces-config: [{0}]", new Object[]{FACES_CONFIG_WEB_INF_PATH});
                saxParser.parse(inputStream, (DefaultHandler)facesConfigPostHandler);
                inputStream.close();
            }
            BeanManagerFactory beanManagerFactory = (BeanManagerFactory)this.bridgeConfigAttributeMap.get(BeanManagerFactory.class.getName());
            beanManagerFactory.setConfiguredBeans(this.configuredBeans);
            this.facesServletMappings = new ArrayList<ServletMapping>();
            Enumeration<URL> webFragmentURLs = classLoader.getResources(WEB_FRAGMENT_META_INF_PATH);
            if (webFragmentURLs != null) {
                while (webFragmentURLs.hasMoreElements()) {
                    URL webFragmentURL = webFragmentURLs.nextElement();
                    inputStream = webFragmentURL.openStream();
                    SAXHandlerWebConfigImpl webConfigHandler2 = new SAXHandlerWebConfigImpl(resolveEntities, this.facesServletMappings);
                    try {
                        saxParser.parse(inputStream, (DefaultHandler)webConfigHandler2);
                        inputStream.close();
                        saxParser.reset();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            if ((inputStream = this.portletContext.getResourceAsStream(WEB_XML_PATH)) != null) {
                logger.debug("Processing web-app: [{0}]", new Object[]{WEB_XML_PATH});
                webConfigHandler = new SAXHandlerWebConfigImpl(resolveEntities, this.facesServletMappings);
                saxParser.parse(inputStream, (DefaultHandler)webConfigHandler);
            }
            if ((inputStream = this.portletContext.getResourceAsStream(WEB_XML_LIFERAY_PATH)) != null) {
                logger.debug("Processing web-app: [{0}]", new Object[]{WEB_XML_LIFERAY_PATH});
                webConfigHandler = new SAXHandlerWebConfigImpl(resolveEntities, this.facesServletMappings);
                saxParser.parse(inputStream, (DefaultHandler)webConfigHandler);
            }
            if ((defaultSuffixParam = portletConfig.getInitParameter("javax.faces.DEFAULT_SUFFIX")) == null) {
                defaultSuffixParam = ".xhtml .view.xml .jsp";
            }
            this.defaultSuffixes = Arrays.asList(defaultSuffixParam.split(" "));
            for (String defaultSuffix : this.defaultSuffixes) {
                boolean found = false;
                for (ServletMapping explicitFacesServletMapping : this.facesServletMappings) {
                    if (!explicitFacesServletMapping.isExtensionMapped() || !explicitFacesServletMapping.getExtension().equals(defaultSuffix)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                String urlPattern = "*" + defaultSuffix;
                ServletMappingImpl implicitFacesServletMapping = new ServletMappingImpl(urlPattern);
                this.facesServletMappings.add(implicitFacesServletMapping);
                logger.debug("Added implicit extension-mapped servlet-mapping for urlPattern=[{0}]", new Object[]{urlPattern});
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), new Object[]{e});
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.bridgeConfigAttributeMap;
    }

    @Override
    public List<String> getConfiguredExtensions() {
        return this.defaultSuffixes;
    }

    @Override
    public List<ConfiguredSystemEventListener> getConfiguredSystemEventListeners() {
        return this.configuredSystemEventListeners;
    }

    @Override
    public String getContextParameter(String name) {
        return this.portletContext.getInitParameter(name);
    }

    @Override
    public Set<String> getExcludedRequestAttributes() {
        return this.excludedBridgeRequestAttributes;
    }

    @Override
    public List<ServletMapping> getFacesServletMappings() {
        return this.facesServletMappings;
    }

    @Override
    public Map<String, String[]> getPublicParameterMappings() {
        return this.publicParameterMappings;
    }

    @Override
    public String getViewIdRenderParameterName() {
        if (this.viewIdRenderParameterName == null) {
            this.viewIdRenderParameterName = this.portletContext.getInitParameter("com.liferay.faces.bridge.viewIdRenderParameterName");
            if (this.viewIdRenderParameterName == null) {
                this.viewIdRenderParameterName = FACES_VIEW_ID_RENDER;
            }
        }
        return this.viewIdRenderParameterName;
    }

    @Override
    public String getViewIdResourceParameterName() {
        if (this.viewIdResourceParameterName == null) {
            this.viewIdResourceParameterName = this.portletContext.getInitParameter("com.liferay.faces.bridge.viewIdResourceParameterName");
            if (this.viewIdResourceParameterName == null) {
                this.viewIdResourceParameterName = FACES_VIEW_ID_RESOURCE;
            }
        }
        return this.viewIdResourceParameterName;
    }

    @Override
    public String getWriteBehindRenderResponseWrapper() {
        return this.writeBehindRenderResponseWrapper;
    }

    @Override
    public String getWriteBehindResourceResponseWrapper() {
        return this.writeBehindResourceResponseWrapper;
    }
}

