/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.bean;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.reflect.Method;

public class MojarraInjectionProvider {
    private static final Logger logger = LoggerFactory.getLogger(MojarraInjectionProvider.class);
    private static final String INVOKE_PRE_DESTROY = "invokePreDestroy";
    private Method invokePreDestroyMethod;
    private Object wrappedInjectionProvider;

    public MojarraInjectionProvider(Object injectionProvider) {
        this.wrappedInjectionProvider = injectionProvider;
        try {
            this.invokePreDestroyMethod = injectionProvider.getClass().getMethod(INVOKE_PRE_DESTROY, Object.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void invokePreDestroy(Object managedBean) throws Exception {
        if (this.invokePreDestroyMethod != null) {
            this.invokePreDestroyMethod.invoke(this.wrappedInjectionProvider, managedBean);
        }
    }

    public String toString() {
        return this.wrappedInjectionProvider.toString();
    }
}

