/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.bean;

import com.liferay.faces.bridge.application.MojarraApplicationAssociate;
import com.liferay.faces.bridge.bean.BeanManagerImpl;
import com.liferay.faces.bridge.bean.MojarraInjectionProvider;
import com.liferay.faces.bridge.config.ConfiguredBean;
import com.liferay.faces.bridge.servlet.BridgeSessionListener;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class BeanManagerMojarraImpl
extends BeanManagerImpl {
    private static final Logger logger = LoggerFactory.getLogger(BeanManagerMojarraImpl.class);

    public BeanManagerMojarraImpl(List<ConfiguredBean> configuredBeans) {
        super(configuredBeans);
    }

    @Override
    public void invokePreDestroyMethods(Object managedBean, boolean preferPreDestroy) {
        if (preferPreDestroy) {
            ExternalContext externalContext;
            FacesContext facesContext;
            MojarraInjectionProvider mojarraInjectionProvider = BridgeSessionListener.getMojarraInjectionProvider();
            if (mojarraInjectionProvider == null && (facesContext = FacesContext.getCurrentInstance()) != null && (externalContext = facesContext.getExternalContext()) != null) {
                mojarraInjectionProvider = MojarraApplicationAssociate.getInjectionProvider(externalContext);
                BridgeSessionListener.setMojarraInjectionProvider(mojarraInjectionProvider);
            }
            if (mojarraInjectionProvider == null) {
                logger.debug("Directly invoking managedBean=[{0}] methods annotated with @PreDestroy since Mojarra InjectionProvider was not discovered", new Object[]{managedBean});
                super.invokePreDestroyMethods(managedBean, preferPreDestroy);
            } else {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Calling invokePreDestroy for injectionProvider=[{0}] managedBean=[{1}]", new Object[]{mojarraInjectionProvider, managedBean});
                    }
                    mojarraInjectionProvider.invokePreDestroy(managedBean);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        } else {
            super.invokePreDestroyMethods(managedBean, preferPreDestroy);
        }
    }
}

