/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.bean;

import com.liferay.faces.bridge.bean.BeanManagerCompatImpl;
import com.liferay.faces.bridge.config.ConfiguredBean;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanManagerImpl
extends BeanManagerCompatImpl {
    private static final String JAVAX_ANNOTATION_PRE_DESTROY = "javax.annotation.PreDestroy";
    private static final String JAVAX_ANNOTATION_BRIDGE_PRE_DESTROY = "javax.portlet.faces.annotation.BridgePreDestroy";
    private static final String JAVAX_PORTLET_P = "javax.portlet.p.";
    private static final Logger logger = LoggerFactory.getLogger(BeanManagerImpl.class);
    private Map<String, ConfiguredBean> configuredBeanSet = new HashMap<String, ConfiguredBean>();

    public BeanManagerImpl(List<ConfiguredBean> configuredBeans) {
        if (configuredBeans != null) {
            for (ConfiguredBean configuredBean : configuredBeans) {
                this.configuredBeanSet.put(configuredBean.getManagedBeanName(), configuredBean);
            }
        }
    }

    @Override
    public void invokePreDestroyMethods(Object managedBean, boolean preferPreDestroy) {
        if (managedBean != null) {
            Class<?> clazz = managedBean.getClass();
            Method[] methods = managedBean.getClass().getMethods();
            if (methods != null) {
                for (Method method : methods) {
                    if (preferPreDestroy) {
                        if (!this.hasPreDestroyAnnotation(method)) continue;
                        try {
                            logger.debug("Invoking @PreDestroy method named [{0}] on managedBean class=[{1}]", new Object[]{method.getName(), clazz.getName()});
                            method.invoke(managedBean, new Object[0]);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), new Object[]{e});
                        }
                        continue;
                    }
                    if (!this.hasBridgePreDestroyAnnotation(method)) continue;
                    try {
                        logger.debug("Invoking @BridgePreDestroy method named [{0}] on managedBean class=[{1}]", new Object[]{method.getName(), clazz.getName()});
                        method.invoke(managedBean, new Object[0]);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), new Object[]{e});
                    }
                }
            }
        }
    }

    protected boolean hasBridgePreDestroyAnnotation(Method method) {
        Annotation[] annotations;
        Class<?>[] parameterTypes;
        if (method.getReturnType() == Void.TYPE && ((parameterTypes = method.getParameterTypes()) == null || parameterTypes.length == 0) && (annotations = method.getAnnotations()) != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().getName().equals(JAVAX_ANNOTATION_BRIDGE_PRE_DESTROY)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasPreDestroyAnnotation(Method method) {
        Annotation[] annotations;
        Class<?>[] parameterTypes;
        if (method.getReturnType() == Void.TYPE && ((parameterTypes = method.getParameterTypes()) == null || parameterTypes.length == 0) && (annotations = method.getAnnotations()) != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().getName().equals(JAVAX_ANNOTATION_PRE_DESTROY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isManagedBean(String name, Object value) {
        boolean managedBean = false;
        if (value != null) {
            if (this.hasManagedBeanAnnotation(value)) {
                managedBean = true;
            } else if (name != null) {
                ConfiguredBean configuredBean;
                int pos;
                if (name.startsWith(JAVAX_PORTLET_P) && (pos = name.indexOf("?")) > 0) {
                    name = name.substring(pos + 1);
                }
                if ((configuredBean = this.configuredBeanSet.get(name)) != null) {
                    String managedBeanClass = value.getClass().getName();
                    managedBean = managedBeanClass.equals(configuredBean.getManagedBeanClass());
                }
            }
        }
        return managedBean;
    }
}

