/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.config.BridgeConfigFactory;
import com.liferay.faces.bridge.config.ServletMapping;
import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.Resource;
import javax.faces.application.ResourceWrapper;
import javax.faces.context.FacesContext;

public class ResourceImpl
extends ResourceWrapper
implements Serializable {
    private static final long serialVersionUID = 827821821511052062L;
    private static final Logger logger = LoggerFactory.getLogger(ResourceImpl.class);
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HTTP_SPEC_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String EXTENSION_FACES = ".faces";
    private static final String LIBRARY_NAME_JAVAX_FACES = "javax.faces";
    private static final ArrayList<String> NON_CACHED_RESOURCES = new ArrayList(5);
    private Long lastModifiedInSeconds;
    private Resource wrappedResource;

    public ResourceImpl() {
    }

    public ResourceImpl(Resource wrappedResource) {
        this.wrappedResource = wrappedResource;
    }

    public String toString() {
        return this.wrappedResource.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userAgentNeedsUpdate(FacesContext facesContext) {
        String resourceName = this.getResourceName();
        boolean needsUpdate = this.wrappedResource.userAgentNeedsUpdate(facesContext);
        if (!needsUpdate) {
            if (NON_CACHED_RESOURCES.contains(resourceName)) {
                needsUpdate = true;
            } else {
                if (this.lastModifiedInSeconds == null) {
                    URL url = this.wrappedResource.getURL();
                    if (url != null) {
                        InputStream inputStream = null;
                        try {
                            URLConnection urlConnection = url.openConnection();
                            urlConnection.setUseCaches(false);
                            urlConnection.connect();
                            inputStream = urlConnection.getInputStream();
                            long lastModifiedInMilliSeconds = urlConnection.getLastModified();
                            this.lastModifiedInSeconds = new Long(lastModifiedInMilliSeconds / 1000L);
                        }
                        catch (IOException e) {
                            this.lastModifiedInSeconds = new Long(0L);
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    } else {
                        logger.warn("Unable to determine if user agent needs update because resource URL was null for resourceName=[{0}].", new Object[]{resourceName});
                    }
                }
                if (this.lastModifiedInSeconds != null) {
                    long ifModifiedHeaderInSeconds = 0L;
                    Map requestHeaderMap = facesContext.getExternalContext().getRequestHeaderMap();
                    if (requestHeaderMap.containsKey(HEADER_IF_MODIFIED_SINCE)) {
                        String requestHeaderValue = (String)requestHeaderMap.get(HEADER_IF_MODIFIED_SINCE);
                        try {
                            SimpleDateFormat httpSpecDateFormat = new SimpleDateFormat(HTTP_SPEC_DATE_PATTERN, Locale.US);
                            httpSpecDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                            long ifModifiedHeaderInMilliSeconds = httpSpecDateFormat.parse(requestHeaderValue).getTime();
                            ifModifiedHeaderInSeconds = ifModifiedHeaderInMilliSeconds / 1000L;
                            if (logger.isDebugEnabled()) {
                                logger.debug("resourceName=[{0}] requestHeaderValue=[{1}] ifModifiedHeaderInSeconds=[{2}]", new Object[]{resourceName, requestHeaderValue, Long.toString(ifModifiedHeaderInSeconds)});
                            }
                        }
                        catch (ParseException e) {
                            logger.error("Unable to parse request-header=[{0}] value=[{1}]", new Object[]{HEADER_IF_MODIFIED_SINCE, requestHeaderValue});
                        }
                    } else {
                        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
                        PortletContainer portletContainer = bridgeContext.getPortletContainer();
                        long ifModifiedHeaderInMilliSeconds = portletContainer.getHttpServletRequestDateHeader(HEADER_IF_MODIFIED_SINCE);
                        ifModifiedHeaderInSeconds = ifModifiedHeaderInMilliSeconds / 1000L;
                        if (logger.isDebugEnabled()) {
                            logger.debug("resourceName=[{0}] portletContainer ifModifiedHeaderInSeconds=[{1}]", new Object[]{resourceName, Long.toString(ifModifiedHeaderInSeconds)});
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("resourceName=[{0}] lastModified=[{1}] ifModifiedHeaderInSeconds=[{2}]", new Object[]{resourceName, Long.toString(this.lastModifiedInSeconds), Long.toString(ifModifiedHeaderInSeconds)});
                    }
                    needsUpdate = this.lastModifiedInSeconds > ifModifiedHeaderInSeconds;
                }
            }
        }
        logger.debug("resourceName=[{0}] needsUpdate=[{1}]", new Object[]{resourceName, needsUpdate});
        return needsUpdate;
    }

    public String getContentType() {
        return this.wrappedResource.getContentType();
    }

    public void setContentType(String contentType) {
        this.wrappedResource.setContentType(contentType);
    }

    public String getLibraryName() {
        return this.wrappedResource.getLibraryName();
    }

    public void setLibraryName(String libraryName) {
        this.wrappedResource.setLibraryName(libraryName);
    }

    public String getRequestPath() {
        String wrappedRequestPath = this.wrappedResource.getRequestPath();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (wrappedRequestPath != null) {
            BridgeConfigFactory bridgeConfigFactory;
            BridgeConfig bridgeConfig;
            List<ServletMapping> servletMappings;
            if (wrappedRequestPath.contains("/javax.faces.resource") && (servletMappings = (bridgeConfig = (bridgeConfigFactory = (BridgeConfigFactory)BridgeFactoryFinder.getFactory(BridgeConfigFactory.class)).getBridgeConfig()).getFacesServletMappings()) != null) {
                for (ServletMapping servletMapping : servletMappings) {
                    if (!servletMapping.isExtensionMapped()) continue;
                    String extension = servletMapping.getExtension();
                    String token = extension + "?" + "ln";
                    int pos = wrappedRequestPath.indexOf(token);
                    if (pos > 0) {
                        wrappedRequestPath = wrappedRequestPath.substring(0, pos) + wrappedRequestPath.substring(pos + extension.length());
                        logger.debug("Removed extension=[{0}] from requestPath=[{1}]", new Object[]{extension, wrappedRequestPath});
                        continue;
                    }
                    if (!wrappedRequestPath.endsWith(extension) || extension.equals(EXTENSION_FACES) && wrappedRequestPath.endsWith(LIBRARY_NAME_JAVAX_FACES)) continue;
                    wrappedRequestPath = wrappedRequestPath.substring(0, wrappedRequestPath.lastIndexOf(extension));
                    logger.debug("Removed extension=[{0}] from requestPath=[{1}]", new Object[]{extension, wrappedRequestPath});
                }
            }
            if (wrappedRequestPath.endsWith("org.richfaces")) {
                String resourcePath = "META-INF/resources/org.richfaces/" + this.getResourceName();
                URL resourceURL = this.getClass().getClassLoader().getResource(resourcePath);
                if (resourceURL != null) {
                    wrappedRequestPath = wrappedRequestPath + ".images";
                }
            }
        }
        String encodedResourceURL = facesContext.getExternalContext().encodeResourceURL(wrappedRequestPath);
        return encodedResourceURL;
    }

    public String getResourceName() {
        return this.wrappedResource.getResourceName();
    }

    public void setResourceName(String resourceName) {
        this.wrappedResource.setResourceName(resourceName);
    }

    public Resource getWrapped() {
        return this.wrappedResource;
    }

    static {
        NON_CACHED_RESOURCES.add("jsf.js");
        NON_CACHED_RESOURCES.add("bridge.js");
        NON_CACHED_RESOURCES.add("bridge.uncompressed.js");
        NON_CACHED_RESOURCES.add("compat.js");
        NON_CACHED_RESOURCES.add("compat.uncompressed.js");
        NON_CACHED_RESOURCES.add("icefaces-compat.js");
        NON_CACHED_RESOURCES.add("icefaces-compat.uncompressed.js");
        NON_CACHED_RESOURCES.add("icepush.js");
        NON_CACHED_RESOURCES.add("icepush.uncompressed.js");
        NON_CACHED_RESOURCES.add("compat.js");
        NON_CACHED_RESOURCES.add("icefaces-compat.js");
    }
}

