/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application;

import com.liferay.faces.bridge.application.MissingResourceImpl;
import com.liferay.faces.bridge.application.ResourceImpl;
import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.util.application.ResourceHandlerWrapperBase;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ResourceHandlerBridgeImpl
extends ResourceHandlerWrapperBase {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHandlerBridgeImpl.class);
    private Integer bufferSize;

    public ResourceHandlerBridgeImpl(ResourceHandler resourceHandler) {
        super(resourceHandler);
    }

    public Resource createResource(String resourceName) {
        Resource wrappableResource = this.getWrapped().createResource(resourceName);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.getWrapped(), resourceName);
        }
        return new ResourceImpl(wrappableResource);
    }

    public Resource createResource(String resourceName, String libraryName) {
        Resource wrappableResource = this.getWrapped().createResource(resourceName, libraryName);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.getWrapped(), resourceName, libraryName);
        }
        return new ResourceImpl(wrappableResource);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource wrappableResource = this.getWrapped().createResource(resourceName, libraryName, contentType);
        if (wrappableResource == null) {
            return new MissingResourceImpl(this.getWrapped(), resourceName, libraryName, contentType);
        }
        return new ResourceImpl(wrappableResource);
    }

    public int getBufferSize(FacesContext facesContext) {
        if (this.bufferSize == null) {
            this.bufferSize = 1024;
            String constantName = "com.liferay.faces.bridge.resourceBufferSize";
            ExternalContext externalContext = facesContext.getExternalContext();
            String sizeAsString = externalContext.getInitParameter(constantName);
            if (sizeAsString == null) {
                constantName = "org.portletfaces.bridge.resourceBufferSize";
                sizeAsString = externalContext.getInitParameter(constantName);
            }
            if (sizeAsString != null) {
                try {
                    this.bufferSize = Integer.parseInt(sizeAsString);
                    logger.debug("Found portlet.xml init-param name=[{0}] value=[{1}]", new Object[]{constantName, this.bufferSize});
                }
                catch (NumberFormatException e) {
                    logger.error("Invalid value=[{0}] for portlet.xml init-param {1}", new Object[]{sizeAsString, constantName});
                }
            } else {
                logger.debug("Returning default portletbufferSize=[{0}]", new Object[]{this.bufferSize});
            }
        }
        return this.bufferSize;
    }

    public boolean isAbleToSetHttpStatusCode(FacesContext facesContext) {
        BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
        PortletContainer portletContainer = bridgeContext.getPortletContainer();
        return portletContainer.isAbleToSetHttpStatusCode();
    }
}

