/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application;

import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;

public class MissingResourceImpl
extends Resource {
    private static final Logger logger = LoggerFactory.getLogger(MissingResourceImpl.class);
    private static final String ERROR_MSG = "Resource handler=[{0}] was unable to create a resource for resourceName=[{1}] libraryName=[{2}] contentType=[{3}]";
    private static final String RES_NOT_FOUND = "RES_NOT_FOUND";
    private String contentType;
    ResourceHandler failedResourceHandler;
    private String libraryName;
    private String resourceName;

    public MissingResourceImpl(ResourceHandler failedResourceHandler, String resourceName) {
        this.failedResourceHandler = failedResourceHandler;
        this.resourceName = resourceName;
    }

    public MissingResourceImpl(ResourceHandler failedResourceHandler, String resourceName, String libraryName) {
        this.failedResourceHandler = failedResourceHandler;
        this.resourceName = resourceName;
        this.libraryName = libraryName;
    }

    public MissingResourceImpl(ResourceHandler failedResourceHandler, String resourceName, String libraryName, String contentType) {
        this.failedResourceHandler = failedResourceHandler;
        this.resourceName = resourceName;
        this.libraryName = libraryName;
        this.contentType = contentType;
    }

    public String toString() {
        return RES_NOT_FOUND;
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        logger.error(ERROR_MSG, new Object[]{this.failedResourceHandler, this.resourceName, this.libraryName, this.contentType});
        return false;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public InputStream getInputStream() throws IOException {
        logger.error(ERROR_MSG, new Object[]{this.failedResourceHandler, this.resourceName, this.libraryName, this.contentType});
        return new ByteArrayInputStream(new byte[0]);
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public String getRequestPath() {
        logger.error(ERROR_MSG, new Object[]{this.failedResourceHandler, this.resourceName, this.libraryName, this.contentType});
        return RES_NOT_FOUND;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Map<String, String> getResponseHeaders() {
        logger.error(ERROR_MSG, new Object[]{this.failedResourceHandler, this.resourceName, this.libraryName, this.contentType});
        return new HashMap<String, String>();
    }

    public URL getURL() {
        logger.error(ERROR_MSG, new Object[]{this.failedResourceHandler, this.resourceName, this.libraryName, this.contentType});
        return null;
    }
}

