/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge.application;

import com.liferay.faces.bridge.application.ResourceHandlerOuterImpl;
import com.liferay.faces.bridge.component.UIViewRootBridgeImpl;
import com.liferay.faces.bridge.component.icefaces.DataPaginator;
import com.liferay.faces.bridge.component.icefaces.DataPaginatorBridgeImpl;
import com.liferay.faces.bridge.config.ConfiguredSystemEventListener;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.SystemEventListener;

public abstract class ApplicationCompatImpl
extends ApplicationWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationCompatImpl.class);
    private Application wrappedApplication;

    public ApplicationCompatImpl(Application application) {
        this.wrappedApplication = application;
    }

    public UIComponent createComponent(FacesContext facesContext, String componentType, String rendererType) {
        Object wrappedUIComponent = this.wrappedApplication.createComponent(facesContext, componentType, rendererType);
        if (componentType.equals("com.icesoft.faces.DataScroller")) {
            DataPaginatorBridgeImpl dataPaginator = new DataPaginatorBridgeImpl(wrappedUIComponent);
            try {
                ((DataPaginator)dataPaginator).setUIData(((DataPaginator)dataPaginator).findUIData(facesContext));
                wrappedUIComponent = dataPaginator;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return wrappedUIComponent;
    }

    protected void subscribeToJSF2SystemEvent(ConfiguredSystemEventListener configuredSystemEventListener) {
        try {
            Class<?> systemEventClass = Class.forName(configuredSystemEventListener.getSystemEventClass());
            Class<?> systemEventListenerClass = Class.forName(configuredSystemEventListener.getSystemEventListenerClass());
            SystemEventListener systemEventListener = (SystemEventListener)systemEventListenerClass.newInstance();
            logger.debug("Subscribing UIViewRootBridgeImpl for systemEventClass=[{0}] systemEventListener=[{1}]", new Object[]{systemEventClass, systemEventListener});
            this.subscribeToEvent(systemEventClass, UIViewRootBridgeImpl.class, systemEventListener);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public ResourceHandler getResourceHandler() {
        Object resourceHandler = super.getResourceHandler();
        if (resourceHandler != null) {
            resourceHandler = new ResourceHandlerOuterImpl((ResourceHandler)resourceHandler);
        }
        return resourceHandler;
    }

    public Application getWrapped() {
        return this.wrappedApplication;
    }
}

