/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge;

import com.liferay.faces.bridge.BridgePhaseCompat_2_2_Impl;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;

public class BridgePhaseResourceImpl
extends BridgePhaseCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseResourceImpl.class);
    private ResourceRequest resourceRequest;
    private ResourceResponse resourceResponse;

    public BridgePhaseResourceImpl(ResourceRequest resourceRequest, ResourceResponse resourceResponse, PortletConfig portletConfig) {
        super(portletConfig);
        this.resourceRequest = resourceRequest;
        this.resourceResponse = resourceResponse;
    }

    @Override
    public void execute() throws BridgeDefaultViewNotSpecifiedException, BridgeException {
        logger.debug("----------------------------------------------------------------------");
        logger.debug("execute(ResourceRequest, ResourceResponse) portletName=[{0}]", new Object[]{this.portletName});
        try {
            this.init((PortletRequest)this.resourceRequest, (PortletResponse)this.resourceResponse, Bridge.PortletPhase.RESOURCE_PHASE);
            if (this.isJSF2ResourceRequest(this.facesContext)) {
                logger.debug("Detected JSF2 resource request");
                this.handleJSF2ResourceRequest(this.facesContext);
            } else if (this.resourceRequest.getResourceID() != null && !this.resourceRequest.getResourceID().equals("wsrp")) {
                logger.debug("Detected non-Faces resource");
                String resourceId = this.resourceRequest.getResourceID();
                PortletRequestDispatcher portletRequestDispatcher = this.portletContext.getRequestDispatcher(resourceId);
                portletRequestDispatcher.forward((PortletRequest)this.resourceRequest, (PortletResponse)this.resourceResponse);
            } else {
                if (logger.isDebugEnabled()) {
                    String facesAjaxParameter = this.bridgeContext.getRequestParameterMap().get("_jsfBridgeAjax");
                    if (BooleanHelper.isTrueToken((String)facesAjaxParameter)) {
                        logger.debug("Detected Ajax ResourceRequest");
                    } else {
                        logger.debug("Detected Non-Ajax ResourceRequest");
                    }
                }
                String viewId = this.bridgeContext.getFacesViewId();
                logger.debug("Running Faces lifecycle for viewId=[{0}]", new Object[]{viewId});
                this.attachClientWindowToLifecycle(this.facesContext, this.facesLifecycle);
                this.facesLifecycle.execute(this.facesContext);
                this.facesLifecycle.render(this.facesContext);
                if (this.bridgeRequestScope != null) {
                    this.bridgeRequestScope.setPortletMode(this.resourceRequest.getPortletMode());
                    this.bridgeRequestScope.saveState(this.facesContext);
                    this.maintainBridgeRequestScope((PortletRequest)this.resourceRequest, (PortletResponse)this.resourceResponse, BridgeRequestScope.Transport.PORTLET_SESSION_ATTRIBUTE);
                }
                this.indicateNamespacingToConsumers(this.facesContext.getViewRoot(), (PortletResponse)this.resourceResponse);
            }
        }
        catch (Throwable t) {
            throw new BridgeException(t);
        }
        finally {
            this.cleanup();
        }
        logger.debug("----------------------------------------------------------------------");
    }
}

