/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge;

import com.liferay.faces.bridge.BridgePhaseCompat_2_2_Impl;
import com.liferay.faces.bridge.application.BridgeNavigationHandler;
import com.liferay.faces.bridge.application.BridgeNavigationHandlerImpl;
import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.context.IncongruityContext;
import com.liferay.faces.bridge.context.RenderRedirectWriter;
import com.liferay.faces.bridge.context.url.BridgeRedirectURL;
import com.liferay.faces.bridge.event.IPCPhaseListener;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;

public class BridgePhaseRenderImpl
extends BridgePhaseCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseRenderImpl.class);
    private RenderRequest renderRequest;
    private RenderResponse renderResponse;

    public BridgePhaseRenderImpl(RenderRequest renderRequest, RenderResponse renderResponse, PortletConfig portletConfig) {
        super(portletConfig);
        this.renderRequest = renderRequest;
        this.renderResponse = renderResponse;
    }

    @Override
    public void execute() throws BridgeDefaultViewNotSpecifiedException, BridgeException {
        logger.debug("----------------------------------------------------------------------");
        logger.debug("execute(RenderRequest, RenderResponse) portletName=[{0}] portletMode=[{1}]", new Object[]{this.portletName, this.renderRequest.getPortletMode()});
        Object renderPartAttribute = this.renderRequest.getAttribute("javax.portlet.render_part");
        if (renderPartAttribute != null && renderPartAttribute.equals("RENDER_HEADERS")) {
            this.doFacesHeaders(this.renderRequest, this.renderResponse);
        } else {
            try {
                this.execute(null);
            }
            catch (BridgeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new BridgeException(t);
            }
            finally {
                this.cleanup();
            }
            logger.debug("----------------------------------------------------------------------");
        }
    }

    @Override
    protected void cleanup() {
        if (this.bridgeContext != null && !this.bridgeContext.isBridgeRequestScopePreserved()) {
            this.bridgeRequestScopeCache.remove(this.bridgeRequestScope.getId());
        }
        super.cleanup();
    }

    protected void doFacesHeaders(RenderRequest renderRequest, RenderResponse renderResponse) {
        logger.trace("doFacesHeaders(RenderRequest, RenderResponse) this=[{0}]", new Object[]{this});
    }

    protected void execute(BridgeRedirectURL renderRedirectURL) throws BridgeDefaultViewNotSpecifiedException, BridgeException, IOException {
        boolean manageIncongruities;
        this.init((PortletRequest)this.renderRequest, (PortletResponse)this.renderResponse, Bridge.PortletPhase.RENDER_PHASE);
        boolean facesLifecycleExecuted = this.bridgeRequestScope.isFacesLifecycleExecuted();
        this.bridgeRequestScope.restoreState(this.facesContext);
        if (this.bridgeRequestScope.isPortletModeChanged()) {
            this.bridgeRequestScopeCache.remove(this.bridgeRequestScope.getId());
        }
        if (renderRedirectURL != null) {
            this.bridgeContext.setRenderRedirectURL(renderRedirectURL);
            this.bridgeContext.setRenderRedirectAfterDispatch(true);
            ViewHandler viewHandler = this.facesContext.getApplication().getViewHandler();
            UIViewRoot uiViewRoot = viewHandler.createView(this.facesContext, renderRedirectURL.getContextRelativePath());
            this.facesContext.setViewRoot(uiViewRoot);
            String viewId = this.bridgeContext.getFacesViewId();
            logger.debug("Performed render-redirect to viewId=[{0}]", new Object[]{viewId});
        }
        if (this.bridgeRequestScope.getBeganInPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            this.facesContext.getExternalContext().getRequestMap().put("javax.portlet.faces.isPostback", Boolean.TRUE);
        }
        logger.debug("portletName=[{0}] facesLifecycleExecuted=[{1}]", new Object[]{this.portletName, facesLifecycleExecuted});
        if (facesLifecycleExecuted) {
            PhaseListener[] phaseListeners;
            PhaseEvent restoreViewPhaseEvent = new PhaseEvent(this.facesContext, PhaseId.RESTORE_VIEW, this.facesLifecycle);
            for (PhaseListener phaseListener : phaseListeners = this.facesLifecycle.getPhaseListeners()) {
                if (!(phaseListener instanceof IPCPhaseListener)) continue;
                phaseListener.afterPhase(restoreViewPhaseEvent);
                break;
            }
        } else {
            try {
                String viewId = this.bridgeContext.getFacesViewId();
                logger.debug("Executing Faces lifecycle for viewId=[{0}]", new Object[]{viewId});
            }
            catch (BridgeException e) {
                logger.error("Unable to get viewId due to {0}", new Object[]{((Object)((Object)e)).getClass().getSimpleName()});
                throw e;
            }
            this.facesLifecycle.execute(this.facesContext);
        }
        Throwable handledException = this.getJSF2HandledException(this.facesContext);
        if (handledException != null) {
            throw new BridgeException(handledException);
        }
        Throwable unhandledException = this.getJSF2UnhandledException(this.facesContext);
        if (unhandledException != null) {
            throw new BridgeException(unhandledException);
        }
        if (this.bridgeRequestScope.isPortletModeChanged() && !this.bridgeRequestScope.isNavigationOccurred()) {
            BridgeNavigationHandler bridgeNavigationHandler = this.getBridgeNavigationHandler(this.facesContext);
            PortletMode fromPortletMode = this.bridgeRequestScope.getPortletMode();
            PortletMode toPortletMode = this.renderRequest.getPortletMode();
            bridgeNavigationHandler.handleNavigation(this.facesContext, fromPortletMode, toPortletMode);
        }
        if (manageIncongruities = BooleanHelper.toBoolean((String)this.bridgeContext.getInitParameter("com.liferay.faces.bridge.manageIncongruities"), (boolean)true)) {
            this.incongruityContext.makeCongruous(this.facesContext);
        }
        logger.debug("Executing Faces render");
        this.facesLifecycle.render(this.facesContext);
        this.setViewHistory(this.facesContext.getViewRoot().getViewId());
        this.indicateNamespacingToConsumers(this.facesContext.getViewRoot(), (PortletResponse)this.renderResponse);
        Writer writer = this.bridgeContext.getResponseOutputWriter();
        if (this.bridgeContext.isRenderRedirect()) {
            this.facesContext.responseComplete();
            this.facesContext.release();
            if (writer instanceof RenderRedirectWriter) {
                RenderRedirectWriter responseOutputWriter = (RenderRedirectWriter)writer;
                responseOutputWriter.discard();
            }
            this.execute(this.bridgeContext.getRenderRedirectURL());
        } else if (writer instanceof RenderRedirectWriter) {
            RenderRedirectWriter responseOutputWriter = (RenderRedirectWriter)writer;
            responseOutputWriter.render();
        }
    }

    @Override
    protected void initBridgeRequestScope(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase, PortletContainer portletContainer, IncongruityContext incongruityContext) {
        super.initBridgeRequestScope(portletRequest, portletResponse, portletPhase, portletContainer, incongruityContext);
        if (!portletContainer.isPostRedirectGetSupported() && this.bridgeRequestScope.getBeganInPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            this.bridgeRequestScope.removeExcludedAttributes(this.renderRequest);
        }
    }

    protected BridgeNavigationHandler getBridgeNavigationHandler(FacesContext facesContext) {
        BridgeNavigationHandler bridgeNavigationHandler = null;
        NavigationHandler navigationHandler = facesContext.getApplication().getNavigationHandler();
        bridgeNavigationHandler = navigationHandler instanceof BridgeNavigationHandler ? (BridgeNavigationHandler)navigationHandler : new BridgeNavigationHandlerImpl(navigationHandler);
        return bridgeNavigationHandler;
    }

    protected void setViewHistory(String viewId) {
        StringBuilder buf = new StringBuilder();
        buf.append("javax.portlet.faces.viewIdHistory");
        buf.append(".");
        buf.append(this.renderRequest.getPortletMode());
        String attributeName = buf.toString();
        PortletSession portletSession = this.renderRequest.getPortletSession();
        portletSession.setAttribute(attributeName, (Object)viewId);
    }
}

