/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge;

import com.liferay.faces.bridge.BridgePhaseCompat_2_2_Impl;
import com.liferay.faces.bridge.event.EventPayloadWrapper;
import com.liferay.faces.bridge.event.IPCPhaseListener;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.io.Serializable;
import javax.faces.application.NavigationHandler;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeEventHandler;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.event.EventNavigationResult;

public class BridgePhaseEventImpl
extends BridgePhaseCompat_2_2_Impl {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseEventImpl.class);
    private EventRequest eventRequest;
    private EventResponse eventResponse;

    public BridgePhaseEventImpl(EventRequest eventRequest, EventResponse eventResponse, PortletConfig portletConfig) {
        super(portletConfig);
        this.eventRequest = eventRequest;
        this.eventResponse = eventResponse;
    }

    @Override
    public void execute() throws BridgeDefaultViewNotSpecifiedException, BridgeException {
        logger.debug("----------------------------------------------------------------------");
        logger.debug("execute(EventRequest, EventResponse) portletName=[{0}]", new Object[]{this.portletName});
        try {
            String bridgeEventHandlerAttributeName = "javax.portlet.faces." + this.portletName + "." + "bridgeEventHandler";
            BridgeEventHandler bridgeEventHandler = (BridgeEventHandler)this.portletContext.getAttribute(bridgeEventHandlerAttributeName);
            this.init((PortletRequest)this.eventRequest, (PortletResponse)this.eventResponse, Bridge.PortletPhase.EVENT_PHASE);
            if (bridgeEventHandler != null) {
                EventPayloadWrapper eventPayloadWrapper;
                this.bridgeRequestScope.restoreState(this.facesContext);
                this.bridgeRequestScope.setPortletMode(this.eventRequest.getPortletMode());
                this.facesLifecycle.execute(this.facesContext);
                Throwable handledException = this.getJSF2HandledException(this.facesContext);
                if (handledException != null) {
                    throw new BridgeException(handledException);
                }
                Throwable unhandledException = this.getJSF2UnhandledException(this.facesContext);
                if (unhandledException != null) {
                    throw new BridgeException(unhandledException);
                }
                this.bridgeRequestScope.setFacesLifecycleExecuted(true);
                logger.debug("Invoking {0} for class=[{1}]", new Object[]{bridgeEventHandlerAttributeName, bridgeEventHandler.getClass()});
                Event event = this.eventRequest.getEvent();
                EventNavigationResult eventNavigationResult = bridgeEventHandler.handleEvent(this.facesContext, event);
                if (eventNavigationResult != null) {
                    String oldViewId = this.facesContext.getViewRoot().getViewId();
                    String fromAction = eventNavigationResult.getFromAction();
                    String outcome = eventNavigationResult.getOutcome();
                    logger.debug("Invoking navigationHandler fromAction=[{0}] outcome=[{1}]", new Object[]{fromAction, outcome});
                    NavigationHandler navigationHandler = this.facesContext.getApplication().getNavigationHandler();
                    navigationHandler.handleNavigation(this.facesContext, fromAction, outcome);
                    String newViewId = this.facesContext.getViewRoot().getViewId();
                    this.bridgeRequestScope.setNavigationOccurred(!oldViewId.equals(newViewId));
                }
                this.bridgeRequestScope.saveState(this.facesContext);
                BridgeRequestScope.Transport bridgeRequestScopeTransport = BridgeRequestScope.Transport.RENDER_PARAMETER;
                Serializable eventPayload = event.getValue();
                if (eventPayload != null && eventPayload instanceof EventPayloadWrapper && (eventPayloadWrapper = (EventPayloadWrapper)eventPayload).isRedirect()) {
                    bridgeRequestScopeTransport = BridgeRequestScope.Transport.PORTLET_SESSION_ATTRIBUTE;
                }
                this.maintainBridgeRequestScope((PortletRequest)this.eventRequest, (PortletResponse)this.eventResponse, bridgeRequestScopeTransport);
                this.processOutgoingPublicRenderParameters(this.facesLifecycle);
            }
            this.bridgeContext.getPortletContainer().maintainRenderParameters(this.eventRequest, this.eventResponse);
            this.indicateNamespacingToConsumers(this.facesContext.getViewRoot(), (PortletResponse)this.eventResponse);
        }
        catch (Throwable t) {
            throw new BridgeException(t);
        }
        finally {
            this.cleanup();
        }
    }

    protected void processOutgoingPublicRenderParameters(Lifecycle lifecycle) {
        PhaseListener[] phaseListeners;
        for (PhaseListener phaseListener : phaseListeners = lifecycle.getPhaseListeners()) {
            if (!(phaseListener instanceof IPCPhaseListener)) continue;
            IPCPhaseListener ipcPhaseListener = (IPCPhaseListener)phaseListener;
            ipcPhaseListener.processOutgoingPublicRenderParameters(this.bridgeContext, this.facesContext);
            break;
        }
    }
}

