/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.BridgePhase;
import com.liferay.faces.bridge.config.BridgeConfig;
import com.liferay.faces.bridge.config.BridgeConfigFactory;
import com.liferay.faces.bridge.container.PortletContainer;
import com.liferay.faces.bridge.container.PortletContainerFactory;
import com.liferay.faces.bridge.context.BridgeContext;
import com.liferay.faces.bridge.context.BridgeContextFactory;
import com.liferay.faces.bridge.context.IncongruityContext;
import com.liferay.faces.bridge.context.IncongruityContextFactory;
import com.liferay.faces.bridge.helper.PortletModeHelper;
import com.liferay.faces.bridge.scope.BridgeRequestScope;
import com.liferay.faces.bridge.scope.BridgeRequestScopeCache;
import com.liferay.faces.bridge.scope.BridgeRequestScopeCacheFactory;
import com.liferay.faces.bridge.scope.BridgeRequestScopeFactory;
import com.liferay.faces.util.helper.BooleanHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import javax.el.ELContext;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.StateAwareResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.annotation.PortletNamingContainer;

public abstract class BridgePhaseBaseImpl
implements BridgePhase {
    private static final Logger logger = LoggerFactory.getLogger(BridgePhaseBaseImpl.class);
    private static final String PARAM_BRIDGE_REQUEST_SCOPE_ID = "com.liferay.faces.bridge.bridgeRequestScopeId";
    protected BridgeConfig bridgeConfig;
    protected BridgeContext bridgeContext;
    protected BridgeRequestScope bridgeRequestScope;
    protected BridgeRequestScopeCache bridgeRequestScopeCache;
    protected FacesContext facesContext;
    protected IncongruityContext incongruityContext;
    protected Lifecycle facesLifecycle;
    protected PortletConfig portletConfig;
    protected PortletContext portletContext;
    protected String portletName;
    private FacesContextFactory facesContextFactory;
    private String pathInfo;
    private String servletPath;

    public BridgePhaseBaseImpl(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
        this.portletContext = portletConfig.getPortletContext();
        this.portletName = portletConfig.getPortletName();
        BridgeConfigFactory bridgeConfigFactory = (BridgeConfigFactory)BridgeFactoryFinder.getFactory(BridgeConfigFactory.class);
        this.bridgeConfig = bridgeConfigFactory.getBridgeConfig();
        IncongruityContextFactory incongruityContextFactory = (IncongruityContextFactory)BridgeFactoryFinder.getFactory(IncongruityContextFactory.class);
        this.incongruityContext = incongruityContextFactory.getIncongruityContext();
        BridgeRequestScopeCacheFactory bridgeRequestScopeCacheFactory = (BridgeRequestScopeCacheFactory)BridgeFactoryFinder.getFactory(BridgeRequestScopeCacheFactory.class);
        this.bridgeRequestScopeCache = bridgeRequestScopeCacheFactory.getBridgeRequestScopeCache(this.portletContext);
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        String lifecycleId = this.portletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId == null) {
            lifecycleId = "DEFAULT";
        }
        this.facesLifecycle = lifecycleFactory.getLifecycle(lifecycleId);
    }

    protected void cleanup() {
        if (this.facesContext != null) {
            this.facesContext.release();
        }
        if (this.bridgeContext != null) {
            PortletRequest portletRequest = this.bridgeContext.getPortletRequest();
            if (portletRequest != null) {
                portletRequest.removeAttribute("javax.portlet.faces.bridgeContext");
                portletRequest.removeAttribute("javax.portlet.faces.phase");
                portletRequest.setAttribute("javax.servlet.include.path_info", (Object)this.pathInfo);
                portletRequest.setAttribute("javax.servlet.include.servlet_path", (Object)this.servletPath);
            }
            this.bridgeContext.release();
        }
    }

    protected void indicateNamespacingToConsumers(UIViewRoot uiViewRoot, PortletResponse portletResponse) {
        if (uiViewRoot != null) {
            if (uiViewRoot.getClass().getAnnotation(PortletNamingContainer.class) != null) {
                portletResponse.addProperty("X-JAVAX-PORTLET-FACES-NAMESPACED-RESPONSE", Boolean.TRUE.toString());
            }
        } else {
            logger.debug("UIViewRoot is null -- might be push related");
        }
    }

    protected void init(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase) {
        portletRequest.setAttribute("javax.portlet.faces.phase", (Object)portletPhase);
        PortletContainerFactory portletContainerFactory = (PortletContainerFactory)BridgeFactoryFinder.getFactory(PortletContainerFactory.class);
        PortletContainer portletContainer = portletContainerFactory.getPortletContainer(portletRequest, portletResponse, this.portletContext, this.bridgeConfig);
        this.initBridgeRequestScope(portletRequest, portletResponse, portletPhase, portletContainer, this.incongruityContext);
        BridgeContextFactory bridgeContextFactory = (BridgeContextFactory)BridgeFactoryFinder.getFactory(BridgeContextFactory.class);
        this.bridgeContext = bridgeContextFactory.getBridgeContext(this.bridgeConfig, this.bridgeRequestScope, this.portletConfig, this.portletContext, portletRequest, portletResponse, portletPhase, portletContainer, this.incongruityContext);
        portletRequest.setAttribute("javax.portlet.faces.bridgeContext", (Object)this.bridgeContext);
        this.facesContext = this.getFacesContext(portletRequest, portletResponse, this.facesLifecycle);
        this.pathInfo = (String)portletRequest.getAttribute("javax.servlet.include.path_info");
        portletRequest.removeAttribute("javax.servlet.include.path_info");
        this.servletPath = (String)portletRequest.getAttribute("javax.servlet.include.servlet_path");
        portletRequest.removeAttribute("javax.servlet.include.servlet_path");
        for (String portletMode : PortletModeHelper.PORTLET_MODE_NAMES) {
            StringBuilder buf = new StringBuilder();
            buf.append("javax.portlet.faces.viewIdHistory");
            buf.append(".");
            buf.append(portletMode);
            String attributeName = buf.toString();
            PortletSession portletSession = portletRequest.getPortletSession();
            if (portletSession.getAttribute(attributeName) != null) continue;
            portletSession.setAttribute(attributeName, (Object)this.bridgeContext.getDefaultViewIdMap().get(portletMode));
        }
    }

    protected void initBridgeRequestScope(PortletRequest portletRequest, PortletResponse portletResponse, Bridge.PortletPhase portletPhase, PortletContainer portletContainer, IncongruityContext incongruityContext) {
        boolean bridgeRequestScopeEnabled = true;
        if (portletPhase == Bridge.PortletPhase.RESOURCE_PHASE) {
            bridgeRequestScopeEnabled = BooleanHelper.toBoolean((String)this.getInitParameter("com.liferay.faces.bridge.bridgeRequestScopeAjaxEnabled"), (boolean)false);
        }
        if (bridgeRequestScopeEnabled) {
            PortletSession portletSession;
            String portletName = this.portletConfig.getPortletName();
            String bridgeRequestScopeKey = portletName + PARAM_BRIDGE_REQUEST_SCOPE_ID;
            String bridgeRequestScopeId = portletRequest.getParameter(bridgeRequestScopeKey);
            if (bridgeRequestScopeId != null) {
                this.bridgeRequestScope = (BridgeRequestScope)this.bridgeRequestScopeCache.get(bridgeRequestScopeId);
                if (this.bridgeRequestScope != null) {
                    logger.debug("Found render parameter name=[{0}] value=[{1}] and cached bridgeRequestScope=[{2}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId, this.bridgeRequestScope});
                } else {
                    logger.error("Found render parameter name=[{0}] value=[{1}] BUT bridgeRequestScope is NOT in the cache", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                }
            }
            if (this.bridgeRequestScope == null && (bridgeRequestScopeId = (String)(portletSession = portletRequest.getPortletSession()).getAttribute(bridgeRequestScopeKey)) != null) {
                portletSession.removeAttribute(bridgeRequestScopeKey);
                this.bridgeRequestScope = (BridgeRequestScope)this.bridgeRequestScopeCache.get(bridgeRequestScopeId);
                if (this.bridgeRequestScope != null) {
                    logger.debug("Found (and removed) session-attribute name=[{0}] value=[{1}] and cached bridgeRequestScope=[{2}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId, this.bridgeRequestScope});
                    if (portletResponse instanceof StateAwareResponse) {
                        logger.debug("Setting former session-attribute as render parameter name=[{0}] value=[{1}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                        StateAwareResponse stateAwareResponse = (StateAwareResponse)portletResponse;
                        stateAwareResponse.setRenderParameter(bridgeRequestScopeKey, bridgeRequestScopeId);
                    }
                } else {
                    logger.error("Found session attribute name=[{0}] value=[{1}] but bridgeRequestScope is not in the cache", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                }
            }
            if (this.bridgeRequestScope == null) {
                BridgeRequestScopeFactory bridgeRequestScopeFactory = (BridgeRequestScopeFactory)BridgeFactoryFinder.getFactory(BridgeRequestScopeFactory.class);
                this.bridgeRequestScope = bridgeRequestScopeFactory.getBridgeRequestScope(this.portletConfig, this.portletContext, portletRequest);
            }
        }
    }

    protected void maintainBridgeRequestScope(PortletRequest portletRequest, PortletResponse portletResponse, BridgeRequestScope.Transport bridgeRequestScopeTransport) {
        block5: {
            String bridgeRequestScopeId = this.bridgeRequestScope.getId();
            this.bridgeRequestScopeCache.put(bridgeRequestScopeId, this.bridgeRequestScope);
            String bridgeRequestScopeKey = this.portletName + PARAM_BRIDGE_REQUEST_SCOPE_ID;
            if (bridgeRequestScopeTransport == BridgeRequestScope.Transport.PORTLET_SESSION_ATTRIBUTE) {
                PortletSession portletSession = portletRequest.getPortletSession(true);
                portletSession.setAttribute(bridgeRequestScopeKey, (Object)bridgeRequestScopeId);
            } else if (portletResponse instanceof StateAwareResponse) {
                logger.debug("Setting render parameter name=[{0}] value=[{1}]", new Object[]{bridgeRequestScopeKey, bridgeRequestScopeId});
                try {
                    StateAwareResponse stateAwareResponse = (StateAwareResponse)portletResponse;
                    stateAwareResponse.setRenderParameter(bridgeRequestScopeKey, bridgeRequestScopeId);
                }
                catch (IllegalStateException e) {
                    if (this.bridgeRequestScope.isRedirectOccurred()) break block5;
                    throw e;
                }
            }
        }
    }

    protected FacesContext getFacesContext(PortletRequest portletRequest, PortletResponse portletResponse, Lifecycle lifecycle) throws FacesException {
        FacesContext newFacesContext = this.getFacesContextFactory().getFacesContext((Object)this.portletContext, (Object)portletRequest, (Object)portletResponse, lifecycle);
        ELContext elContext = newFacesContext.getELContext();
        elContext.putContext(FacesContext.class, (Object)newFacesContext);
        return newFacesContext;
    }

    protected FacesContextFactory getFacesContextFactory() throws FacesException {
        if (this.facesContextFactory == null) {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        return this.facesContextFactory;
    }

    protected String getInitParameter(String name) {
        String initParameter = this.portletConfig.getInitParameter(name);
        if (initParameter == null) {
            initParameter = this.portletContext.getInitParameter(name);
        }
        return initParameter;
    }
}

