/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge;

import com.liferay.faces.bridge.BridgeFactoryFinder;
import com.liferay.faces.bridge.BridgePhase;
import com.liferay.faces.bridge.BridgePhaseFactory;
import com.liferay.faces.bridge.scope.BridgeRequestScopeManager;
import com.liferay.faces.bridge.scope.BridgeRequestScopeManagerFactory;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgeUninitializedException;

public class BridgeImpl
implements Bridge {
    private static final Logger logger = LoggerFactory.getLogger(BridgeImpl.class);
    private boolean initialized = false;
    private BridgePhaseFactory bridgePhaseFactory;
    private PortletConfig portletConfig;

    public void destroy() {
        this.initialized = false;
        try {
            BridgeRequestScopeManagerFactory bridgeRequestScopeManagerFactory = (BridgeRequestScopeManagerFactory)BridgeFactoryFinder.getFactory(BridgeRequestScopeManagerFactory.class);
            BridgeRequestScopeManager bridgeRequestScopeManager = bridgeRequestScopeManagerFactory.getBridgeRequestScopeManager();
            bridgeRequestScopeManager.removeBridgeRequestScopesByPortlet(this.portletConfig);
        }
        catch (Throwable t) {
            logger.warn(t.getMessage());
        }
    }

    public void doFacesRequest(ActionRequest actionRequest, ActionResponse actionResponse) throws BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        if (!this.initialized) {
            throw new BridgeUninitializedException();
        }
        BridgePhase bridgePhase = this.bridgePhaseFactory.getBridgeActionPhase(actionRequest, actionResponse, this.portletConfig);
        bridgePhase.execute();
    }

    public void doFacesRequest(EventRequest eventRequest, EventResponse eventResponse) throws BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)eventRequest, (PortletResponse)eventResponse);
        if (!this.initialized) {
            throw new BridgeUninitializedException();
        }
        BridgePhase bridgePhase = this.bridgePhaseFactory.getBridgeEventPhase(eventRequest, eventResponse, this.portletConfig);
        bridgePhase.execute();
    }

    public void doFacesRequest(RenderRequest renderRequest, RenderResponse renderResponse) throws BridgeDefaultViewNotSpecifiedException, BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        if (!this.initialized) {
            throw new BridgeUninitializedException();
        }
        BridgePhase bridgePhase = this.bridgePhaseFactory.getBridgeRenderPhase(renderRequest, renderResponse, this.portletConfig);
        bridgePhase.execute();
    }

    public void doFacesRequest(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws BridgeUninitializedException, BridgeException {
        this.checkNull((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        if (!this.initialized) {
            throw new BridgeUninitializedException();
        }
        BridgePhase bridgePhase = this.bridgePhaseFactory.getBridgeResourcePhase(resourceRequest, resourceResponse, this.portletConfig);
        bridgePhase.execute();
    }

    public void init(PortletConfig portletConfig) throws BridgeException {
        StringBuilder logMessage = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss,SSS");
        String timestamp = dateFormat.format(Calendar.getInstance().getTime());
        logMessage.append(timestamp);
        logMessage.append(" ");
        logMessage.append("INFO");
        logMessage.append(" ");
        logMessage.append(" ");
        logMessage.append("[BridgeImpl] Initializing");
        logMessage.append(" ");
        logMessage.append(this.getTitle());
        logMessage.append(" ");
        logMessage.append(this.getVersion());
        System.out.println(logMessage.toString());
        this.initialized = true;
        this.portletConfig = portletConfig;
        BridgeFactoryFinder.setPortletConfig(portletConfig);
        this.bridgePhaseFactory = (BridgePhaseFactory)BridgeFactoryFinder.getFactory(BridgePhaseFactory.class);
    }

    protected void checkNull(PortletRequest portletRequest, PortletResponse portletResponse) {
        if (portletRequest == null) {
            throw new NullPointerException("portletRequest was null");
        }
        if (portletResponse == null) {
            throw new NullPointerException("portletResponse was null");
        }
    }

    public String getTitle() {
        return BridgeImpl.class.getPackage().getImplementationTitle();
    }

    public String getVersion() {
        return BridgeImpl.class.getPackage().getImplementationVersion();
    }
}

