/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.bridge;

import com.liferay.faces.bridge.FactoryWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.portlet.PortletConfig;
import javax.portlet.faces.BridgeException;

public abstract class BridgeFactoryFinder {
    private static BridgeFactoryFinder staticInstance;
    private static PortletConfig staticPortletConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getClassPathResourceAsString(String resourcePath) {
        InputStream inputStream;
        String classPathResourceAsString = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(resourcePath)) != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                classPathResourceAsString = bufferedReader.readLine();
            }
            catch (IOException e) {
                System.err.println("Unable to read contents of resourcePath=[" + resourcePath + "]");
            }
            finally {
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return classPathResourceAsString;
    }

    public static FactoryWrapper<?> getFactory(Class<? extends FactoryWrapper<?>> clazz) {
        return BridgeFactoryFinder.getInstance().getFactoryInstance(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BridgeFactoryFinder getInstance() {
        if (staticInstance == null) {
            if (staticPortletConfig == null) {
                throw new BridgeException("Must first call setPortletConfig(PortletConfig)");
            }
            PortletConfig portletConfig = staticPortletConfig;
            synchronized (portletConfig) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    String bridgeFactoryFinderService = "META-INF/services/com.liferay.faces.bridge.BridgeFactoryFinder";
                    String bridgeFactoryFinderClassName = BridgeFactoryFinder.getClassPathResourceAsString(bridgeFactoryFinderService);
                    if (bridgeFactoryFinderClassName == null) {
                        throw new BridgeException("Unable to load resource=[" + bridgeFactoryFinderService + "]");
                    }
                    Class<?> bridgeFactoryFinderClass = classLoader.loadClass(bridgeFactoryFinderClassName);
                    staticInstance = (BridgeFactoryFinder)bridgeFactoryFinderClass.newInstance();
                    staticInstance.init(staticPortletConfig);
                }
                catch (Exception e) {
                    throw new BridgeException(e);
                }
            }
        }
        return staticInstance;
    }

    public static PortletConfig getPortletConfig() {
        return staticPortletConfig;
    }

    public static synchronized void setPortletConfig(PortletConfig portletConfig) {
        staticPortletConfig = portletConfig;
    }

    public abstract void init(PortletConfig var1);

    public abstract FactoryWrapper<?> getFactoryInstance(Class<? extends FactoryWrapper<?>> var1);
}

