/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeEventHandler;
import javax.portlet.faces.BridgePublicRenderParameterHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFacesPortlet
extends GenericPortlet {
    public static final String BRIDGE_CLASS = "javax.portlet.faces.BridgeImplClass";
    public static final String BRIDGE_SERVICE_CLASSPATH = "META-INF/services/javax.portlet.faces.Bridge";
    public static final String DEFAULT_VIEWID = "javax.portlet.faces.defaultViewId";
    private static final String BRIDGE_AUTO_DISPATCH_EVENTS = "javax.portlet.faces.autoDispatchEvents";
    private static final String CHAR_COMMA = ",";
    private static final String CHAR_DOT = ".";
    private Boolean autoDispatchEvents;
    private Bridge bridge;
    private String bridgeClassName;
    private BridgeEventHandler bridgeEventHandler;
    private BridgePublicRenderParameterHandler bridgePublicRenderParameterHandler;
    private Map<String, String> defaultViewIdMap;
    private List<String> excludedRequestAttributes;
    private String portletName;
    private Boolean preserveActionParameters;

    public void destroy() {
        try {
            this.getBridge().destroy();
        }
        catch (PortletException e) {
            e.printStackTrace();
        }
        super.destroy();
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        String defaultRenderKitId;
        BridgePublicRenderParameterHandler bridgePublicRenderParameterHandlerInstance;
        this.portletName = portletConfig.getPortletName();
        super.init(portletConfig);
        this.getBridge().init(portletConfig);
        PortletContext portletContext = portletConfig.getPortletContext();
        String attributeName = "javax.portlet.faces." + this.portletName + CHAR_DOT + "defaultViewIdMap";
        portletContext.setAttribute(attributeName, this.getDefaultViewIdMap());
        attributeName = "javax.portlet.faces." + this.portletName + CHAR_DOT + "excludedRequestAttributes";
        portletContext.setAttribute(attributeName, this.getExcludedRequestAttributes());
        attributeName = "javax.portlet.faces." + this.portletName + CHAR_DOT + "preserveActionParams";
        portletContext.setAttribute(attributeName, (Object)new Boolean(this.isPreserveActionParameters()));
        BridgeEventHandler bridgeEventHandlerInstance = this.getBridgeEventHandler();
        if (bridgeEventHandlerInstance != null) {
            attributeName = "javax.portlet.faces." + portletConfig.getPortletName() + CHAR_DOT + "bridgeEventHandler";
            portletContext.setAttribute(attributeName, (Object)bridgeEventHandlerInstance);
        }
        if ((bridgePublicRenderParameterHandlerInstance = this.getBridgePublicRenderParameterHandler()) != null) {
            String bridgeEventHandlerAttributeName = "javax.portlet.faces." + portletConfig.getPortletName() + CHAR_DOT + "bridgePublicRenderParameterHandler";
            portletContext.setAttribute(bridgeEventHandlerAttributeName, (Object)bridgePublicRenderParameterHandlerInstance);
        }
        if ((defaultRenderKitId = this.getDefaultRenderKitId()) != null) {
            portletContext.setAttribute("javax.portlet.faces." + portletConfig.getPortletName() + CHAR_DOT + "defaultRenderKitId", (Object)defaultRenderKitId);
        }
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        bridge.doFacesRequest(actionRequest, actionResponse);
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws PortletException, IOException {
        if (this.isAutoDispatchEvents()) {
            Bridge bridge = this.getFacesBridge((PortletRequest)eventRequest, (PortletResponse)eventResponse);
            bridge.doFacesRequest(eventRequest, eventResponse);
        } else {
            super.processEvent(eventRequest, eventResponse);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        bridge.doFacesRequest(resourceRequest, resourceResponse);
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        String nonFacesTargetPath = renderRequest.getParameter("_jsfBridgeNonFacesView");
        if (nonFacesTargetPath != null) {
            PortletContext portletContext = this.getPortletContext();
            String responseContentType = renderRequest.getResponseContentType();
            renderResponse.setContentType(responseContentType);
            PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher(nonFacesTargetPath);
            try {
                portletRequestDispatcher.forward((PortletRequest)renderRequest, (PortletResponse)renderResponse);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        bridge.doFacesRequest(renderRequest, renderResponse);
    }

    protected void doHeaders(RenderRequest renderRequest, RenderResponse renderResponse) {
        try {
            Object renderPartAttribute = renderRequest.getAttribute("javax.portlet.render_part");
            if (renderPartAttribute != null && renderPartAttribute.equals("RENDER_HEADERS")) {
                Bridge bridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
                bridge.doFacesRequest(renderRequest, renderResponse);
            }
        }
        catch (PortletException e) {
            e.printStackTrace();
        }
    }

    protected void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        bridge.doFacesRequest(renderRequest, renderResponse);
    }

    protected void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException, IOException {
        Bridge bridge = this.getFacesBridge((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        bridge.doFacesRequest(renderRequest, renderResponse);
    }

    protected Bridge getBridge() throws PortletException {
        String bridgeClassName;
        if (this.bridge == null && (bridgeClassName = this.getBridgeClassName()) != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> bridgeClass = classLoader.loadClass(bridgeClassName);
                this.bridge = (Bridge)bridgeClass.newInstance();
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        return this.bridge;
    }

    public String getBridgeClassName() {
        if (this.bridgeClassName == null) {
            this.bridgeClassName = this.getPortletConfig().getInitParameter(BRIDGE_CLASS);
            if (this.bridgeClassName == null) {
                this.bridgeClassName = this.getClassPathResourceAsString(BRIDGE_SERVICE_CLASSPATH);
            }
        }
        return this.bridgeClassName;
    }

    protected BridgeEventHandler getBridgeEventHandler() throws PortletException {
        if (this.bridgeEventHandler == null) {
            String initParamName = "javax.portlet.faces.bridgeEventHandler";
            String className = this.getPortletConfig().getInitParameter(initParamName);
            if (className != null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    this.bridgeEventHandler = (BridgeEventHandler)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                }
            }
        }
        return this.bridgeEventHandler;
    }

    protected BridgePublicRenderParameterHandler getBridgePublicRenderParameterHandler() throws PortletException {
        if (this.bridgePublicRenderParameterHandler == null) {
            String initParamName = "javax.portlet.faces.bridgePublicRenderParameterHandler";
            String className = this.getPortletConfig().getInitParameter(initParamName);
            if (className != null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    this.bridgePublicRenderParameterHandler = (BridgePublicRenderParameterHandler)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new PortletException((Throwable)e);
                }
            }
        }
        return this.bridgePublicRenderParameterHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getClassPathResourceAsString(String resourcePath) {
        InputStream inputStream;
        String classPathResourceAsString = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(resourcePath)) != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                classPathResourceAsString = bufferedReader.readLine();
            }
            catch (IOException e) {
                System.err.println("Unable to read contents of resourcePath=[" + resourcePath + "]");
            }
            finally {
                try {
                    bufferedReader.close();
                    inputStreamReader.close();
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return classPathResourceAsString;
    }

    public String getDefaultRenderKitId() {
        return this.getPortletConfig().getInitParameter("javax.portlet.faces.defaultRenderKitId");
    }

    public Map<String, String> getDefaultViewIdMap() {
        if (this.defaultViewIdMap == null) {
            this.defaultViewIdMap = new HashMap<String, String>();
            Enumeration initParameterNames = this.getPortletConfig().getInitParameterNames();
            if (initParameterNames != null) {
                int defaultViewIdLength = DEFAULT_VIEWID.length();
                int portletModeIndex = defaultViewIdLength + 1;
                while (initParameterNames.hasMoreElements()) {
                    String initParameterName = (String)initParameterNames.nextElement();
                    if (initParameterName == null || !initParameterName.startsWith(DEFAULT_VIEWID) || initParameterName.length() <= defaultViewIdLength) continue;
                    String initParameterValue = this.getPortletConfig().getInitParameter(initParameterName);
                    String portletMode = initParameterName.substring(portletModeIndex);
                    this.defaultViewIdMap.put(portletMode, initParameterValue);
                }
            }
        }
        return this.defaultViewIdMap;
    }

    public List<String> getExcludedRequestAttributes() {
        if (this.excludedRequestAttributes == null) {
            String initParamName = "javax.portlet.faces.excludedRequestAttributes";
            String initParamValue = this.getPortletConfig().getInitParameter(initParamName);
            if (initParamValue != null) {
                String[] values;
                this.excludedRequestAttributes = new ArrayList<String>();
                for (String value : values = initParamValue.split(CHAR_COMMA)) {
                    this.excludedRequestAttributes.add(value.trim());
                }
            }
        }
        return this.excludedRequestAttributes;
    }

    public Bridge getFacesBridge(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
        String viewId = portletRequest.getParameter("_jsfBridgeViewId");
        if (viewId != null) {
            portletRequest.setAttribute("javax.portlet.faces.viewId", (Object)viewId);
        } else {
            String viewPath = portletRequest.getParameter("_jsfBridgeViewPath");
            if (viewPath != null) {
                portletRequest.setAttribute("javax.portlet.faces.viewPath", (Object)viewPath);
            }
        }
        return this.getBridge();
    }

    public String getPortletName() {
        return this.portletName;
    }

    @Deprecated
    public String getResponseCharacterSetEncoding(PortletRequest portletRequest) {
        return null;
    }

    @Deprecated
    public String getResponseContentType(PortletRequest portletRequest) {
        return portletRequest.getResponseContentType();
    }

    public boolean isAutoDispatchEvents() {
        if (this.autoDispatchEvents == null) {
            String initParamValue = this.getPortletConfig().getInitParameter(BRIDGE_AUTO_DISPATCH_EVENTS);
            this.autoDispatchEvents = initParamValue != null ? Boolean.valueOf(Boolean.parseBoolean(initParamValue)) : Boolean.TRUE;
        }
        return this.autoDispatchEvents;
    }

    public boolean isPreserveActionParameters() {
        if (this.preserveActionParameters == null) {
            String initParamName = "javax.portlet.faces.preserveActionParams";
            String initParamValue = this.getPortletConfig().getInitParameter(initParamName);
            this.preserveActionParameters = initParamValue != null ? Boolean.valueOf(Boolean.parseBoolean(initParamValue)) : Boolean.FALSE;
        }
        return this.preserveActionParameters;
    }
}

