/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.render.internal;

import com.liferay.faces.util.client.BrowserSniffer;
import com.liferay.faces.util.render.JavaScriptFragment;
import com.liferay.faces.util.render.RendererUtil;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class AlloyRendererUtil {
    public static String getAlloyBeginScript(String[] modules, String yuiConfig, BrowserSniffer browserSniffer) {
        TreeSet<String> sortedModules = null;
        if (modules != null) {
            sortedModules = new TreeSet<String>();
            for (String module : modules) {
                sortedModules.add(module.trim());
            }
        }
        return AlloyRendererUtil.getAlloyBeginScript(sortedModules, yuiConfig, browserSniffer);
    }

    public static String getAlloyBeginScript(Set<String> sortedModules, String yuiConfig, BrowserSniffer browserSniffer) {
        StringBuilder stringBuilder = new StringBuilder();
        String loadMethod = "use";
        boolean browserIE = browserSniffer.isIe();
        float browserMajorVersion = browserSniffer.getMajorVersion();
        if (browserIE && browserMajorVersion < 8.0f) {
            loadMethod = "ready";
        }
        if (yuiConfig != null && yuiConfig.length() > 0) {
            stringBuilder.append("YUI(");
            stringBuilder.append(yuiConfig);
        } else {
            stringBuilder.append("AUI(");
        }
        stringBuilder.append(").");
        stringBuilder.append(loadMethod);
        stringBuilder.append("(");
        if (sortedModules != null) {
            for (String module : sortedModules) {
                stringBuilder.append("'");
                stringBuilder.append(module);
                stringBuilder.append("',");
            }
        }
        stringBuilder.append("function(A){");
        return stringBuilder.toString();
    }

    public static JavaScriptFragment[] toEscapedJavaScriptStringArray(List<String> strings) {
        String[] stringsArray = strings.toArray(new String[strings.size()]);
        return AlloyRendererUtil.toEscapedJavaScriptStringArray(stringsArray);
    }

    public static JavaScriptFragment[] toEscapedJavaScriptStringArray(String[] strings) {
        JavaScriptFragment[] escapedJavaScriptStringArray = new JavaScriptFragment[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String escapedJavaScript = RendererUtil.escapeJavaScript((String)strings[i]);
            escapedJavaScriptStringArray[i] = new JavaScriptFragment("'" + escapedJavaScript + "'");
        }
        return escapedJavaScriptStringArray;
    }
}

