/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.video.internal;

import com.liferay.faces.alloy.component.media.Media;
import com.liferay.faces.alloy.component.video.Video;
import com.liferay.faces.alloy.component.video.internal.VideoRendererBase;
import java.io.IOException;
import java.net.URLEncoder;
import javax.faces.application.Application;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="com.liferay.faces.alloy.component.media", rendererType="com.liferay.faces.alloy.component.video.VideoRenderer")
public class VideoRenderer
extends VideoRendererBase {
    @Override
    protected void encodeCustomMediaAttributes(FacesContext facesContext, ResponseWriter responseWriter, Media media) throws IOException {
        Video video = (Video)media;
        Object poster = video.getPoster();
        if (poster != null) {
            Application application = facesContext.getApplication();
            ResourceHandler resourceHandler = application.getResourceHandler();
            String posterResourceURL = this.getEncodedResourceURL(facesContext, resourceHandler, application, poster);
            responseWriter.writeAttribute("poster", (Object)posterResourceURL, "poster");
        }
    }

    @Override
    protected void encodeFlashPlayerChildren(FacesContext facesContext, ResponseWriter responseWriter, Media media, String mediaResourceURL, ResourceHandler resourceHandler, Application application, boolean defaultFlashPlayer) throws IOException {
        UIComponent uiComponent;
        Video video = (Video)media;
        Object poster = video.getPoster();
        String posterResourceURL = null;
        if (poster != null) {
            posterResourceURL = this.getEncodedResourceURL(facesContext, resourceHandler, application, poster);
        }
        if (defaultFlashPlayer) {
            responseWriter.startElement("param", null);
            responseWriter.writeAttribute("name", (Object)"flashVars", null);
            StringBuilder stringBuilder = new StringBuilder();
            boolean controls = video.isControls();
            if (controls) {
                stringBuilder.append("controls=true&");
            }
            if (posterResourceURL != null) {
                stringBuilder.append("poster=");
                String encodedPosterResourceURL = URLEncoder.encode(posterResourceURL);
                stringBuilder.append(encodedPosterResourceURL);
                stringBuilder.append("&");
            }
            stringBuilder.append("src=");
            String encodedVideoResourceURL = URLEncoder.encode(mediaResourceURL, "UTF-8");
            stringBuilder.append(encodedVideoResourceURL);
            responseWriter.writeAttribute("value", (Object)stringBuilder.toString(), null);
            responseWriter.endElement("param");
        }
        if ((uiComponent = video.getFacet("flash")) != null) {
            uiComponent.encodeAll(facesContext);
        }
        if (posterResourceURL != null) {
            responseWriter.startElement("img", (UIComponent)video);
            responseWriter.writeAttribute("src", (Object)posterResourceURL, null);
            responseWriter.writeAttribute("alt", (Object)"", null);
        }
    }

    @Override
    protected String getDefaultFlashPlayerName() {
        return "aui/video/player.swf";
    }

    @Override
    protected String getHeight(Media media) {
        Video video = (Video)media;
        return video.getHeight();
    }

    @Override
    protected String getMediaType() {
        return "video";
    }

    @Override
    protected String getWidth(Media media) {
        Video video = (Video)media;
        return video.getWidth();
    }
}

