/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.tabview.internal;

import com.liferay.faces.alloy.component.data.internal.DataEncoderBase;
import com.liferay.faces.alloy.component.tab.Tab;
import com.liferay.faces.alloy.component.tab.internal.DataEncoderTabImpl;
import com.liferay.faces.alloy.component.tabview.TabView;
import com.liferay.faces.alloy.component.tabview.internal.TabViewRendererBase;
import com.liferay.faces.util.component.Styleable;
import com.liferay.faces.util.helper.IntegerHelper;
import com.liferay.faces.util.logging.Logger;
import com.liferay.faces.util.logging.LoggerFactory;
import com.liferay.faces.util.render.JavaScriptFragment;
import com.liferay.faces.util.render.RendererUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="javax.faces.Data", rendererType="com.liferay.faces.alloy.component.tabview.TabViewRenderer")
@ResourceDependencies(value={@ResourceDependency(library="liferay-faces-alloy", name="alloy.css"), @ResourceDependency(library="liferay-faces-alloy", name="alloy.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui-css/css/bootstrap.min.css"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="build/aui/aui-min.js"), @ResourceDependency(library="liferay-faces-alloy-reslib", name="liferay.js")})
public class TabViewRenderer
extends TabViewRendererBase {
    private static final String SELECTED_TAB_HEADER_CLASSES = "tab yui3-widget active tab-selected";
    private static final String UNSELECTED_TAB_HEADER_CLASSES = "tab yui3-widget";
    private static final Logger logger = LoggerFactory.getLogger(TabViewRenderer.class);

    private static int getIntegerOrDefault(Integer i, int defaultValue) {
        if (i != null) {
            return i;
        }
        return defaultValue;
    }

    public void decodeClientState(FacesContext facesContext, UIComponent uiComponent) {
        TabView tabView = (TabView)uiComponent;
        String hiddenFieldName = tabView.getClientId(facesContext) + "selectedIndex";
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String selectedIndex = (String)requestParameterMap.get(hiddenFieldName);
        if (selectedIndex != null) {
            tabView.setSelectedIndex(IntegerHelper.toInteger((String)selectedIndex, (int)-1));
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        TabView tabView = (TabView)uiComponent;
        Integer selectedIndex = tabView.getSelectedIndex();
        boolean iterateOverDataModel = DataEncoderBase.isIterateOverDataModel(tabView);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("ul", (UIComponent)tabView);
        responseWriter.writeAttribute("class", (Object)"nav nav-tabs", null);
        DataEncoderTabImpl dataEncoder = new DataEncoderTabHeaderImpl(selectedIndex);
        dataEncoder.encodeColumns(facesContext, tabView, iterateOverDataModel);
        responseWriter.endElement("ul");
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("class", (Object)"tab-content", null);
        dataEncoder = new DataEncoderTabImpl();
        dataEncoder.encodeColumns(facesContext, tabView, iterateOverDataModel);
        tabView.setRowIndex(-1);
        responseWriter.endElement("div");
    }

    public void encodeClientState(FacesContext facesContext, ResponseWriter responseWriter, UIComponent uiComponent) throws IOException {
        TabView tabView = (TabView)uiComponent;
        responseWriter.startElement("input", (UIComponent)tabView);
        String hiddenFieldName = tabView.getClientId(facesContext) + "selectedIndex";
        responseWriter.writeAttribute("id", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("name", (Object)hiddenFieldName, null);
        responseWriter.writeAttribute("type", (Object)"hidden", null);
        responseWriter.writeAttribute("value", (Object)tabView.getSelectedIndex(), null);
        responseWriter.endElement("input");
    }

    @Override
    public void encodeJavaScriptCustom(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        TabView tabView = (TabView)uiComponent;
        String clientVarName = this.getClientVarName(facesContext, tabView);
        String clientKey = tabView.getClientKey();
        if (clientKey == null) {
            clientKey = clientVarName;
        }
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        this.encodeLiferayComponentVar(responseWriter, clientVarName, clientKey);
        Integer selectedIndex = tabView.getSelectedIndex();
        DataEncoderTabJavaScriptImpl dataEncoder = new DataEncoderTabJavaScriptImpl(selectedIndex, clientVarName);
        dataEncoder.encodeColumns(facesContext, tabView);
        String clientId = uiComponent.getClientId(facesContext);
        String hiddenFieldId = clientId + "selectedIndex";
        StringBuilder clientBehaviorsArrayStringBuilder = new StringBuilder();
        clientBehaviorsArrayStringBuilder.append("[");
        boolean first = true;
        Map clientBehaviorMap = tabView.getClientBehaviors();
        Collection<String> eventNames = tabView.getEventNames();
        for (String eventName : eventNames) {
            List clientBehaviorsForEvent = (List)clientBehaviorMap.get(eventName);
            if (clientBehaviorsForEvent == null) continue;
            for (ClientBehavior clientBehavior : clientBehaviorsForEvent) {
                ClientBehaviorContext clientBehaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)tabView, (String)eventName, (String)clientId, null);
                if (!"tabSelect".equals(eventName)) continue;
                if (!first) {
                    clientBehaviorsArrayStringBuilder.append(",");
                }
                clientBehaviorsArrayStringBuilder.append("function(event){");
                clientBehaviorsArrayStringBuilder.append(clientBehavior.getScript(clientBehaviorContext));
                clientBehaviorsArrayStringBuilder.append("}");
                first = false;
            }
        }
        clientBehaviorsArrayStringBuilder.append("]");
        this.encodeFunctionCall(responseWriter, "LFAI.initTabView", new Object[]{new JavaScriptFragment(clientVarName), hiddenFieldId, clientId, new JavaScriptFragment(clientBehaviorsArrayStringBuilder.toString())});
    }

    public void encodeMarkupBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.startElement("div", uiComponent);
        responseWriter.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), "id");
        RendererUtil.encodeStyleable((ResponseWriter)responseWriter, (Styleable)((Styleable)uiComponent), (String[])new String[0]);
    }

    public void encodeMarkupEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        responseWriter.endElement("div");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void encodeHiddenAttributes(FacesContext facesContext, ResponseWriter responseWriter, TabView tabView, boolean first) throws IOException {
        this.encodeWidgetRender(responseWriter, first);
        first = false;
        this.encodeClientId(responseWriter, "srcNode", tabView.getClientId(facesContext), first);
    }

    private static class DataEncoderTabJavaScriptImpl
    extends DataEncoderTabImpl {
        private final String clientVarName;
        private final int selectedIndex;
        int clientSideTabIndex = 0;

        public DataEncoderTabJavaScriptImpl(Integer selectedIndex, String clientVarName) {
            this.selectedIndex = TabViewRenderer.getIntegerOrDefault(selectedIndex, -1);
            this.clientVarName = clientVarName;
        }

        @Override
        protected void encodeColumn(FacesContext facesContext, UIData uiData, UIColumn currentUIColumn, int currentIndex) throws IOException {
            if (currentUIColumn instanceof Tab && currentUIColumn.isRendered()) {
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                String clientSideTabIndexString = Integer.toString(this.clientSideTabIndex);
                Tab childTab = (Tab)currentUIColumn;
                if (childTab.isDisabled()) {
                    responseWriter.write(this.clientVarName);
                    responseWriter.write(".disableTab(");
                    responseWriter.write(clientSideTabIndexString);
                    responseWriter.write(");");
                } else {
                    responseWriter.write(this.clientVarName);
                    responseWriter.write(".enableTab(");
                    responseWriter.write(clientSideTabIndexString);
                    responseWriter.write(");");
                    if (currentIndex == this.selectedIndex) {
                        responseWriter.write(this.clientVarName);
                        responseWriter.write(".selectChild(");
                        responseWriter.write(clientSideTabIndexString);
                        responseWriter.write(");");
                    }
                }
                ++this.clientSideTabIndex;
            }
        }
    }

    private static class DataEncoderTabHeaderImpl
    extends DataEncoderTabImpl {
        private final int selectedIndex;

        public DataEncoderTabHeaderImpl(Integer selectedIndex) {
            this.selectedIndex = TabViewRenderer.getIntegerOrDefault(selectedIndex, -1);
        }

        @Override
        protected void encodeColumn(FacesContext facesContext, UIData uiData, UIColumn currentUIColumn, int serverSideIndex) throws IOException {
            if (currentUIColumn instanceof Tab && currentUIColumn.isRendered()) {
                String tabHeaderClass;
                boolean selected;
                ResponseWriter responseWriter = facesContext.getResponseWriter();
                Tab tab = (Tab)currentUIColumn;
                responseWriter.startElement("li", (UIComponent)tab);
                String tabClasses = TabViewRenderer.UNSELECTED_TAB_HEADER_CLASSES;
                boolean bl = selected = serverSideIndex == this.selectedIndex;
                if (selected) {
                    tabClasses = TabViewRenderer.SELECTED_TAB_HEADER_CLASSES;
                }
                if ((tabHeaderClass = tab.getHeaderClass()) != null) {
                    tabClasses = tabClasses + " " + tabHeaderClass;
                }
                tabClasses = tabClasses + " serverSideIndex" + serverSideIndex;
                responseWriter.writeAttribute("class", (Object)tabClasses, "styleClass");
                responseWriter.startElement("a", (UIComponent)tab);
                if (tab.isDisabled()) {
                    responseWriter.writeAttribute("disabled", (Object)"disabled", null);
                }
                String clientId = tab.getClientId(facesContext);
                responseWriter.writeAttribute("href", (Object)("#" + clientId), null);
                UIComponent headerFacet = tab.getFacet("header");
                if (headerFacet != null) {
                    headerFacet.encodeAll(facesContext);
                } else {
                    String headerText = tab.getHeaderText();
                    if (headerText != null) {
                        responseWriter.write(headerText);
                    }
                }
                responseWriter.endElement("a");
                responseWriter.endElement("li");
            }
        }
    }
}

