/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.faces.alloy.component.selectrating.internal;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public class SelectRatingResponseWriter
extends ResponseWriterWrapper {
    public static final int NO_SELECTION_INDEX = -1;
    private long index;
    private boolean inputElement;
    private boolean labelElement;
    private String onClick;
    private long selectedIndex;
    private Object title;
    private ResponseWriter wrappedResponseWriter;

    public SelectRatingResponseWriter(ResponseWriter responseWriter) {
        this.wrappedResponseWriter = responseWriter;
        this.index = -1L;
        this.selectedIndex = -1L;
    }

    public void endElement(String name) throws IOException {
        if ("input".equalsIgnoreCase(name)) {
            this.inputElement = false;
        }
        if ("label".equalsIgnoreCase(name)) {
            this.labelElement = false;
            super.writeAttribute("title", this.title, "title");
            super.writeAttribute("style", (Object)"display:none;", null);
            super.endElement("input");
        }
    }

    public String getOnClick() {
        return this.onClick;
    }

    public long getSelectedIndex() {
        return this.selectedIndex;
    }

    public ResponseWriter getWrapped() {
        return this.wrappedResponseWriter;
    }

    public void setSelectedIndex(long selectedIndex) {
        this.selectedIndex = selectedIndex;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if ("input".equalsIgnoreCase(name)) {
            this.inputElement = true;
            this.title = null;
            ++this.index;
            super.startElement(name, component);
        } else if ("label".equalsIgnoreCase(name)) {
            this.labelElement = true;
        }
    }

    public void write(char[] chars, int off, int len) throws IOException {
        if (this.labelElement) {
            String newString = new String(chars, off, len);
            this.title = newString;
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.inputElement) {
            if ("checked".equals(name)) {
                this.setSelectedIndex(this.index);
            }
            super.writeAttribute(name, value, property);
        }
        if ("onclick".equalsIgnoreCase(name)) {
            this.onClick = (String)value;
        }
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        if (this.labelElement) {
            this.title = text;
        }
    }
}

